/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.notices;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import fr.abes.cbs.exception.ZoneException;
import fr.abes.cbs.notices.INotice;
import fr.abes.cbs.notices.TYPE_NOTICE;
import fr.abes.cbs.notices.Zone;
import fr.abes.cbs.notices.ZoneEtatColl;
import fr.abes.cbs.notices.sequences.SequenceEtatColl;
import fr.abes.cbs.notices.sequences.SequencePrimaire;
import fr.abes.cbs.utilitaire.Constants;
import fr.abes.cbs.utilitaire.Utilitaire;
import fr.abes.cbs.zones.ZonesSpecifications;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class Notice
implements INotice {
    protected ListMultimap<String, Zone> listeZones;

    public Notice() {
        this.initListeZones();
    }

    public Notice(List<Zone> listeZones) {
        this.initListeZones();
        for (Zone zone : listeZones) {
            this.listeZones.put((Object)zone.getLabel(), (Object)zone);
        }
    }

    public Notice(ListMultimap<String, Zone> listeZones) {
        this.listeZones = listeZones;
    }

    protected void initListeZones() {
        this.listeZones = MultimapBuilder.treeKeys((Comparator)new Comparator<String>(){

            @Override
            public int compare(String zone1, String zone2) {
                return ZonesSpecifications.getZoneSpecification((String)zone1, (TYPE_NOTICE)Notice.this.getType()).order.compareTo(ZonesSpecifications.getZoneSpecification((String)zone2, (TYPE_NOTICE)Notice.this.getType()).order);
            }
        }).linkedListValues().build();
    }

    protected void createNoticeFromXml(String noticeXml) throws DocumentException, ZoneException {
        Document doc = DocumentHelper.parseText((String)noticeXml);
        List listeZone = doc.selectNodes("//record/*");
        for (int i = 0; i < listeZone.size(); ++i) {
            Node zone = (Node)listeZone.get(i);
            if (!"datafield".equals(zone.getName())) continue;
            String zoneId = ((Element)zone).attributeValue("tag");
            int indexZone = this.findZones(zoneId).size();
            char[] indicateurs = Notice.getIndicateurs(zone);
            List listeSousZones = zone.selectNodes("*");
            this.traiterSousZonesXml(zoneId, indicateurs, listeSousZones, indexZone);
        }
    }

    protected void traiterSousZonesXml(String zoneId, char[] indicateurs, List<Node> listeSousZones, Integer indexZone) throws ZoneException {
        boolean isFirst = true;
        for (int k = 0; k < listeSousZones.size(); ++k) {
            if (!"subfield".equals(listeSousZones.get(k).getName())) continue;
            String codeId = ((Element)listeSousZones.get(k)).attributeValue("code");
            if (listeSousZones.get(k).getStringValue() == null) continue;
            if (isFirst) {
                if (zoneId.matches("e\\d\\d")) {
                    this.addZone(zoneId, "$" + codeId, listeSousZones.get(k).getStringValue());
                } else {
                    this.addZone(zoneId, "$" + codeId, listeSousZones.get(k).getStringValue(), indicateurs);
                }
                isFirst = false;
                continue;
            }
            this.addSousZone(zoneId, "$" + codeId, listeSousZones.get(k).getStringValue(), indexZone);
        }
    }

    public static char[] getIndicateurs(Node zone) {
        String ind1id = ((Element)zone).attributeValue("ind1");
        String ind2id = ((Element)zone).attributeValue("ind2");
        String ind1 = null;
        String ind2 = null;
        if (ind1id != null) {
            ind1 = ind1id;
        }
        if (ind2id != null) {
            ind2 = ind2id;
        }
        if (" ".equals(ind1)) {
            ind1 = "#";
        }
        if (" ".equals(ind2)) {
            ind2 = "#";
        }
        return (ind1 + ind2).toCharArray();
    }

    @Override
    public void addZone(String zone, String sousZone, String valeur) throws ZoneException {
        valeur = Utilitaire.deleteExpensionFromValue(valeur);
        Zone buffer = new Zone(zone, this.getType());
        buffer.addSubLabel(sousZone, valeur);
        this.listeZones.put((Object)zone, (Object)buffer);
    }

    @Override
    public void addZone(String zone, String sousZone, String valeur, char[] indicateurs) throws ZoneException {
        valeur = Utilitaire.deleteExpensionFromValue(valeur);
        Zone buffer = new Zone(zone, this.getType(), indicateurs);
        buffer.addSubLabel(sousZone, valeur);
        this.listeZones.put((Object)zone, (Object)buffer);
    }

    @Override
    public void addZone(String zone, String valeur) throws ZoneException {
        valeur = Utilitaire.deleteExpensionFromValue(valeur);
        this.listeZones.put((Object)zone, (Object)new Zone(zone, this.getType(), valeur));
    }

    @Override
    public void addZone(Zone zone) {
        if (zone != null) {
            this.listeZones.put((Object)zone.getLabel(), (Object)zone);
        }
    }

    @Override
    public void addZoneEtatCollection(String zone, String sousZone, String valeur, char[] indicateurs) throws ZoneException {
        ZoneEtatColl buffer = new ZoneEtatColl(zone, indicateurs);
        SequencePrimaire sequencePrimaire = new SequencePrimaire(sousZone + valeur, zone);
        SequenceEtatColl sequenceEtatColl = new SequenceEtatColl(sequencePrimaire);
        buffer.addSequence(sequenceEtatColl);
        this.listeZones.put((Object)zone, (Object)buffer);
    }

    @Override
    public List<Zone> findZones(String label) {
        ArrayList<Zone> zonesfinded = new ArrayList<Zone>();
        for (Zone localZone : this.listeZones.values()) {
            if (!localZone.getLabel().equals(label)) continue;
            zonesfinded.add(localZone);
        }
        return zonesfinded;
    }

    @Override
    public Zone findZone(String label, Integer index) {
        ArrayList<Zone> zonesFinded = new ArrayList<Zone>();
        for (Zone localZone : this.listeZones.values()) {
            if (!localZone.getLabel().equals(label)) continue;
            zonesFinded.add(localZone);
        }
        if (index < zonesFinded.size()) {
            return (Zone)zonesFinded.get(index);
        }
        return (Zone)zonesFinded.get(0);
    }

    @Override
    public List<Zone> findZoneWithPattern(String zone, String sousZone, String pattern) {
        ArrayList<Zone> zonesFinded = new ArrayList<Zone>();
        String strTarget = Normalizer.normalize(pattern, Normalizer.Form.NFD);
        for (Zone localZone : this.findZones(zone)) {
            localZone.getSubLabelTable().column((Object)sousZone).forEach((integer, s) -> {
                String strSource = Normalizer.normalize(s, Normalizer.Form.NFD);
                if (strSource.contains(strTarget)) {
                    zonesFinded.add(localZone);
                }
            });
        }
        return zonesFinded;
    }

    @Override
    public void replaceSousZoneWithValue(String zone, String sousZone, String valeurInit, String newValeur) {
        String strTarget = Normalizer.normalize(valeurInit, Normalizer.Form.NFD);
        for (Zone localZone : this.findZones(zone)) {
            localZone.getSubLabelTable().column((Object)sousZone).replaceAll((integer, s) -> {
                String strSource = Normalizer.normalize(s, Normalizer.Form.NFD);
                if (strSource.contains(strTarget)) {
                    return newValeur;
                }
                return s;
            });
        }
    }

    @Override
    public void addSousZone(String zone, String sousZone, String valeur) throws ZoneException {
        valeur = Utilitaire.deleteExpensionFromValue(valeur);
        if (Utilitaire.isCorectParameter(zone) && Utilitaire.isCorectParameter(sousZone) && Utilitaire.isCorectParameter(valeur)) {
            ListMultimap zonesToBeAdded = MultimapBuilder.treeKeys().linkedListValues().build();
            for (Zone localZone : this.findZones(zone)) {
                localZone.addSubLabel(sousZone, valeur);
                zonesToBeAdded.put((Object)zone, (Object)localZone);
            }
            this.deleteZone(zone);
            this.listeZones.putAll((Multimap)zonesToBeAdded);
        }
    }

    @Override
    public void addSousZone(String zone, String sousZone, String valeur, Integer index) throws ZoneException {
        Zone localZone;
        valeur = Utilitaire.deleteExpensionFromValue(valeur);
        if (Utilitaire.isCorectParameter(zone) && Utilitaire.isCorectParameter(sousZone) && Utilitaire.isCorectParameter(valeur) && (localZone = this.findZone(zone, index)) != null) {
            localZone.addSubLabel(sousZone, valeur);
            this.deleteZone(zone, index);
            this.listeZones.put((Object)localZone.getLabel(), (Object)localZone);
        }
    }

    @Override
    public void addSousZone(String zone, String sousZone, String valeur, String sousZoneBefore, String valeurBefore) throws ZoneException {
        valeurBefore = Utilitaire.deleteExpensionFromValue(valeurBefore);
        AtomicReference<ZoneException> ex = new AtomicReference<ZoneException>(new ZoneException(null));
        if (Utilitaire.isCorectParameter(zone) && Utilitaire.isCorectParameter(sousZone) && Utilitaire.isCorectParameter(valeur) && Utilitaire.isCorectParameter(sousZoneBefore) && Utilitaire.isCorectParameter(valeurBefore)) {
            ListMultimap zonesToBeAdded = MultimapBuilder.treeKeys().linkedListValues().build();
            for (Zone localZone : this.findZones(zone)) {
                String finalValeurBefore = valeurBefore;
                localZone.getSubLabelTable().rowMap().forEach((integer, stringStringMap) -> {
                    if (stringStringMap.get(sousZoneBefore) != null && ((String)stringStringMap.get(sousZoneBefore)).contains(finalValeurBefore)) {
                        try {
                            localZone.addSubLabel(sousZone, valeur);
                        }
                        catch (ZoneException e) {
                            ex.set(e);
                        }
                    }
                });
                if (ex.get().getMessage() != null) {
                    throw ex.get();
                }
                zonesToBeAdded.put((Object)zone, (Object)localZone);
            }
            this.deleteZone(zone);
            this.listeZones.putAll((Multimap)zonesToBeAdded);
        }
    }

    @Override
    public void deleteZone(String zone, Integer index) {
        Iterator it = this.listeZones.values().iterator();
        Integer i = 0;
        while (it.hasNext()) {
            Zone zonetodelete = (Zone)it.next();
            if (zonetodelete.getLabel().equals(zone) && (index == null || i == index)) {
                it.remove();
            }
            if (!zonetodelete.getLabel().equals(zone)) continue;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    @Override
    public void deleteZone(String zone) {
        this.deleteZone(zone, null);
    }

    @Override
    public void deleteZoneWithValue(String zone, String sousZone, String valeur) {
        Iterator it = this.listeZones.values().iterator();
        while (it.hasNext()) {
            Zone zoneToDelete = (Zone)it.next();
            if (!zoneToDelete.getLabel().equals(zone) || !zoneToDelete.findSubLabel(sousZone).contains(valeur)) continue;
            it.remove();
        }
    }

    @Override
    public void deleteSousZone(String zone, String sousZone) {
        Iterator it = this.listeZones.values().iterator();
        while (it.hasNext()) {
            Zone zoneToTreat = (Zone)it.next();
            if (!zoneToTreat.getLabel().equals(zone)) continue;
            zoneToTreat.deleteSubLabel(sousZone);
            if (!zoneToTreat.getSubLabelTable().isEmpty()) continue;
            it.remove();
        }
    }

    @Override
    public void replaceSousZone(String zone, String sousZone, String valeur) {
        valeur = Utilitaire.deleteExpensionFromValue(valeur);
        for (Zone localzone : this.findZones(zone)) {
            localzone.editSubLabel(sousZone, valeur);
        }
    }

    public String toString() {
        boolean zoneProtege = false;
        StringBuilder notice = new StringBuilder(Constants.STR_1F);
        for (Zone zoneATraiter : this.listeZones.values()) {
            if (zoneATraiter.getClass().isInstance(ZoneEtatColl.class)) {
                ZoneEtatColl zoneEnCours = (ZoneEtatColl)zoneATraiter;
                notice.append(zoneEnCours.toString());
                continue;
            }
            zoneProtege = this.genererZoneProtegee(zoneProtege, notice, zoneATraiter);
            notice.append(zoneATraiter.toString());
        }
        return notice.append(Constants.STR_1E).toString();
    }

    private boolean genererZoneProtegee(boolean zoneProtege, StringBuilder notice, Zone zoneEnCours) {
        if (zoneProtege) {
            notice.append(Constants.STR_1B).append("D");
            zoneProtege = false;
        }
        if (zoneEnCours.isProtected) {
            notice.append(Constants.STR_1B).append("P");
            zoneProtege = true;
        }
        return zoneProtege;
    }

    protected void genererZonesSansSousZone(String lineZone, String labelZone) throws ZoneException {
        Pattern pattern = Pattern.compile("^(\\x1b[PD])?(?<zStaName>[\\d]{3})? *(?<zSysSpace>\\s*)? *(?<zVal>.*)?");
        Matcher matcher = pattern.matcher(lineZone);
        while (matcher.find()) {
            if (matcher.group("zStaName") != null) {
                labelZone = matcher.group("zStaName");
            }
            if (matcher.group("zVal") == null) continue;
            this.addZone(labelZone, matcher.group("zVal"));
        }
    }

    @Override
    public ListMultimap<String, Zone> getListeZones() {
        return this.listeZones;
    }
}

