/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.notices;

import fr.abes.cbs.exception.NoticeException;
import fr.abes.cbs.exception.ZoneException;
import fr.abes.cbs.models.ExemplaireFromXml;
import fr.abes.cbs.notices.Biblio;
import fr.abes.cbs.notices.DonneeLocale;
import fr.abes.cbs.notices.Exemplaire;
import fr.abes.cbs.notices.FORMATS;
import fr.abes.cbs.notices.INotice;
import fr.abes.cbs.notices.Notice;
import fr.abes.cbs.notices.TYPE_NOTICE;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class NoticeConcrete
extends Notice
implements INotice {
    private Biblio noticeBiblio;
    private DonneeLocale noticeLocale;
    private List<Exemplaire> exemplaires = new ArrayList<Exemplaire>();

    public NoticeConcrete(String noticeXml) throws DocumentException, ZoneException, NoticeException {
        StringBuilder biblio = new StringBuilder("<record>");
        StringBuilder locale = new StringBuilder("<record>");
        StringBuilder exemplairesXML = new StringBuilder("<record>");
        Document doc = DocumentHelper.parseText((String)noticeXml);
        List listeZone = doc.selectNodes("//record/*");
        Pattern zoneBiblioPattern = Pattern.compile("^[0-8]\\d{2}");
        Pattern zoneLocalePattern = Pattern.compile("^[L]\\d{3}");
        Pattern zoneExemplairePattern = Pattern.compile("^([A|e]\\d{2})|^([E]\\d{3})|^([9]\\d{2})");
        for (int i = 0; i < listeZone.size(); ++i) {
            Node zone = (Node)listeZone.get(i);
            Matcher matcher = zoneBiblioPattern.matcher(((Element)zone).attributeValue("tag"));
            if (matcher.find()) {
                biblio.append(zone.asXML());
                continue;
            }
            matcher = zoneLocalePattern.matcher(((Element)zone).attributeValue("tag"));
            if (matcher.find()) {
                locale.append(zone.asXML());
                continue;
            }
            matcher = zoneExemplairePattern.matcher(((Element)zone).attributeValue("tag"));
            if (!matcher.find()) continue;
            exemplairesXML.append(zone.asXML());
        }
        biblio.append("</record>");
        locale.append("</record>");
        exemplairesXML.append("</record>");
        this.noticeBiblio = new Biblio(biblio.toString(), FORMATS.XML);
        this.noticeLocale = new DonneeLocale(locale.toString(), FORMATS.XML);
        List<ExemplaireFromXml> exemplairesFromXml = this.getListeExemplaireFromXml(exemplairesXML.toString());
        for (ExemplaireFromXml exemplaireFromXml : exemplairesFromXml) {
            String exemplaire = this.exemplaireXMLBuilder(exemplaireFromXml);
            this.exemplaires.add(new Exemplaire(exemplaire, FORMATS.XML));
        }
    }

    private String exemplaireXMLBuilder(ExemplaireFromXml exemplaireFromXml) {
        return "<record><datafield tag=\"930\" ind1=\" \" ind2=\" \"><subfield code=\"b\">" + exemplaireFromXml.rcr + "</subfield><subfield code=\"j\">g</subfield></datafield></record>";
    }

    public NoticeConcrete(Biblio biblio, DonneeLocale donneeLocale, List<Exemplaire> exemplaires) {
        this.noticeBiblio = biblio;
        this.noticeLocale = donneeLocale;
        this.exemplaires = exemplaires;
    }

    public static List<Exemplaire> listeExemplaireUnimarc(String listeExemplaire) throws Exception {
        ArrayList<Exemplaire> exemplaires = new ArrayList<Exemplaire>();
        String regex = "\\x1f(e\\d{2}.+?)\\x1e";
        Pattern pattern = Pattern.compile("\\x1f(e\\d{2}.+?)\\x1e", 32);
        Matcher matcher = pattern.matcher(listeExemplaire);
        while (matcher.find()) {
            exemplaires.add(new Exemplaire(matcher.group(0)));
        }
        return exemplaires;
    }

    @Override
    public String getNumEx() {
        return this.getExemplaires().size() == 0 ? null : String.format("%02d", this.getExemplaires().size());
    }

    @Override
    public TYPE_NOTICE getType() {
        return TYPE_NOTICE.CONCRETE;
    }

    @Override
    public String toString() {
        StringBuilder noticeToReturn = new StringBuilder();
        noticeToReturn.append(this.noticeBiblio.toString()).append("\r\n\r\n").append(this.noticeLocale.toString()).append("\r\n\r\n");
        for (Exemplaire exemp : this.exemplaires) {
            noticeToReturn.append(exemp.toString()).append("\r\n");
        }
        return noticeToReturn.toString();
    }

    public List<ExemplaireFromXml> getListeExemplaireFromXml(String notices) throws DocumentException {
        ArrayList<ExemplaireFromXml> listeExemp = new ArrayList<ExemplaireFromXml>();
        Document doc = DocumentHelper.parseText((String)notices);
        List listeZone = doc.selectNodes("//record/*");
        Pattern zoneExemplairePattern = Pattern.compile("930");
        for (int i = 0; i < listeZone.size(); ++i) {
            Node zone = (Node)listeZone.get(i);
            Matcher matcher = zoneExemplairePattern.matcher(((Element)zone).attributeValue("tag"));
            if (!matcher.find()) continue;
            listeExemp.add(new ExemplaireFromXml(((Node)zone.selectNodes("*").get(0)).getStringValue()));
        }
        return listeExemp;
    }

    public Biblio getNoticeBiblio() {
        return this.noticeBiblio;
    }

    public DonneeLocale getNoticeLocale() {
        return this.noticeLocale;
    }

    public List<Exemplaire> getExemplaires() {
        return this.exemplaires;
    }

    public NoticeConcrete() {
    }
}

