/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.notices;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Table;
import fr.abes.cbs.exception.ZoneException;
import fr.abes.cbs.notices.TYPE_NOTICE;
import fr.abes.cbs.utilitaire.Constants;
import fr.abes.cbs.zones.ZoneSpecification;
import fr.abes.cbs.zones.ZonesSpecifications;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Zone {
    protected String label;
    protected boolean isProtected;
    protected String valeur;
    protected char[] indicateurs;
    protected TYPE_NOTICE typeNotice;
    String specifications = "";
    List<String> specificationList = Arrays.asList(this.specifications.split(""));
    Table<Integer, String, String> subLabelTable = HashBasedTable.create();

    public Zone(String label, TYPE_NOTICE typeNotice, Table<Integer, String, String> subLabelTable) throws ZoneException {
        this.label = label;
        this.typeNotice = typeNotice;
        this.setSubLabelTable(subLabelTable);
        this.initSpecifications();
    }

    public Zone(String label, TYPE_NOTICE typeNotice, Table<Integer, String, String> subLabelTable, char[] indicateurs) throws ZoneException {
        this.label = label;
        this.typeNotice = typeNotice;
        this.setSubLabelTable(subLabelTable);
        this.indicateurs = indicateurs;
        this.initSpecifications();
    }

    public Zone(String label, TYPE_NOTICE typeNotice, String value) throws ZoneException {
        this.label = label;
        this.typeNotice = typeNotice;
        this.valeur = value;
        this.initSpecifications();
    }

    public Zone(String label, TYPE_NOTICE typeNotice, char[] indicateurs) throws ZoneException {
        this.label = label;
        this.typeNotice = typeNotice;
        this.indicateurs = indicateurs;
        this.initSpecifications();
    }

    public Zone(String label, TYPE_NOTICE typeNotice, char[] indicateurs, String value) throws ZoneException {
        this.label = label;
        this.typeNotice = typeNotice;
        this.indicateurs = indicateurs;
        this.valeur = value;
        this.initSpecifications();
    }

    public Zone(String label, TYPE_NOTICE typeNotice) throws ZoneException {
        this.label = label;
        this.typeNotice = typeNotice;
        this.initSpecifications();
    }

    private void setSubLabelTable(Table<Integer, String, String> subLabelTable) throws ZoneException {
        AtomicReference<ZoneException> ex = new AtomicReference<ZoneException>(new ZoneException(null));
        subLabelTable.rowMap().forEach((integer, stringStringMap) -> {
            Map.Entry singleSubLabel = stringStringMap.entrySet().stream().findFirst().orElse(null);
            assert (singleSubLabel != null);
            try {
                this.addSubLabel((String)singleSubLabel.getKey(), (String)singleSubLabel.getValue());
            }
            catch (ZoneException e) {
                ex.set(e);
            }
        });
        if (ex.get().getMessage() != null) {
            throw ex.get();
        }
    }

    public void addSubLabel(String subLabel, String value) throws ZoneException {
        if (!this.isInSpecification(subLabel = this.getStandardSubLabel(subLabel))) {
            throw new ZoneException("La sous-zone " + subLabel + " n'est pas reconnue dans la zone " + this.getLabelForOutput() + ". Valeur = " + value);
        }
        this.subLabelTable.put((Object)this.getMaxIndex(this.subLabelTable), (Object)subLabel, (Object)value);
    }

    private String getStandardSubLabel(String subLabel) {
        if (!((String)subLabel).startsWith("$")) {
            subLabel = "$" + (String)subLabel;
        }
        return subLabel;
    }

    public void deleteSubLabel(String subLabel) {
        subLabel = this.getStandardSubLabel(subLabel);
        this.subLabelTable.columnMap().remove(subLabel);
    }

    public ListMultimap<String, String> getSubLabelList() {
        ArrayListMultimap sublabels = ArrayListMultimap.create();
        this.subLabelTable.rowMap().forEach((arg_0, arg_1) -> Zone.lambda$getSubLabelList$2((ListMultimap)sublabels, arg_0, arg_1));
        return sublabels;
    }

    public void editSubLabel(String subLabel, String value) {
        if (this.isInSpecification(subLabel)) {
            ((Map)this.subLabelTable.columnMap().get(subLabel)).replaceAll((integer, s) -> {
                s = value;
                return s;
            });
        }
    }

    public String findSubLabel(String subLabel) {
        subLabel = this.getStandardSubLabel(subLabel);
        if (this.subLabelTable.columnMap().get(subLabel) == null) {
            return null;
        }
        return ((Map)this.subLabelTable.columnMap().get(subLabel)).values().stream().findFirst().orElse(null);
    }

    public String toString() {
        Table<Integer, String, String> tableWithoutDollar = this.removeDollar();
        StringBuilder zone = new StringBuilder(this.getLabelForOutput()).append(" ");
        if (this.getIndicateurs() != null) {
            zone.append(this.getIndicateurs());
        }
        if (this.getValeur() != null) {
            zone.append(this.getValeur());
        } else {
            for (int i = 0; i < this.specificationList.size(); ++i) {
                String subLabelSpecification = this.specificationList.get(i);
                ArrayList<String> sequence = new ArrayList<String>();
                if ("[".equals(subLabelSpecification)) {
                    int j = i + 1;
                    while (!"]".equals(this.specificationList.get(j))) {
                        sequence.add(this.specificationList.get(j));
                        subLabelSpecification = this.specificationList.get(j);
                        i = j++;
                    }
                }
                if (sequence.isEmpty()) {
                    this.addNormalToString(zone, subLabelSpecification, tableWithoutDollar);
                    continue;
                }
                this.addFollowingSequenceToString(zone, sequence, tableWithoutDollar);
            }
        }
        zone.append(Constants.STR_0D);
        return zone.toString();
    }

    protected Table<Integer, String, String> removeDollar() {
        HashBasedTable tableWithoutDollar = HashBasedTable.create();
        this.subLabelTable.rowMap().forEach((arg_0, arg_1) -> Zone.lambda$removeDollar$5((Table)tableWithoutDollar, arg_0, arg_1));
        return tableWithoutDollar;
    }

    public String getLabelForOutput() {
        return this.label.startsWith("B") || this.label.startsWith("Z") || this.label.startsWith("P") || this.label.matches("[A]\\d\\d\\d") ? this.label.substring(1) : this.label;
    }

    protected void addFollowingSequenceToString(StringBuilder zone, List<String> sequence, Table<Integer, String, String> tableWithoutDollar) {
        for (Map value : tableWithoutDollar.rowMap().values()) {
            Map.Entry valueEntryMap = value.entrySet().stream().findFirst().orElse(null);
            if (!sequence.contains(valueEntryMap.getKey())) continue;
            zone.append("$").append((String)valueEntryMap.getKey()).append((String)valueEntryMap.getValue());
        }
    }

    protected void addNormalToString(StringBuilder zone, String labelSpecification, Table<Integer, String, String> tableWithoutDollar) {
        if (tableWithoutDollar.columnMap().get(labelSpecification) != null) {
            for (String value : ((Map)tableWithoutDollar.columnMap().get(labelSpecification)).values()) {
                zone.append("$").append(labelSpecification).append(value);
            }
        }
    }

    private Integer getMaxIndex(Table<Integer, String, String> table) {
        if (table.isEmpty()) {
            return 0;
        }
        return table.rowMap().keySet().stream().max(Integer::compareTo).orElse(0) + 1;
    }

    private void initSpecifications() throws ZoneException {
        try {
            ZoneSpecification zoneSpecification = ZonesSpecifications.getZoneSpecification(this.getLabel(), this.typeNotice);
            this.specifications = zoneSpecification.sublabelSpecification;
            this.isProtected = zoneSpecification.isProtected;
            this.specificationList = Arrays.asList(this.specifications.split(""));
        }
        catch (NullPointerException ex) {
            throw new ZoneException("zone " + this.getLabelForOutput() + " inconnue pour le type de notice " + this.typeNotice);
        }
    }

    private boolean isInSpecification(String subLabel) {
        return this.specifications.contains(subLabel.substring(1));
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public String getValeur() {
        return this.valeur;
    }

    public char[] getIndicateurs() {
        return this.indicateurs;
    }

    public TYPE_NOTICE getTypeNotice() {
        return this.typeNotice;
    }

    public String getSpecifications() {
        return this.specifications;
    }

    public List<String> getSpecificationList() {
        return this.specificationList;
    }

    public Table<Integer, String, String> getSubLabelTable() {
        return this.subLabelTable;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public void setValeur(String valeur) {
        this.valeur = valeur;
    }

    public void setIndicateurs(char[] indicateurs) {
        this.indicateurs = indicateurs;
    }

    public void setTypeNotice(TYPE_NOTICE typeNotice) {
        this.typeNotice = typeNotice;
    }

    public void setSpecifications(String specifications) {
        this.specifications = specifications;
    }

    public void setSpecificationList(List<String> specificationList) {
        this.specificationList = specificationList;
    }

    public Zone() {
    }

    private static /* synthetic */ void lambda$removeDollar$5(Table tableWithoutDollar, Integer integer, Map stringStringMap) {
        stringStringMap.forEach((s, s2) -> {
            if (s.startsWith("$")) {
                s = s.substring(1);
            }
            HashMap<String, String> stringStringMapWithoutDollar = new HashMap<String, String>();
            stringStringMapWithoutDollar.put((String)s, (String)s2);
            tableWithoutDollar.row((Object)integer).putAll(stringStringMapWithoutDollar);
        });
    }

    private static /* synthetic */ void lambda$getSubLabelList$2(ListMultimap sublabels, Integer integer, Map stringStringMap) {
        stringStringMap.forEach((s, s2) -> sublabels.put(s, s2));
    }
}

