/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.notices;

import com.google.common.collect.Table;
import fr.abes.cbs.exception.ZoneException;
import fr.abes.cbs.notices.TYPE_NOTICE;
import fr.abes.cbs.notices.Zone;
import fr.abes.cbs.notices.sequences.SequenceEtatColl;
import fr.abes.cbs.utilitaire.Constants;
import fr.abes.cbs.zones.enumSousZones.Zone_955;
import fr.abes.cbs.zones.enumSousZones.Zone_956;
import fr.abes.cbs.zones.enumSousZones.Zone_957;
import fr.abes.cbs.zones.enumSousZones.Zone_959;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;

public class ZoneEtatColl
extends Zone {
    private List<SequenceEtatColl> listeSequences = new ArrayList<SequenceEtatColl>();

    public ZoneEtatColl(String zone, char[] indicateurs) throws ZoneException {
        super(zone, TYPE_NOTICE.EXEMPLAIRE, indicateurs);
    }

    public ZoneEtatColl(String zone, char[] indicateurs, SequenceEtatColl sequence) {
        this.label = zone;
        this.indicateurs = indicateurs;
        this.listeSequences.add(sequence);
    }

    public void addSequence(SequenceEtatColl sequence) {
        this.listeSequences.add(sequence);
    }

    public void addSousZone(String labelSubTag, String value, int indexSequence) throws ZoneException {
        switch (this.label) {
            case "959": {
                if (EnumUtils.isValidEnum(Zone_959.class, (String)labelSubTag)) {
                    this.addSubLabel(labelSubTag, value);
                    break;
                }
                this.listeSequences.get(indexSequence).getSequencePrimaire().addSubTag(labelSubTag, value, this.label);
                break;
            }
            case "955": {
                if (EnumUtils.isValidEnum(Zone_955.class, (String)labelSubTag)) {
                    this.addSubLabel(labelSubTag, value);
                    break;
                }
                this.listeSequences.get(indexSequence).getSequencePrimaire().addSubTag(labelSubTag, value, this.label);
                break;
            }
            case "956": {
                if (EnumUtils.isValidEnum(Zone_956.class, (String)labelSubTag)) {
                    this.addSubLabel(labelSubTag, value);
                    break;
                }
                this.listeSequences.get(indexSequence).getSequencePrimaire().addSubTag(labelSubTag, value, this.label);
                break;
            }
            case "957": {
                if (EnumUtils.isValidEnum(Zone_957.class, (String)labelSubTag)) {
                    this.addSubLabel(labelSubTag, value);
                    break;
                }
                this.listeSequences.get(indexSequence).getSequencePrimaire().addSubTag(labelSubTag, value, this.label);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder zone = new StringBuilder();
        zone.append(this.getLabelForOutput()).append(" ");
        if (this.getIndicateurs() != null) {
            zone.append(this.getIndicateurs());
        }
        for (SequenceEtatColl sequence : this.listeSequences) {
            zone.append(sequence.toString()).append("$0 ");
        }
        if (this.listeSequences.size() != 0) {
            zone.replace(zone.lastIndexOf("$0 "), zone.length(), "");
        }
        Table<Integer, String, String> tableWithoutDollar = this.removeDollar();
        for (int i = 0; i < this.specificationList.size(); ++i) {
            String subLabelSpecification = (String)this.specificationList.get(i);
            ArrayList<String> sequence = new ArrayList<String>();
            if ("[".equals(subLabelSpecification)) {
                int j = i + 1;
                while (!"]".equals(this.specificationList.get(j))) {
                    sequence.add((String)this.specificationList.get(j));
                    subLabelSpecification = (String)this.specificationList.get(j);
                    i = j++;
                }
            }
            if (sequence.isEmpty()) {
                this.addNormalToString(zone, subLabelSpecification, tableWithoutDollar);
                continue;
            }
            this.addFollowingSequenceToString(zone, sequence, tableWithoutDollar);
        }
        zone.append(Constants.STR_0D);
        return zone.toString();
    }

    public ZoneEtatColl() {
    }
}

