/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.process;

import fr.abes.cbs.commandes.Commandes;
import fr.abes.cbs.exception.CBSException;
import fr.abes.cbs.utilitaire.Constants;
import fr.abes.cbs.utilitaire.Utilitaire;
import java.util.ArrayList;
import java.util.List;

public class ProcessCBS {
    private Commandes clientCBS = new Commandes();
    private String timeStpEncours = "000200:00:00.000";
    private int lotEncours = 0;
    private boolean onEdit;
    private boolean onNew;
    private boolean onNewAut;
    private boolean onNewExp;
    private String ppnEncours = "";
    public boolean hasExpl;
    private String actEncours;
    private int pos = 1;
    private int nbNotices = 0;
    private StringBuilder listePpn = new StringBuilder();
    private String nvNumEx;
    private int nbExPPnEncours;
    private int lgNoticeSearch;
    private List<List<String>> resultatsTable = new ArrayList<List<String>>();
    private List<String[]> resultatsList = new ArrayList<String[]>();
    private String rcr;

    public boolean isCmdOk() {
        return this.clientCBS.isCmdOk();
    }

    public void disconnect() throws CBSException {
        this.clientCBS.disconnect();
    }

    public String search(String query) throws CBSException {
        this.onEdit = false;
        String resu = this.clientCBS.che(query);
        this.listePpn = new StringBuilder();
        this.nbNotices = Utilitaire.getNbNoticesFromChe(resu);
        switch (this.nbNotices) {
            case 1: {
                this.nbNotices = 1;
                this.lotEncours = Integer.parseInt(Utilitaire.recupEntre(resu, Constants.STR_1D + "VSIS", Constants.STR_1D));
                this.ppnEncours = Utilitaire.recupEntre(resu, "LPP", Constants.STR_1B);
                this.lgNoticeSearch = resu.length();
                break;
            }
            case 0: {
                this.nbNotices = 0;
                break;
            }
            default: {
                this.lotEncours = Integer.parseInt(Utilitaire.recupEntre(resu, "VSIS", Constants.STR_1D + "KTA"));
                String[] lstrecords = resu.split(Constants.STR_1B + "H" + Constants.STR_1B + "LPP");
                this.initTablesResult(lstrecords);
                this.lgNoticeSearch = resu.length();
            }
        }
        return resu;
    }

    private void initTablesResult(String[] lstrecords) throws CBSException {
        this.resultatsTable.clear();
        this.resultatsList.clear();
        for (int i = 1; i < lstrecords.length; ++i) {
            String ligne = lstrecords[i];
            String ppn = ligne.substring(0, 9);
            this.listePpn.append(ppn + ";");
            String lg = Utilitaire.recupEntre(ligne, Constants.SEPS1, Constants.STR_1B);
            String type = Utilitaire.recupEntre(ligne, Constants.LMA, Constants.STR_1B);
            String auteur = Utilitaire.recupEntre(ligne, Constants.STR_1B + "LV0", Constants.STR_1B);
            String titre = Utilitaire.recupEntre(ligne, Constants.STR_1B + "LV1", Constants.STR_1B);
            String inconnu2 = Utilitaire.recupEntre(ligne, Constants.STR_1B + "LV2", Constants.STR_1B);
            String inconnu3 = Utilitaire.recupEntre(ligne, Constants.STR_1B + "LV3", Constants.STR_1B);
            String inconnu4 = Utilitaire.recupEntre(ligne, Constants.STR_1B + "LV4", Constants.STR_1B);
            if (ppn.length() <= 8 || lg.isEmpty()) continue;
            String[] lignet2 = new String[8];
            ArrayList<String> lignet = new ArrayList<String>();
            lignet.add(lg.trim());
            lignet2[0] = Utilitaire.cv(lg.trim());
            lignet.add(ppn.trim());
            lignet2[1] = Utilitaire.cv(ppn.trim());
            lignet.add(type.trim());
            lignet2[2] = Utilitaire.cv(type.trim());
            lignet.add(auteur.trim());
            lignet2[3] = Utilitaire.cv(auteur.trim());
            lignet.add(titre.trim());
            lignet2[4] = Utilitaire.cv(titre.trim());
            lignet.add(inconnu2.trim());
            lignet2[5] = Utilitaire.cv(inconnu2.trim());
            lignet.add(inconnu3.trim());
            lignet2[6] = Utilitaire.cv(inconnu3.trim());
            lignet.add(inconnu4.trim());
            lignet2[7] = Utilitaire.cv(inconnu4.trim());
            this.resultatsTable.add(lignet);
            this.resultatsList.add(lignet2);
        }
    }

    public void authenticate(String serveur, String port, String login, String passwd) throws CBSException {
        if (!this.clientCBS.isConnected()) {
            this.clientCBS.connect(serveur, Integer.parseInt(port));
        }
        if (!this.clientCBS.isLogged()) {
            String resu = this.clientCBS.log(login, passwd);
            if (resu.contains(Constants.STR_1B + "LSY")) {
                resu = this.clientCBS.che("\\SYS SU");
                if (resu.contains(Constants.STR_1B + "ECatalogue")) {
                    this.clientCBS.che("\\BES 1 Catalogue");
                }
                this.clientCBS.che("\\BES 1");
            }
            if (this.clientCBS.isLogged()) {
                this.majRcr();
            }
        }
        this.setLotEncours(0);
    }

    public String view(String noLigne, boolean xml, String formatOrigine) throws CBSException {
        String fOrigine = formatOrigine;
        if (formatOrigine.isEmpty()) {
            fOrigine = "UNMA";
        }
        this.onEdit = false;
        String resu = this.clientCBS.view(noLigne, String.valueOf(this.lotEncours), fOrigine);
        this.ppnEncours = Utilitaire.recupEntre(resu, "LPP", Constants.STR_1B);
        if (!xml) {
            return resu;
        }
        String chaine = "UNX".equals(fOrigine) || "UNU".equals(fOrigine) ? Utilitaire.recupEntre(resu.replaceAll("<BR>", Constants.STR_0D), Constants.STR_0D + Constants.STR_0D, "</TABLE>") : Utilitaire.recupEntre(resu.replaceAll("<BR>", Constants.STR_0D), "<TABLE>", "</TABLE>");
        return Utilitaire.xmlFormat(chaine);
    }

    public String next() throws CBSException {
        this.onEdit = false;
        this.pos += 16;
        String resu = this.clientCBS.next(String.valueOf(this.lotEncours), this.pos);
        String[] lstrecords = resu.split("\r\n|\r|\n");
        this.initTablesResult(lstrecords);
        return resu;
    }

    @Deprecated
    public String editerEnXml(String noRecord) throws CBSException {
        return Utilitaire.xmlFormatEdit(this.editerJCBS(noRecord));
    }

    public String enregistrerNew(String notice) throws CBSException {
        String resu = this.clientCBS.cre(notice, 1);
        this.onEdit = false;
        this.onNew = true;
        this.ppnEncours = Utilitaire.recupEntre(resu, "avec PPN ", Constants.STR_1D).trim();
        return resu;
    }

    public String enregistrer(String notice) throws CBSException {
        int lettsp = Integer.parseInt(this.timeStpEncours.substring(0, 4));
        Object leact = "P".equals(this.actEncours) ? Constants.STR_1B + "P" : "";
        String noticedeb = "BIB" + this.timeStpEncours;
        String resu = this.clientCBS.valMod(notice, --lettsp, String.valueOf(this.lotEncours), this.ppnEncours, "1", noticedeb, (String)leact);
        this.onEdit = false;
        return resu;
    }

    public String enregistrerNewAut(String notice) throws CBSException {
        String resu = this.clientCBS.cre(notice, 2);
        this.onEdit = false;
        this.onNew = true;
        this.ppnEncours = Utilitaire.recupEntre(resu, "avec PPN ", Constants.STR_1D).trim();
        return resu;
    }

    public String transliterer(String notice) throws CBSException {
        String leact = "";
        if ("P".equals(this.actEncours)) {
            leact = "\u001bP";
        }
        String resu = this.clientCBS.transliterer(notice, leact, this.timeStpEncours, String.valueOf(this.lotEncours), this.ppnEncours);
        this.onEdit = false;
        this.onNew = true;
        return resu;
    }

    public String translitererSansPPN(String notice) throws CBSException {
        String resu = this.clientCBS.translitererSansPPN(notice);
        this.onEdit = false;
        this.onNew = true;
        return resu;
    }

    public String supprimer(String nonotice) throws CBSException {
        String resu = this.clientCBS.sup(nonotice, String.valueOf(this.lotEncours), this.ppnEncours);
        if (this.clientCBS.isCmdOk()) {
            this.onEdit = false;
        }
        return resu;
    }

    public String setParams(String[] params) throws CBSException {
        return this.clientCBS.setParams(params);
    }

    public String modifierNotice(String norecord, String notice) throws CBSException {
        String resu = this.clientCBS.mod(norecord, String.valueOf(this.lotEncours));
        String noticedeb = Utilitaire.recupEntre(resu, "VTXT", Constants.STR_1F);
        int lgnotice = Integer.parseInt(noticedeb.substring(3, 7)) >= 9999 ? this.lgNoticeSearch + 5000 : Integer.parseInt(noticedeb.substring(3, 7)) - 1;
        return this.clientCBS.valMod(notice, lgnotice, String.valueOf(this.lotEncours), this.ppnEncours, norecord, noticedeb, "");
    }

    public String ilnRattachement(String rcr) throws CBSException {
        String resu = this.clientCBS.affBib(rcr);
        return Utilitaire.recupEntre(resu, Constants.STR_1E + "VAG" + Constants.STR_1B + "P", Constants.STR_1E + "VAV");
    }

    public String editerExemplaire(String numEx) throws CBSException {
        String resu = this.clientCBS.modE(numEx, String.valueOf(this.lotEncours));
        String exemp = resu.contains(Constants.STR_0D + Constants.STR_0D + Constants.STR_1E + "VMC") ? numEx + Utilitaire.recupEntre(resu, Constants.STR_1F + "e" + numEx, Constants.STR_1E + "VMC") : numEx + Utilitaire.recupEntre(resu, Constants.STR_1F + "e" + numEx, Constants.STR_1E + Constants.STR_1D + "VV");
        return exemp;
    }

    public String editer(String noRecord) throws CBSException {
        this.nbExPPnEncours = 0;
        this.nvNumEx = "";
        String resu = this.clientCBS.mod(noRecord, String.valueOf(this.lotEncours));
        String exemp = resu.contains(Constants.STR_1E + "VMC") ? "VTXTE" + Utilitaire.recupEntre(resu, "VTXTE", Constants.STR_1E + "VMC") : "VTXTE" + Utilitaire.recupEntre(resu, "VTXTE", Constants.STR_1E + Constants.STR_1D + "VV");
        if (exemp.equals("VTXTE")) {
            this.nvNumEx = "e01";
            this.hasExpl = false;
        } else {
            this.hasExpl = exemp.contains(this.rcr);
            int posLastEx = exemp.lastIndexOf("VTXTE");
            this.nbExPPnEncours = posLastEx < 0 ? 1 : Integer.parseInt(exemp.substring(posLastEx + 5, posLastEx + 7));
            ++this.nbExPPnEncours;
            this.nvNumEx = String.valueOf(this.nbExPPnEncours).length() == 1 ? "e0" + this.nbExPPnEncours : "e" + this.nbExPPnEncours;
        }
        this.onEdit = true;
        this.onNew = false;
        return resu;
    }

    public String editerJCBS(String noRecord) throws CBSException {
        Object notice;
        String resu = this.editer(noRecord);
        this.actEncours = "";
        if (resu.contains(Constants.STR_1B + "P001")) {
            this.ppnEncours = Utilitaire.recupEntre(resu, Constants.STR_1B + "P001", Constants.STR_1B);
            this.ppnEncours = this.ppnEncours.substring(0, this.ppnEncours.length() - 1).trim().replaceAll("\\$a", "");
            notice = Utilitaire.recupEntre(resu, Constants.STR_1F + Constants.STR_1B + "P", Constants.STR_0D + Constants.STR_0D + Constants.STR_1E);
            this.actEncours = "P";
        } else if (resu.contains(Constants.STR_1B + "P003")) {
            this.ppnEncours = Utilitaire.recupEntre(resu, Constants.STR_1B + "P003", Constants.STR_1B);
            this.ppnEncours = this.ppnEncours.substring(0, this.ppnEncours.length() - 1).trim().replaceAll("\\$a", "");
            notice = Utilitaire.recupEntre(resu, Constants.STR_1F + Constants.STR_1B + "P", Constants.STR_0D + Constants.STR_0D + Constants.STR_1E);
            if ("".equals(notice)) {
                notice = Utilitaire.recupEntre(resu, Constants.STR_1F + Constants.STR_1B + "P", Constants.STR_0D + Constants.STR_1E);
            }
            if ("".equals(notice)) {
                notice = Utilitaire.recupEntre(resu, Constants.STR_1F + Constants.STR_1B + "P", Constants.STR_0D + Constants.STR_1B + "D" + Constants.STR_1E);
            }
            this.actEncours = "P";
        } else {
            this.ppnEncours = Utilitaire.recupEntre(resu, Constants.STR_1F + "003", Constants.STR_0D);
            this.ppnEncours = this.ppnEncours.trim().replaceAll("\\$a", "");
            notice = Utilitaire.recupEntre(resu, Constants.STR_1F, Constants.STR_0D + Constants.STR_0D + Constants.STR_1E);
            this.actEncours = "";
        }
        this.timeStpEncours = Utilitaire.recupEntre(resu, "VTXTBIB", Constants.STR_1F);
        Object exemp = Utilitaire.recupEntre(resu, "VTXTE", Constants.STR_1E + "VMC");
        StringBuilder eXp = new StringBuilder();
        if ("".equals(exemp)) {
            String[] lstblocsExp;
            exemp = "VTXTE" + (String)exemp;
            for (String blocExp : lstblocsExp = ((String)exemp).split(Constants.STR_1E)) {
                String[] sbloc = blocExp.split(Constants.STR_1F);
                if (sbloc.length != 2) continue;
                String trv = sbloc[0].replaceAll("VTXT", "");
                eXp.append(trv.substring(0, 3) + " " + trv.substring(3) + Constants.STR_0D);
                eXp.append(sbloc[1]);
            }
        }
        if ("".equals(eXp.toString())) {
            notice = (String)notice + eXp;
        }
        return notice;
    }

    public String creerExemplaire(String numEx) throws CBSException {
        return this.clientCBS.creE(numEx, String.valueOf(this.lotEncours));
    }

    public String creerDonneeLocale() throws CBSException {
        return this.clientCBS.creL(String.valueOf(this.lotEncours));
    }

    public String newExemplaire(String exemplaire) throws CBSException {
        return this.clientCBS.valCreE(exemplaire, String.valueOf(this.lotEncours), this.ppnEncours);
    }

    public String modifierExemp(String exemplaire, String numEx) throws CBSException {
        String resu = this.clientCBS.modE(numEx, String.valueOf(this.lotEncours));
        String noticedeb = Utilitaire.recupEntre(resu, "VTXTE", Constants.STR_1F);
        int lgexemp = Integer.parseInt(noticedeb.substring(2, 6)) - 1;
        return this.clientCBS.valModE(exemplaire, numEx, String.valueOf(this.lotEncours), noticedeb, this.ppnEncours, lgexemp);
    }

    public String back() throws CBSException {
        return this.clientCBS.back(String.valueOf(this.lotEncours));
    }

    public String newUsa(String[] user) throws CBSException {
        return this.clientCBS.creUsa(user);
    }

    public String supUsa(String user) throws CBSException {
        return this.clientCBS.valSupUsa(user);
    }

    public String affUsa() throws CBSException {
        return this.clientCBS.affUsa();
    }

    private void majRcr() throws CBSException {
        String result = this.affUsa();
        this.setRcr(result.substring(result.indexOf("VU3") + 3, result.indexOf(" " + Constants.STR_1E)));
    }

    public String affUnma() throws CBSException {
        return this.clientCBS.affFormat("unma", String.valueOf(this.lotEncours));
    }

    public String affFormat(String format) throws CBSException {
        return this.clientCBS.affFormat(format, String.valueOf(this.lotEncours));
    }

    public String supExemplaire(String exemplaire) throws CBSException {
        return this.clientCBS.supE(exemplaire, String.valueOf(this.lotEncours), this.ppnEncours);
    }

    public String supBiblio() throws CBSException {
        return this.clientCBS.sup(String.valueOf(this.lotEncours), this.ppnEncours);
    }

    public String modLoc(String vloc) throws CBSException {
        String resu = this.clientCBS.modLoc(String.valueOf(this.lotEncours));
        String noticedeb = Utilitaire.recupEntre(resu, "VTXT", Constants.STR_1F);
        return this.clientCBS.valModLoc(noticedeb, this.ppnEncours, String.valueOf(this.lotEncours), vloc);
    }

    public String newLoc(String vloc) throws CBSException {
        return this.clientCBS.valCreLoc(this.ppnEncours, String.valueOf(this.lotEncours), vloc);
    }

    public String supLoc() throws CBSException {
        this.clientCBS.supL(String.valueOf(this.lotEncours));
        return this.clientCBS.valSupL(String.valueOf(this.lotEncours), this.ppnEncours);
    }

    public Commandes getClientCBS() {
        return this.clientCBS;
    }

    public int getLotEncours() {
        return this.lotEncours;
    }

    public void setLotEncours(int lotEncours) {
        this.lotEncours = lotEncours;
    }

    public boolean isOnEdit() {
        return this.onEdit;
    }

    public void setOnEdit(boolean onEdit) {
        this.onEdit = onEdit;
    }

    public boolean isOnNew() {
        return this.onNew;
    }

    public void setOnNew(boolean onNew) {
        this.onNew = onNew;
    }

    public boolean isOnNewAut() {
        return this.onNewAut;
    }

    public void setOnNewAut(boolean onNewAut) {
        this.onNewAut = onNewAut;
    }

    public boolean isOnNewExp() {
        return this.onNewExp;
    }

    public void setOnNewExp(boolean onNewExp) {
        this.onNewExp = onNewExp;
    }

    public String getPpnEncours() {
        return this.ppnEncours;
    }

    public void setPpnEncours(String ppnEncours) {
        this.ppnEncours = ppnEncours;
    }

    public boolean isHasExpl() {
        return this.hasExpl;
    }

    public void setHasExpl(boolean hasExpl) {
        this.hasExpl = hasExpl;
    }

    public String getActEncours() {
        return this.actEncours;
    }

    public void setActEncours(String actEncours) {
        this.actEncours = actEncours;
    }

    public int getNbNotices() {
        return this.nbNotices;
    }

    public void setNbNotices(int nbNotices) {
        this.nbNotices = nbNotices;
    }

    public StringBuilder getListePpn() {
        return this.listePpn;
    }

    public void setListePpn(StringBuilder listePpn) {
        this.listePpn = listePpn;
    }

    public String getNvNumEx() {
        return this.nvNumEx;
    }

    public int getNbExPPnEncours() {
        return this.nbExPPnEncours;
    }

    public List<List<String>> getResultatsTable() {
        return this.resultatsTable;
    }

    public List<String[]> getResultatsList() {
        return this.resultatsList;
    }

    public String getRcr() {
        return this.rcr;
    }

    public void setRcr(String rcr) {
        this.rcr = rcr;
    }
}

