/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.utilitaire;

import fr.abes.cbs.exception.CBSException;
import fr.abes.cbs.utilitaire.Constants;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Utilitaire {
    private Utilitaire() {
    }

    public static String setStandardZoneRegex(int nombreSousZones) {
        StringBuilder regex = new StringBuilder("^(\\x1b[PD])?(?<zStaName>[^A]\\w{2,3})(?<zStaSpace>\\s*)(?<zStaHash>[\\d]{0,2}[#]*[\\d]{0,1})");
        for (int i = 0; i <= nombreSousZones; ++i) {
            regex.append(" *((?<szk").append(i).append(">[$]\\w)(?<szv").append(i).append(">[^$]*))?");
        }
        return regex.toString();
    }

    public static String setListeSousZoneRegex(int nombreSousZones) {
        StringBuilder regex = new StringBuilder("^");
        for (int i = 0; i <= nombreSousZones; ++i) {
            regex.append("((?<szk").append(i).append(">[$][a-z\\d])(?<szv").append(i).append(">[^$]*))? *");
        }
        return regex.substring(0, regex.length() - 2);
    }

    public static String setEtatCollZoneRestantes(Enum[] sousZones) {
        StringBuilder regex = new StringBuilder();
        for (int i = 0; i < sousZones.length; ++i) {
            regex.append("((?<szk").append(i).append(">[$][").append(sousZones[i]).append("])(?<szv").append(i).append(">[^$]*))?");
        }
        regex.append("$");
        return regex.toString();
    }

    public static String recupEntre(String ligne, String tag, String tagfin) {
        int posd = ligne.indexOf(tag);
        if (posd < 0) {
            return "";
        }
        if (tagfin.isEmpty()) {
            return ligne.substring(posd);
        }
        int posf = ligne.indexOf(tagfin, posd + 1);
        if (posf <= 0) {
            return "";
        }
        return ligne.substring(posd, posd + posf - posd).substring(tag.length());
    }

    public static Integer getNbNoticesFromChe(String resu) {
        String nbResults = Utilitaire.recupEntre(resu, Constants.STR_1D + "VSZ", Constants.STR_1D);
        if (resu.indexOf("LPP") != 0 && "1".equals(nbResults)) {
            return 1;
        }
        if (resu.contains(Constants.STR_1D + "VSZ")) {
            return Integer.parseInt(nbResults);
        }
        return 0;
    }

    public static String cv(String str) throws CBSException {
        try {
            byte[] utf8 = str.getBytes(StandardCharsets.UTF_8);
            return new String(utf8, "ISO8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            throw new CBSException("Impossible d'encoder la chaine en ISO", ex.getMessage());
        }
    }

    public static String xmlFormat(String notice) {
        String[] lstTags = notice.split(Constants.STR_0D);
        if (lstTags.length == 0) {
            return "<error>pas de tags</error>";
        }
        StringBuilder ret = new StringBuilder();
        ret.append("<collection xmlns=\"http://www.loc.gov/MARC21/slim\"><record>");
        for (String tag : lstTags) {
            boolean iscontrol;
            if ((tag = tag.replaceAll("\\$\\$", "1dollar2")).length() < 4) continue;
            if ("   ".equals(tag.substring(1, 4))) {
                ret.append("<leader>" + tag + "</leader>");
                continue;
            }
            if (!" ".equals(tag.substring(3, 4))) continue;
            if ("001".equals(tag.substring(0, 3))) {
                ret.append("<controlfield  tag=\"" + tag.substring(0, 3) + "\" >" + tag.substring(4).replaceAll("$a", "").replaceAll("$b", "") + "</controlfield>");
                continue;
            }
            if ("00".equals(tag.substring(0, 2))) {
                iscontrol = true;
                ret.append("<controlfield  tag=\"" + tag.substring(0, 3) + "\" >");
            } else {
                iscontrol = false;
                if ("$".equals(tag.substring(4, 5)) || "A".equals(tag.substring(0, 1))) {
                    ret.append("<datafield  tag=\"" + tag.substring(0, 3) + "\" >");
                } else {
                    ret.append("<datafield  tag=\"" + tag.substring(0, 3) + "\" ind1=\"" + tag.substring(4, 5).replaceAll("#", "") + "\" ind2=\"" + tag.substring(5, 6).replaceAll("#", "") + "\">");
                }
            }
            String[] lstdollar = tag.split("\\$");
            if (lstdollar.length >= 1 && !iscontrol) {
                int i = 0;
                for (String dollar : lstdollar) {
                    if (i > 0) {
                        ret.append("<subfield code=\"" + dollar.charAt(0) + "\">");
                        ret.append(Utilitaire.suppInutile(dollar.substring(1).replaceAll("1dollar2", "\\$\\$")));
                        ret.append("</subfield>");
                    }
                    ++i;
                }
            } else {
                ret.append(tag.substring(4));
            }
            if (iscontrol) {
                ret.append("</controlfield>");
                continue;
            }
            ret.append("</datafield>");
        }
        ret.append("</record></collection>");
        return ret.toString().replaceAll(Constants.STR_1B, "#27#");
    }

    private static String suppInutile(String in) {
        if (in.length() == 0) {
            return in;
        }
        String out = in.substring(0, 1).equals(Constants.CR_152_S) ? in.replaceFirst(Constants.CR_152_S, "").replaceFirst(Constants.CR_156_S, "") : in;
        return out.replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("'", "&apos;").replace("\"", "&quot;");
    }

    public static String getRecordSetAsXml(List<List<String>> resultatsTable) {
        StringBuilder result = new StringBuilder();
        Iterator<List<String>> lignes = resultatsTable.iterator();
        result.append("<RecordsList>");
        while (lignes.hasNext()) {
            result.append("<Record>");
            List<String> ligne = lignes.next();
            Iterator<String> colonnes = ligne.iterator();
            int i = 0;
            while (colonnes.hasNext()) {
                String colonne = colonnes.next();
                result.append("<Col").append(i).append(">");
                result.append(colonne);
                result.append("</Col").append(i).append(">");
                ++i;
            }
            result.append("</Record>");
        }
        result.append("</RecordsList>");
        return result.toString();
    }

    public static String getRecordSetAsXmlFromFor(int from, int len, List<List<String>> resultatsTable) {
        StringBuilder result = new StringBuilder();
        Iterator<List<String>> lignes = resultatsTable.iterator();
        int j = 0;
        int from2 = from;
        if (from2 == 1) {
            from2 = 0;
        }
        result.append("<RecordsList>");
        while (lignes.hasNext()) {
            List<String> ligne = lignes.next();
            if (j < from2 || j >= from2 + len || j >= resultatsTable.size()) continue;
            result.append("<Record>");
            Iterator<String> colonnes = ligne.iterator();
            int i = 0;
            while (colonnes.hasNext()) {
                String colonne = colonnes.next();
                result.append("<Col").append(i).append(">");
                result.append(colonne);
                result.append("</Col").append(i).append(">");
                ++i;
            }
            result.append("</Record>");
            ++j;
        }
        result.append("</RecordsList>");
        return result.toString();
    }

    public static String getTag(String notice, String tag, String stag) {
        String trv = Utilitaire.recupEntre(notice, tag + " ", Constants.STR_0D);
        String trv1 = Utilitaire.recupEntre(trv, stag, "$");
        if (trv1.isEmpty()) {
            trv1 = Utilitaire.recupEntre(trv + Constants.STR_0D, stag, Constants.STR_0D);
        }
        return trv1;
    }

    public static String xmlFormatEdit(String notice) {
        String[] lstTags = notice.split(Constants.STR_0D);
        if (lstTags.length == 0) {
            return "<error>pas de tags</error>";
        }
        StringBuilder ret = new StringBuilder();
        ret.append("<collection xmlns=\"http://www.loc.gov/MARC21/slim\"><record>");
        String[] stringArray = lstTags;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String tagin;
            String tag = tagin = stringArray[i];
            tag = tag.replaceAll("\\$\\$", "1dollar2");
            StringBuilder mrq = new StringBuilder();
            if (tag.length() < 4) continue;
            if (tag.substring(0, 1).equals(Constants.STR_1B)) {
                mrq.append(tag.charAt(1));
                tag = tag.replaceAll(Constants.STR_1B + mrq, "");
            }
            if (tag.substring(0, 1).equals(Constants.STR_1B)) {
                mrq.append(tag.charAt(1));
                tag = tag.replaceAll(Constants.STR_1B + tag.substring(1, 2), "");
            }
            if ("   ".equals(tag.substring(1, 4))) {
                ret.append("<leader>" + tag + "</leader>");
                continue;
            }
            if (!" ".equals(tag.substring(3, 4))) continue;
            boolean iscontrol = false;
            if (!"".equals(mrq.toString())) {
                if ("00".equals(tag.substring(0, 2)) || tag.indexOf(36) < 0 || "$".equals(tag.substring(4, 5)) || "A".equals(tag.substring(0, 1))) {
                    ret.append("<datafield tag=\"" + tag.substring(0, 3) + "\" act=\"" + mrq + "\" >");
                } else {
                    ret.append("<datafield tag=\"" + tag.substring(0, 3) + "\" ind1=\"" + tag.charAt(4) + "\" ind2=\"" + tag.charAt(5) + "\" act=\"" + mrq + "\" >");
                }
            } else if ("00".equals(tag.substring(0, 2)) || !tag.contains("$") || "$".equals(tag.substring(4, 5)) || "A".equals(tag.substring(0, 1)) || "E".equals(tag.substring(0, 1))) {
                ret.append("<datafield  tag=\"" + tag.substring(0, 3) + "\" >");
            } else {
                ret.append("<datafield  tag=\"" + tag.substring(0, 3) + "\" ind1=\"" + tag.charAt(4) + "\" ind2=\"" + tag.charAt(5) + "\">");
            }
            String[] lstdollar = tag.split("\\$");
            int i2 = 0;
            for (String dollar : lstdollar) {
                if (i2 > 0) {
                    ret.append("<subfield code=\"" + dollar.charAt(0) + "\">");
                    ret.append(dollar.substring(1).replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("'", "&apos;").replace("\"", "&quot;").replaceAll("1dollar2", "\\$\\$"));
                    ret.append("</subfield>");
                }
                ++i2;
            }
            if (iscontrol) {
                if (lstdollar.length == 1) {
                    ret.append(tag.substring(4));
                }
                ret.append("</controlfield>");
                continue;
            }
            if (lstdollar.length == 1) {
                ret.append(tag.substring(4));
            }
            ret.append("</datafield>");
        }
        ret.append("</record></collection>");
        return ret.toString().replaceAll(Constants.STR_1B, "#27#");
    }

    public static String format(String inn, int lg) {
        Object ret = inn;
        if (inn.length() > lg) {
            ret = inn.substring(0, lg - 3) + "...";
        } else if (inn.length() < lg) {
            ret = inn;
        }
        return ret;
    }

    public static String xml2MarcEdit(String noticeXml) {
        try {
            DocumentBuilderFactory fabrique = DocumentBuilderFactory.newInstance();
            DocumentBuilder constructeur = fabrique.newDocumentBuilder();
            StringReader reader = new StringReader(noticeXml);
            InputSource inputSource = new InputSource(reader);
            Document doc = constructeur.parse(inputSource);
            reader.close();
            XPathFactory xfabrique = XPathFactory.newInstance();
            XPath xpath = xfabrique.newXPath();
            StringBuilder notice = new StringBuilder();
            XPathExpression exp = xpath.compile("//record/*");
            NodeList lstnodes = (NodeList)exp.evaluate(doc, XPathConstants.NODESET);
            String ttmp = "";
            for (int i = 0; i < lstnodes.getLength(); ++i) {
                int k;
                boolean estpasse;
                NodeList lstdollar;
                String ind2;
                String ind1;
                Node ind2id;
                Node ind1id;
                Node act;
                Node tag = lstnodes.item(i);
                if ("leader".equals(tag.getNodeName()) || "header".equals(tag.getNodeName())) {
                    if (tag.getNodeValue().length() >= 10) {
                        ttmp = tag.getNodeValue().substring(9, 10);
                    }
                    switch (ttmp) {
                        case "b": {
                            ttmp = "Tb";
                            break;
                        }
                        case "f": {
                            ttmp = "Tu";
                            break;
                        }
                        case "h": {
                            ttmp = "Tq";
                            break;
                        }
                        case "j": {
                            ttmp = "Td";
                            break;
                        }
                        case "c": {
                            ttmp = "Tg";
                            break;
                        }
                        case "e": {
                            ttmp = "Ta";
                            break;
                        }
                        case "d": {
                            ttmp = "Tm";
                            break;
                        }
                        default: {
                            ttmp = "Tp";
                        }
                    }
                    notice.append("008 $a" + ttmp + "6" + Constants.STR_0D);
                }
                Object actStr = "";
                if ("controlfield".equals(tag.getNodeName())) {
                    Node tagid = tag.getAttributes().getNamedItem("tag");
                    act = tag.getAttributes().getNamedItem("act");
                    if (act != null) {
                        if (act.getNodeValue().length() == 1) {
                            actStr = Constants.STR_1B + act.getNodeValue();
                        } else if (act.getNodeValue().length() == 2) {
                            actStr = Constants.STR_1B + act.getNodeValue().substring(0, 1);
                            actStr = (String)actStr + Constants.STR_1B + act.getNodeValue().substring(1, 2);
                        }
                    }
                    ind1id = tag.getAttributes().getNamedItem("ind1");
                    ind2id = tag.getAttributes().getNamedItem("ind2");
                    ind1 = "";
                    ind2 = "";
                    if (ind1id != null) {
                        ind1 = ind1id.getNodeValue();
                    }
                    if (ind2id != null) {
                        ind2 = ind2id.getNodeValue();
                    }
                    notice.append((String)actStr + tagid.getNodeValue() + " " + ind1 + ind2);
                    lstdollar = tag.getChildNodes();
                    estpasse = false;
                    for (k = 0; k < lstdollar.getLength(); ++k) {
                        if (!"subfield".equals(lstdollar.item(k).getNodeName())) continue;
                        estpasse = true;
                        Node codeid = lstdollar.item(k).getAttributes().getNamedItem("code");
                        if (lstdollar.item(k).getFirstChild() != null) {
                            notice.append("$" + codeid.getNodeValue() + lstdollar.item(k).getFirstChild().getNodeValue().replaceAll("#27#", Constants.STR_1B));
                            continue;
                        }
                        notice.append("$" + codeid.getNodeValue());
                    }
                    if (!estpasse && tag.getFirstChild() != null) {
                        notice.append(tag.getFirstChild().getNodeValue().replaceAll("#27#", Constants.STR_1B));
                    }
                    notice.append(Constants.STR_0D);
                    continue;
                }
                if (!"datafield".equals(tag.getNodeName())) continue;
                Node tagid = tag.getAttributes().getNamedItem("tag");
                act = tag.getAttributes().getNamedItem("act");
                ind1id = tag.getAttributes().getNamedItem("ind1");
                ind2id = tag.getAttributes().getNamedItem("ind2");
                if (act != null) {
                    if (act.getNodeValue().length() == 1) {
                        actStr = Constants.STR_1B + act.getNodeValue();
                    } else if (act.getNodeValue().length() == 2) {
                        actStr = Constants.STR_1B + act.getNodeValue().charAt(0);
                        actStr = (String)actStr + Constants.STR_1B + act.getNodeValue().charAt(1);
                    }
                }
                ind1 = "";
                ind2 = "";
                if (ind1id != null) {
                    ind1 = ind1id.getNodeValue();
                }
                if (ind2id != null) {
                    ind2 = ind2id.getNodeValue();
                }
                if ("e".equalsIgnoreCase(tagid.getNodeValue().substring(0, 1)) || "A".equals(tagid.getNodeValue().substring(0, 1))) {
                    ind1 = "";
                    ind2 = "";
                }
                if ("E".equals(tagid.getNodeValue().substring(0, 1))) {
                    notice.append(Constants.STR_1F + Constants.STR_1E + "VTXT0T" + tagid.getNodeValue() + tag.getNodeValue());
                } else {
                    notice.append((String)actStr + tagid.getNodeValue() + " " + ind1 + ind2);
                    lstdollar = tag.getChildNodes();
                    estpasse = false;
                    for (k = 0; k < lstdollar.getLength(); ++k) {
                        Node lenode = lstdollar.item(k);
                        if (!"subfield".equals(lenode.getNodeName())) continue;
                        estpasse = true;
                        Node codeid = lenode.getAttributes().getNamedItem("code");
                        if (codeid == null || lenode.getFirstChild() == null) continue;
                        notice.append("$" + codeid.getNodeValue() + lenode.getFirstChild().getNodeValue().replaceAll("#27#", Constants.STR_1B));
                    }
                    if (!estpasse && tag.getFirstChild() != null) {
                        notice.append(tag.getFirstChild().getNodeValue().replaceAll("#27#", Constants.STR_1B));
                    }
                }
                notice.append(Constants.STR_0D);
            }
            return notice.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String xml2Marc(String noticeXml) {
        try {
            DocumentBuilderFactory fabrique = DocumentBuilderFactory.newInstance();
            DocumentBuilder constructeur = fabrique.newDocumentBuilder();
            StringReader reader = new StringReader(noticeXml);
            InputSource inputSource = new InputSource(reader);
            Document doc = constructeur.parse(inputSource);
            reader.close();
            XPathFactory xfabrique = XPathFactory.newInstance();
            XPath xpath = xfabrique.newXPath();
            XPathExpression exp = xpath.compile("//record/*");
            StringBuilder notice = new StringBuilder();
            NodeList lstnodes = (NodeList)exp.evaluate(doc, XPathConstants.NODESET);
            String ttmp = "";
            for (int i = 0; i < lstnodes.getLength(); ++i) {
                Node act;
                Node tag = lstnodes.item(i);
                if ("leader".equals(tag.getNodeName()) || "header".equals(tag.getNodeName())) {
                    if (tag.getNodeValue().length() >= 10) {
                        ttmp = tag.getNodeValue().substring(9, 10);
                    }
                    switch (ttmp) {
                        case "b": {
                            ttmp = "Tb";
                            break;
                        }
                        case "f": {
                            ttmp = "Tu";
                            break;
                        }
                        case "h": {
                            ttmp = "Tq";
                            break;
                        }
                        case "j": {
                            ttmp = "Td";
                            break;
                        }
                        case "c": {
                            ttmp = "Tg";
                            break;
                        }
                        case "e": {
                            ttmp = "Ta";
                            break;
                        }
                        case "d": {
                            ttmp = "Tm";
                            break;
                        }
                        default: {
                            ttmp = "Tp";
                        }
                    }
                    notice.append("008").append(" ").append("$a").append(ttmp).append("6").append(Constants.STR_0D);
                }
                Object actStr = "";
                if ("controlfield".equals(tag.getNodeName())) {
                    Node tagid = tag.getAttributes().getNamedItem("tag");
                    act = tag.getAttributes().getNamedItem("act");
                    if (act != null) {
                        if (act.getNodeValue().length() == 1) {
                            actStr = Constants.STR_1B + act.getNodeValue();
                        } else if (act.getNodeValue().length() == 2) {
                            actStr = Constants.STR_1B + act.getNodeValue().charAt(0);
                            actStr = (String)actStr + Constants.STR_1B + act.getNodeValue().charAt(1);
                        }
                    }
                    if ("001".equals(tagid.getNodeValue()) || "008".equals(tagid.getNodeValue())) {
                        if (!((String)actStr).isEmpty()) {
                            notice.append((String)actStr).append(tagid.getNodeValue()).append(" ").append(tag.getFirstChild().getNodeValue()).append(Constants.STR_0D);
                        } else {
                            notice.append(tagid.getNodeValue()).append(" ").append(tag.getFirstChild().getNodeValue()).append(Constants.STR_0D);
                        }
                    }
                }
                if (!"datafield".equals(tag.getNodeName())) continue;
                Node tagid = tag.getAttributes().getNamedItem("tag");
                act = tag.getAttributes().getNamedItem("act");
                Node ind1id = tag.getAttributes().getNamedItem("ind1");
                Node ind2id = tag.getAttributes().getNamedItem("ind2");
                if (act != null) {
                    if (act.getNodeValue().length() == 1) {
                        actStr = Constants.STR_1B + act.getNodeValue();
                    } else if (act.getNodeValue().length() == 2) {
                        actStr = Constants.STR_1B + act.getNodeValue().substring(0, 1);
                        actStr = (String)actStr + Constants.STR_1B + act.getNodeValue().substring(1, 2);
                    }
                }
                String ind1 = "";
                String ind2 = "";
                if (ind1id != null) {
                    ind1 = ind1id.getNodeValue();
                }
                if (ind2id != null) {
                    ind2 = ind2id.getNodeValue();
                }
                if (ind1.isEmpty() || " ".equals(ind1)) {
                    ind1 = "#";
                }
                if (ind2.isEmpty() || " ".equals(ind2)) {
                    ind2 = "#";
                }
                if ("e".equalsIgnoreCase(tagid.getNodeValue().substring(0, 1)) || "A".equals(tagid.getNodeValue().substring(0, 1))) {
                    ind1 = "";
                    ind2 = "";
                }
                notice.append((String)actStr).append(tagid.getNodeValue()).append(" ").append(ind1).append(ind2);
                NodeList lstdollar = tag.getChildNodes();
                boolean estpasse = false;
                for (int k = 0; k < lstdollar.getLength(); ++k) {
                    if (!"subfield".equals(lstdollar.item(k).getNodeName())) continue;
                    estpasse = true;
                    Node codeid = lstdollar.item(k).getAttributes().getNamedItem("code");
                    if (lstdollar.item(k).getFirstChild() == null) continue;
                    notice.append("$").append(codeid.getNodeValue()).append(lstdollar.item(k).getFirstChild().getNodeValue().replaceAll("#27#", Constants.STR_1B));
                }
                if (!estpasse && tag.getFirstChild() != null) {
                    notice.append(tag.getFirstChild().getNodeValue().replaceAll("#27#", Constants.STR_1B));
                }
                notice.append(Constants.STR_0D);
            }
            return notice.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getZone(String notice, String tag, String subTag) {
        String ligne = Utilitaire.recupEntre(Utilitaire.recupNoticeBib(notice), tag, Constants.STR_0D);
        if (subTag.isEmpty()) {
            return ligne.substring(1);
        }
        if (ligne.indexOf(subTag) == ligne.lastIndexOf(36)) {
            return ligne.substring(ligne.indexOf(subTag) + subTag.length());
        }
        if (ligne.indexOf(subTag) != ligne.lastIndexOf(subTag)) {
            ligne = ligne.substring(ligne.indexOf(subTag) + subTag.length());
            return ligne.substring(0, ligne.indexOf(36));
        }
        ligne = ligne.substring(ligne.indexOf(subTag) + subTag.length());
        return ligne.substring(0, ligne.indexOf(36));
    }

    public static boolean getZoneWithValue(String notice, String tag, String subTag, String value) {
        return Utilitaire.getZone(notice, tag, subTag).contains(value);
    }

    public static String recupNoticeBib(String notice) {
        if (notice.contains(Constants.STR_1E + "VMC")) {
            return Utilitaire.recupEntre(notice, "VTXTBIB", Constants.STR_1E + "VMC");
        }
        return Utilitaire.recupEntre(notice, "VTXTBIB", Constants.STR_1E + "VTXTE");
    }

    public static String ajoutZoneBiblio(String notice, String tag, String subTag, String valeur) {
        return Utilitaire.recupEntre(notice, Constants.STR_1F, Constants.STR_0D + Constants.STR_0D + Constants.STR_1E) + Constants.SEP_CHAMP + tag + " " + subTag + valeur + Constants.SEP_CHAMP;
    }

    public static String ajoutSousZoneExemp(String exemp, String tag, String subTag, String valeur) {
        List<String> zonesExemp = Utilitaire.cutExemp(exemp);
        for (String zone : zonesExemp) {
            if (!Utilitaire.getLabelZone(zone).equals(tag)) continue;
            List<String> list = Utilitaire.cutZone(zone);
        }
        return "";
    }

    private static List<String> cutExemp(String exemp) {
        String newExemp = exemp.substring(1, exemp.length() - 1);
        LinkedList<String> zonesExemp = new LinkedList<String>();
        String[] tabLignesExemp = newExemp.split(Constants.STR_0D);
        for (int i = 0; i < tabLignesExemp.length; ++i) {
            if (tabLignesExemp[i].length() < 3) continue;
            zonesExemp.add(tabLignesExemp[i]);
        }
        return zonesExemp;
    }

    private static List<String> cutZone(String zone) {
        LinkedList<String> sousZones = new LinkedList<String>();
        String[] tabSousZones = zone.split("$");
        for (int i = 0; i < tabSousZones.length; ++i) {
            sousZones.add(tabSousZones[i]);
        }
        return sousZones;
    }

    public static String suppZoneExemp(String exemp, String tag) {
        List<String> zonesExemp = Utilitaire.cutExemp(exemp);
        StringBuilder exempModifie = new StringBuilder();
        ListIterator<String> values = zonesExemp.listIterator();
        while (values.hasNext()) {
            String zone = (String)values.next();
            if (Utilitaire.getLabelZone(zone).equals(tag)) continue;
            exempModifie.append(zone).append(Constants.STR_0D);
        }
        exempModifie.insert(0, Constants.STR_1F);
        return exempModifie.toString();
    }

    public static String modifZoneBiblio(String notice, String tag, String subTag, String valeur) {
        String[] resuEdit = Utilitaire.recupEntre(notice, Constants.STR_1F, Constants.STR_0D + Constants.STR_0D + Constants.STR_1E).split(Constants.STR_0D);
        for (int i = 1; i < resuEdit.length; ++i) {
            if (resuEdit[i].length() <= 0 || !resuEdit[i].substring(0, 3).equals(tag)) continue;
            String[] xx = resuEdit[i].split("\\$");
            for (int j = 1; j < xx.length; ++j) {
                if (!xx[j].substring(0, 1).equals(subTag.substring(1, 2))) continue;
                xx[j] = subTag.substring(1, 2) + valeur;
                break;
            }
            StringBuilder zoneamodif = new StringBuilder();
            for (String xx1 : xx) {
                zoneamodif.append(xx1).append("$");
            }
            resuEdit[i] = zoneamodif.substring(0, zoneamodif.length() - 1);
        }
        StringBuilder newNotice = new StringBuilder();
        for (String resuEdit1 : resuEdit) {
            newNotice.append(resuEdit1).append(Constants.STR_0D);
        }
        return newNotice.toString();
    }

    public static String suppZoneBiblio(String notice, String tag, String subTag) {
        String[] resuEdit = Utilitaire.recupEntre(notice, Constants.STR_1F, Constants.STR_0D + Constants.STR_0D + Constants.STR_1E).split(Constants.STR_0D);
        for (int i = 0; i < resuEdit.length; ++i) {
            if (!resuEdit[i].substring(0, 3).equals(tag)) continue;
            if (subTag.isEmpty()) {
                resuEdit[i] = "";
                continue;
            }
            String[] xx = resuEdit[i].split("\\$");
            String[] newTabSousZone = new String[xx.length];
            int cpt = 0;
            for (String xx1 : xx) {
                if (xx1.substring(0, 1).equals(subTag.substring(1, 2))) continue;
                newTabSousZone[cpt] = xx1;
                ++cpt;
            }
            if (newTabSousZone.length <= 2) {
                resuEdit[i] = "";
                continue;
            }
            StringBuilder zoneamodif = new StringBuilder();
            for (String newTabSousZone1 : newTabSousZone) {
                if (newTabSousZone1 == null) continue;
                zoneamodif.append(newTabSousZone1).append("$");
            }
            resuEdit[i] = zoneamodif.substring(0, zoneamodif.length() - 1);
        }
        StringBuilder newNotice = new StringBuilder();
        for (String resuEdit1 : resuEdit) {
            if (resuEdit1.isEmpty()) continue;
            newNotice.append(resuEdit1).append(Constants.STR_0D);
        }
        return newNotice.toString();
    }

    public static String suppZoneBiblioWithPattern(String notice, String tag, String subTag, String pattern) {
        String[] resuEdit = Utilitaire.recupEntre(notice, Constants.STR_1F, Constants.STR_0D + Constants.STR_0D + Constants.STR_1E).split(Constants.STR_0D);
        for (int i = 0; i < resuEdit.length; ++i) {
            if (!resuEdit[i].substring(0, 3).equals(tag)) continue;
            if (subTag.isEmpty()) {
                resuEdit[i] = "";
                continue;
            }
            Boolean zoneASupp = false;
            String[] xx = resuEdit[i].split("(?<![$])[$](?![$])");
            String[] newTabSousZone = new String[xx.length];
            int cpt = 0;
            for (String xx1 : xx) {
                if (xx1.substring(0, 1).equals(subTag.substring(1, 2)) && xx1.contains(pattern)) {
                    zoneASupp = true;
                    continue;
                }
                newTabSousZone[cpt] = xx1;
                ++cpt;
            }
            StringBuilder zoneamodif = new StringBuilder();
            for (String newTabSousZone1 : newTabSousZone) {
                zoneamodif.append(newTabSousZone1).append("$");
            }
            resuEdit[i] = zoneASupp != false ? "" : zoneamodif.substring(0, zoneamodif.length() - 1);
        }
        StringBuilder newNotice = new StringBuilder();
        for (String resuEdit1 : resuEdit) {
            if (resuEdit1.isEmpty()) continue;
            newNotice.append(resuEdit1).append(Constants.STR_0D);
        }
        return newNotice.toString();
    }

    public static String numExemplaire(String notice) {
        StringBuilder nvNumEx = new StringBuilder().append("e");
        if (notice.contains("<BR>e01")) {
            int posLastEx = notice.lastIndexOf("<BR>e");
            int nbExPPnEncours = Integer.parseInt(notice.substring(posLastEx + 5, posLastEx + 7)) + 1;
            if (String.valueOf(nbExPPnEncours).length() == 1) {
                nvNumEx.append("0").append(nbExPPnEncours);
            } else {
                nvNumEx.append(nbExPPnEncours);
            }
        } else {
            nvNumEx.append("01");
        }
        return nvNumEx.toString();
    }

    public static String epnToExemplaire(String notice, String epn) {
        int posEpn = notice.indexOf(epn);
        int indexExemp = 0;
        Pattern pattern = Pattern.compile("<(B|b)(R|r)>e([0-9]{1}[0-9]{1})(\\s)\\$a");
        Matcher matcher = pattern.matcher(notice);
        while (matcher.find() && matcher.start() < posEpn) {
            indexExemp = matcher.start();
        }
        return "e" + notice.substring(indexExemp + 5, indexExemp + 7);
    }

    public static String messageCommande(String resCommande) {
        return resCommande.substring(2, resCommande.indexOf(Constants.STR_1D + "V"));
    }

    public static String getLabelZone(String zone) {
        if (zone.substring(0, 3).matches("\\d{3}")) {
            return zone.substring(0, 3);
        }
        if (zone.substring(0, 3).matches("e\\d{2}")) {
            return zone.substring(0, 3);
        }
        if (zone.substring(0, 4).matches("E\\d{3}")) {
            return zone.substring(0, 4);
        }
        if (zone.substring(0, 4).matches("L\\d{3}")) {
            return zone.substring(0, 4);
        }
        return "";
    }

    public static Boolean isZoneProtegee(String zone) {
        Pattern pattern1 = Pattern.compile("\\x1bP\\p{Digit}\\p{Digit}\\p{Digit}");
        Pattern pattern2 = Pattern.compile("\\x1bD\\x1bP\\p{Digit}\\p{Digit}\\p{Digit}");
        Matcher matcher1 = pattern1.matcher(zone);
        Matcher matcher2 = pattern2.matcher(zone);
        return matcher1.find() || matcher2.find();
    }

    public static boolean isCorectParameter(String parameter) {
        return parameter != null && !parameter.isEmpty();
    }

    public static String deleteExpensionFromValue(String value) {
        if (value.indexOf(Constants.STR_1B + "I@") != -1) {
            return value.substring(0, value.indexOf(Constants.STR_1B + "I@"));
        }
        return value;
    }
}

