/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lfr/acinq/bitcoin/Base58;", "", "()V", "mapBase58", "", "pszBase58", "", "decode", "", "input", "encode", "Prefix", "bitcoin-kmp"})
public final class Base58 {
    @NotNull
    public static final Base58 INSTANCE = new Base58();
    @NotNull
    private static final String pszBase58 = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    @NotNull
    private static final int[] mapBase58;

    private Base58() {
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull byte[] input) {
        int it;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int zeroes = 0;
        int length = 0;
        int begin = 0;
        int end = input.length;
        while (begin != end && input[begin] == 0) {
            ++begin;
            ++zeroes;
        }
        int size = (end - begin) * 138 / 100 + 1;
        byte[] b58 = new byte[size];
        while (begin != end) {
            int i;
            int carry = input[begin] & 0xFF;
            int it2 = b58.length - 1;
            for (i = 0; (carry != 0 || i < length) && it2 >= 0; carry /= 58, ++i, --it2) {
                b58[it2] = (byte)((carry += 256 * b58[it2]) % 58);
            }
            length = i;
            ++begin;
        }
        for (it = size - length; it != b58.length && b58[it] == 0; ++it) {
        }
        StringBuilder str = new StringBuilder();
        int n = 0;
        while (n < zeroes) {
            int it3 = n++;
            boolean bl = false;
            str.append('1');
        }
        while (it < b58.length) {
            str.append(pszBase58.charAt(b58[it]));
            ++it;
        }
        String string = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decode(@NotNull String input) {
        int it;
        int psz;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        for (psz = 0; psz < input.length() && CharsKt.isWhitespace((char)input.charAt(psz)); ++psz) {
        }
        int zeroes = 0;
        int length = 0;
        while (psz < input.length() && input.charAt(psz) == '1') {
            ++zeroes;
            ++psz;
        }
        int size = (input.length() - psz) * 733 / 1000 + 1;
        byte[] b256 = new byte[size];
        while (psz < input.length() && !CharsKt.isWhitespace((char)input.charAt(psz))) {
            int carry = mapBase58[input.charAt(psz)];
            if (!(carry != -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int i = 0;
            for (int it2 = b256.length - 1; (carry != 0 || i < length) && it2 >= 0; carry /= 256, --it2, ++i) {
                b256[it2] = (byte)((carry += 58 * (b256[it2] & 0xFF)) % 256);
            }
            length = i;
            ++psz;
        }
        while (psz < input.length() && CharsKt.isWhitespace((char)input.charAt(psz))) {
            ++psz;
        }
        if (!(psz == input.length())) {
            String i = "Failed requirement.";
            throw new IllegalArgumentException(i.toString());
        }
        byte[] output = new byte[zeroes + b256.length - it];
        for (it = size - length; it < b256.length; ++it) {
            output[zeroes] = b256[it];
            ++zeroes;
        }
        return output;
    }

    static {
        int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, 9, 10, 11, 12, 13, 14, 15, 16, -1, 17, 18, 19, 20, 21, -1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, -1, -1, -1, -1, -1, -1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, -1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        mapBase58 = nArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lfr/acinq/bitcoin/Base58$Prefix;", "", "()V", "PubkeyAddress", "", "PubkeyAddressTestnet", "ScriptAddress", "ScriptAddressTestnet", "SecretKey", "SecretKeyTestnet", "bitcoin-kmp"})
    public static final class Prefix {
        @NotNull
        public static final Prefix INSTANCE = new Prefix();
        public static final byte PubkeyAddress = 0;
        public static final byte ScriptAddress = 5;
        public static final byte SecretKey = -128;
        public static final byte PubkeyAddressTestnet = 111;
        public static final byte ScriptAddressTestnet = -60;
        public static final byte SecretKeyTestnet = -17;

        private Prefix() {
        }
    }
}

