/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.Base58;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.crypto.Pack;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0011H\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0012"}, d2={"Lfr/acinq/bitcoin/Base58Check;", "", "()V", "checksum", "", "data", "decode", "Lkotlin/Pair;", "", "encoded", "", "decodeWithIntPrefix", "", "decodeWithPrefixLen", "prefixLen", "encode", "prefix", "Lfr/acinq/bitcoin/ByteVector;", "bitcoin-kmp"})
public final class Base58Check {
    @NotNull
    public static final Base58Check INSTANCE = new Base58Check();

    private Base58Check() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] checksum(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = Arrays.copyOf(Crypto.hash256(data), 4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final String encode(int prefix, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Base58Check.encode(Pack.writeInt32BE(prefix), data);
    }

    @JvmStatic
    @NotNull
    public static final String encode(byte prefix, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Byte[] byteArray = new Byte[]{prefix};
        return Base58Check.encode(ArraysKt.toByteArray((Byte[])byteArray), data);
    }

    @JvmStatic
    @NotNull
    public static final String encode(byte prefix, @NotNull ByteVector data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Byte[] byteArray = new Byte[]{prefix};
        return Base58Check.encode(ArraysKt.toByteArray((Byte[])byteArray), data.toByteArray());
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull byte[] prefix, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] prefixAndData = ArraysKt.plus((byte[])prefix, (byte[])data);
        return Base58.encode(ArraysKt.plus((byte[])prefixAndData, (byte[])Base58Check.checksum(prefixAndData)));
    }

    @JvmStatic
    @NotNull
    public static final Pair<Byte, byte[]> decode(@NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        byte[] raw = Base58.decode(encoded);
        byte[] versionAndHash = CollectionsKt.toByteArray((Collection)ArraysKt.dropLast((byte[])raw, (int)4));
        byte[] checksum = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])raw, (int)4));
        if (!Arrays.equals(checksum, Base58Check.checksum(versionAndHash))) {
            boolean bl = false;
            String string = "invalid Base58Check data " + encoded;
            throw new IllegalArgumentException(string.toString());
        }
        return new Pair((Object)versionAndHash[0], (Object)CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])versionAndHash, (int)1)));
    }

    @JvmStatic
    @NotNull
    public static final Pair<Integer, byte[]> decodeWithIntPrefix(@NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        Pair<byte[], byte[]> pair = Base58Check.decodeWithPrefixLen(encoded, 4);
        byte[] prefix = (byte[])pair.component1();
        byte[] data = (byte[])pair.component2();
        return new Pair((Object)Pack.int32BE$default(prefix, 0, 2, null), (Object)data);
    }

    @JvmStatic
    @NotNull
    public static final Pair<byte[], byte[]> decodeWithPrefixLen(@NotNull String encoded, int prefixLen) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        byte[] raw = Base58.decode(encoded);
        byte[] versionAndHash = CollectionsKt.toByteArray((Collection)ArraysKt.dropLast((byte[])raw, (int)4));
        byte[] checksum = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])raw, (int)4));
        if (!Arrays.equals(checksum, Base58Check.checksum(versionAndHash))) {
            boolean bl = false;
            String string = "invalid Base58Check data " + encoded;
            throw new IllegalArgumentException(string.toString());
        }
        return new Pair((Object)CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])versionAndHash, (int)prefixLen)), (Object)CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])versionAndHash, (int)prefixLen)));
    }
}

