/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.Base58Check;
import fr.acinq.bitcoin.Bech32;
import fr.acinq.bitcoin.Block;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.OP_0;
import fr.acinq.bitcoin.OP_1;
import fr.acinq.bitcoin.OP_10;
import fr.acinq.bitcoin.OP_11;
import fr.acinq.bitcoin.OP_12;
import fr.acinq.bitcoin.OP_13;
import fr.acinq.bitcoin.OP_14;
import fr.acinq.bitcoin.OP_15;
import fr.acinq.bitcoin.OP_16;
import fr.acinq.bitcoin.OP_2;
import fr.acinq.bitcoin.OP_3;
import fr.acinq.bitcoin.OP_4;
import fr.acinq.bitcoin.OP_5;
import fr.acinq.bitcoin.OP_6;
import fr.acinq.bitcoin.OP_7;
import fr.acinq.bitcoin.OP_8;
import fr.acinq.bitcoin.OP_9;
import fr.acinq.bitcoin.OP_EQUAL;
import fr.acinq.bitcoin.OP_HASH160;
import fr.acinq.bitcoin.OP_PUSHDATA;
import fr.acinq.bitcoin.PublicKey;
import fr.acinq.bitcoin.Script;
import fr.acinq.bitcoin.ScriptElt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0015"}, d2={"Lfr/acinq/bitcoin/Bitcoin;", "", "()V", "addressFromPublicKeyScript", "", "chainHash", "Lfr/acinq/bitcoin/ByteVector32;", "pubkeyScript", "", "", "Lfr/acinq/bitcoin/ScriptElt;", "addressToPublicKeyScript", "address", "computeBIP44Address", "pub", "Lfr/acinq/bitcoin/PublicKey;", "computeBIP49Address", "computeBIP84Address", "computeP2PkhAddress", "computeP2ShOfP2WpkhAddress", "computeP2WpkhAddress", "bitcoin-kmp"})
public final class Bitcoin {
    @NotNull
    public static final Bitcoin INSTANCE = new Bitcoin();

    private Bitcoin() {
    }

    @JvmStatic
    @NotNull
    public static final String computeP2PkhAddress(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return pub.p2pkhAddress(chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeBIP44Address(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return Bitcoin.computeP2PkhAddress(pub, chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeP2ShOfP2WpkhAddress(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return pub.p2shOfP2wpkhAddress(chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeBIP49Address(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return Bitcoin.computeP2ShOfP2WpkhAddress(pub, chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeP2WpkhAddress(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return pub.p2wpkhAddress(chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeBIP84Address(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return Bitcoin.computeP2WpkhAddress(pub, chainHash);
    }

    @JvmStatic
    @Nullable
    public static final String addressFromPublicKeyScript(@NotNull ByteVector32 chainHash, @NotNull List<? extends ScriptElt> pubkeyScript) {
        String string;
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        Intrinsics.checkNotNullParameter(pubkeyScript, (String)"pubkeyScript");
        try {
            String string2;
            ByteVector32 byteVector32;
            if (Script.isPay2pkh(pubkeyScript)) {
                int n;
                byteVector32 = chainHash;
                if (Intrinsics.areEqual((Object)byteVector32, (Object)Block.LivenetGenesisBlock.hash)) {
                    n = 0;
                } else if ((Intrinsics.areEqual((Object)byteVector32, (Object)Block.TestnetGenesisBlock.hash) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.RegtestGenesisBlock.hash)) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.SignetGenesisBlock.hash)) {
                    n = 111;
                } else {
                    throw new IllegalStateException("invalid chain hash".toString());
                }
                int prefix = n;
                string2 = Base58Check.encode((byte)prefix, ((OP_PUSHDATA)pubkeyScript.get((int)2)).data);
            } else if (Script.isPay2sh(pubkeyScript)) {
                int n;
                byteVector32 = chainHash;
                if (Intrinsics.areEqual((Object)byteVector32, (Object)Block.LivenetGenesisBlock.hash)) {
                    n = 5;
                } else if ((Intrinsics.areEqual((Object)byteVector32, (Object)Block.TestnetGenesisBlock.hash) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.RegtestGenesisBlock.hash)) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.SignetGenesisBlock.hash)) {
                    n = -60;
                } else {
                    throw new IllegalStateException("invalid chain hash".toString());
                }
                int prefix = n;
                string2 = Base58Check.encode((byte)prefix, ((OP_PUSHDATA)pubkeyScript.get((int)1)).data);
            } else if (Script.isNativeWitnessScript(pubkeyScript)) {
                String hrp = Bech32.hrp(chainHash);
                byte[] witnessScript = ((OP_PUSHDATA)pubkeyScript.get((int)1)).data.toByteArray();
                ScriptElt scriptElt = pubkeyScript.get(0);
                string2 = scriptElt instanceof OP_0 ? (Script.isPay2wpkh(pubkeyScript) || Script.isPay2wsh(pubkeyScript) ? Bech32.encodeWitnessAddress(hrp, (byte)0, witnessScript) : null) : (scriptElt instanceof OP_1 ? Bech32.encodeWitnessAddress(hrp, (byte)1, witnessScript) : (scriptElt instanceof OP_2 ? Bech32.encodeWitnessAddress(hrp, (byte)2, witnessScript) : (scriptElt instanceof OP_3 ? Bech32.encodeWitnessAddress(hrp, (byte)3, witnessScript) : (scriptElt instanceof OP_4 ? Bech32.encodeWitnessAddress(hrp, (byte)4, witnessScript) : (scriptElt instanceof OP_5 ? Bech32.encodeWitnessAddress(hrp, (byte)5, witnessScript) : (scriptElt instanceof OP_6 ? Bech32.encodeWitnessAddress(hrp, (byte)6, witnessScript) : (scriptElt instanceof OP_7 ? Bech32.encodeWitnessAddress(hrp, (byte)7, witnessScript) : (scriptElt instanceof OP_8 ? Bech32.encodeWitnessAddress(hrp, (byte)8, witnessScript) : (scriptElt instanceof OP_9 ? Bech32.encodeWitnessAddress(hrp, (byte)9, witnessScript) : (scriptElt instanceof OP_10 ? Bech32.encodeWitnessAddress(hrp, (byte)10, witnessScript) : (scriptElt instanceof OP_11 ? Bech32.encodeWitnessAddress(hrp, (byte)11, witnessScript) : (scriptElt instanceof OP_12 ? Bech32.encodeWitnessAddress(hrp, (byte)12, witnessScript) : (scriptElt instanceof OP_13 ? Bech32.encodeWitnessAddress(hrp, (byte)13, witnessScript) : (scriptElt instanceof OP_14 ? Bech32.encodeWitnessAddress(hrp, (byte)14, witnessScript) : (scriptElt instanceof OP_15 ? Bech32.encodeWitnessAddress(hrp, (byte)15, witnessScript) : (scriptElt instanceof OP_16 ? Bech32.encodeWitnessAddress(hrp, (byte)16, witnessScript) : null))))))))))))))));
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String addressFromPublicKeyScript(@NotNull ByteVector32 chainHash, @NotNull byte[] pubkeyScript) {
        String string;
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        Intrinsics.checkNotNullParameter((Object)pubkeyScript, (String)"pubkeyScript");
        try {
            string = Bitcoin.addressFromPublicKeyScript(chainHash, Script.parse(pubkeyScript));
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @NotNull
    public static final List<ScriptElt> addressToPublicKeyScript(@NotNull ByteVector32 chainHash, @NotNull String address) {
        Throwable it;
        Object $this$addressToPublicKeyScript_u24lambda_u2d5_u24lambda_u2d2;
        List list;
        void var4_9;
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)OP_0.INSTANCE), TuplesKt.to((Object)1, (Object)OP_1.INSTANCE), TuplesKt.to((Object)2, (Object)OP_2.INSTANCE), TuplesKt.to((Object)3, (Object)OP_3.INSTANCE), TuplesKt.to((Object)4, (Object)OP_4.INSTANCE), TuplesKt.to((Object)5, (Object)OP_5.INSTANCE), TuplesKt.to((Object)6, (Object)OP_6.INSTANCE), TuplesKt.to((Object)7, (Object)OP_7.INSTANCE), TuplesKt.to((Object)8, (Object)OP_8.INSTANCE), TuplesKt.to((Object)9, (Object)OP_9.INSTANCE), TuplesKt.to((Object)10, (Object)OP_10.INSTANCE), TuplesKt.to((Object)11, (Object)OP_11.INSTANCE), TuplesKt.to((Object)12, (Object)OP_12.INSTANCE), TuplesKt.to((Object)13, (Object)OP_13.INSTANCE), TuplesKt.to((Object)14, (Object)OP_14.INSTANCE), TuplesKt.to((Object)15, (Object)OP_15.INSTANCE), TuplesKt.to((Object)16, (Object)OP_16.INSTANCE)};
        Map witnessVersions = MapsKt.mapOf((Pair[])pairArray);
        Bitcoin bitcoin = INSTANCE;
        try {
            Bitcoin bitcoin2 = bitcoin;
            boolean bl = false;
            Object object = Result.constructor-impl(Base58Check.decode(address));
        }
        catch (Throwable bl) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        void var3_4 = var4_9;
        Throwable throwable = Result.exceptionOrNull-impl((Object)var3_4);
        if (throwable == null) {
            Pair pair = (Pair)var3_4;
            boolean bl = false;
            if (((Number)pair.getFirst()).byteValue() == 111 && (Intrinsics.areEqual((Object)chainHash, (Object)Block.TestnetGenesisBlock.hash) || Intrinsics.areEqual((Object)chainHash, (Object)Block.RegtestGenesisBlock.hash) || Intrinsics.areEqual((Object)chainHash, (Object)Block.SignetGenesisBlock.hash))) {
                list = Script.pay2pkh((byte[])pair.getSecond());
                return list;
            } else if (((Number)pair.getFirst()).byteValue() == 0 && Intrinsics.areEqual((Object)chainHash, (Object)Block.LivenetGenesisBlock.hash)) {
                list = Script.pay2pkh((byte[])pair.getSecond());
                return list;
            } else if (((Number)pair.getFirst()).byteValue() == -60 && (Intrinsics.areEqual((Object)chainHash, (Object)Block.TestnetGenesisBlock.hash) || Intrinsics.areEqual((Object)chainHash, (Object)Block.RegtestGenesisBlock.hash) || Intrinsics.areEqual((Object)chainHash, (Object)Block.SignetGenesisBlock.hash))) {
                Object[] objectArray = new ScriptElt[]{OP_HASH160.INSTANCE, new OP_PUSHDATA((byte[])pair.getSecond()), OP_EQUAL.INSTANCE};
                list = CollectionsKt.listOf((Object[])objectArray);
                return list;
            } else {
                if (((Number)pair.getFirst()).byteValue() != 5 || !Intrinsics.areEqual((Object)chainHash, (Object)Block.LivenetGenesisBlock.hash)) throw new IllegalStateException("base58 address does not match our blockchain".toString());
                Object[] objectArray = new ScriptElt[]{OP_HASH160.INSTANCE, new OP_PUSHDATA((byte[])pair.getSecond()), OP_EQUAL.INSTANCE};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            return list;
        }
        Throwable throwable2 = throwable;
        boolean bl = false;
        Object object = INSTANCE;
        try {
            $this$addressToPublicKeyScript_u24lambda_u2d5_u24lambda_u2d2 = object;
            boolean bl2 = false;
            $this$addressToPublicKeyScript_u24lambda_u2d5_u24lambda_u2d2 = Result.constructor-impl(Bech32.decodeWitnessAddress(address));
        }
        catch (Throwable bl2) {
            $this$addressToPublicKeyScript_u24lambda_u2d5_u24lambda_u2d2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object = $this$addressToPublicKeyScript_u24lambda_u2d5_u24lambda_u2d2;
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
        if (throwable3 == null) {
            it = (Triple)object;
            boolean bl3 = false;
            ScriptElt witnessVersion = (ScriptElt)witnessVersions.get(it.getSecond());
            if (witnessVersion == null) {
                throw new IllegalStateException(("invalid version " + ((Number)it.getSecond()).intValue() + " in bech32 address").toString());
            }
            if (((byte[])it.getThird()).length != 20 && ((byte[])it.getThird()).length != 32) {
                throw new IllegalStateException("hash length in bech32 address must be either 20 or 32 bytes".toString());
            }
            if (Intrinsics.areEqual((Object)it.getFirst(), (Object)"bc") && Intrinsics.areEqual((Object)chainHash, (Object)Block.LivenetGenesisBlock.hash)) {
                Object[] objectArray = new ScriptElt[]{witnessVersion, new OP_PUSHDATA((byte[])it.getThird())};
                list = CollectionsKt.listOf((Object[])objectArray);
                return list;
            } else if (Intrinsics.areEqual((Object)it.getFirst(), (Object)"tb") && Intrinsics.areEqual((Object)chainHash, (Object)Block.TestnetGenesisBlock.hash)) {
                Object[] objectArray = new ScriptElt[]{witnessVersion, new OP_PUSHDATA((byte[])it.getThird())};
                list = CollectionsKt.listOf((Object[])objectArray);
                return list;
            } else if (Intrinsics.areEqual((Object)it.getFirst(), (Object)"tb") && Intrinsics.areEqual((Object)chainHash, (Object)Block.SignetGenesisBlock.hash)) {
                Object[] objectArray = new ScriptElt[]{witnessVersion, new OP_PUSHDATA((byte[])it.getThird())};
                list = CollectionsKt.listOf((Object[])objectArray);
                return list;
            } else {
                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)"bcrt") || !Intrinsics.areEqual((Object)chainHash, (Object)Block.RegtestGenesisBlock.hash)) throw new IllegalStateException("bech32 address does not match our blockchain".toString());
                Object[] objectArray = new ScriptElt[]{witnessVersion, new OP_PUSHDATA((byte[])it.getThird())};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            return list;
        } else {
            it = throwable3;
            boolean bl4 = false;
            throw new IllegalStateException((address + " is neither a valid Base58 address (" + throwable2 + ") nor a valid Bech32 address (" + it + ')').toString());
        }
    }
}

