/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.Block;
import fr.acinq.bitcoin.BlockHeader;
import fr.acinq.bitcoin.BtcSerializer;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.MerkleTree;
import fr.acinq.bitcoin.OP_CHECKSIG;
import fr.acinq.bitcoin.OP_PUSHDATA;
import fr.acinq.bitcoin.SatoshiKt;
import fr.acinq.bitcoin.ScriptElt;
import fr.acinq.bitcoin.Transaction;
import fr.acinq.bitcoin.TxIn;
import fr.acinq.bitcoin.TxOut;
import fr.acinq.bitcoin.io.ByteArrayInput;
import fr.acinq.bitcoin.io.Input;
import fr.acinq.bitcoin.io.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lfr/acinq/bitcoin/Block;", "", "header", "Lfr/acinq/bitcoin/BlockHeader;", "tx", "", "Lfr/acinq/bitcoin/Transaction;", "(Lfr/acinq/bitcoin/BlockHeader;Ljava/util/List;)V", "blockId", "Lfr/acinq/bitcoin/ByteVector32;", "hash", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "bitcoin-kmp"})
public final class Block {
    @NotNull
    public static final Companion Companion;
    @JvmField
    @NotNull
    public final BlockHeader header;
    @JvmField
    @NotNull
    public final List<Transaction> tx;
    @JvmField
    @NotNull
    public final ByteVector32 hash;
    @JvmField
    @NotNull
    public final ByteVector32 blockId;
    @JvmField
    @NotNull
    public static final Block LivenetGenesisBlock;
    @JvmField
    @NotNull
    public static final Block TestnetGenesisBlock;
    @JvmField
    @NotNull
    public static final Block RegtestGenesisBlock;
    @JvmField
    @NotNull
    public static final Block SignetGenesisBlock;

    public Block(@NotNull BlockHeader header, @NotNull List<Transaction> tx) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(tx, (String)"tx");
        this.header = header;
        this.tx = tx;
        this.hash = this.header.hash;
        this.blockId = this.hash.reversed();
    }

    @NotNull
    public final BlockHeader component1() {
        return this.header;
    }

    @NotNull
    public final List<Transaction> component2() {
        return this.tx;
    }

    @NotNull
    public final Block copy(@NotNull BlockHeader header, @NotNull List<Transaction> tx) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(tx, (String)"tx");
        return new Block(header, tx);
    }

    public static /* synthetic */ Block copy$default(Block block, BlockHeader blockHeader, List list, int n, Object object) {
        if ((n & 1) != 0) {
            blockHeader = block.header;
        }
        if ((n & 2) != 0) {
            list = block.tx;
        }
        return block.copy(blockHeader, list);
    }

    @NotNull
    public String toString() {
        return "Block(header=" + this.header + ", tx=" + this.tx + ')';
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = result * 31 + ((Object)this.tx).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Block)) {
            return false;
        }
        Block block = (Block)other;
        if (!Intrinsics.areEqual((Object)this.header, (Object)block.header)) {
            return false;
        }
        return Intrinsics.areEqual(this.tx, block.tx);
    }

    @JvmStatic
    @NotNull
    public static byte[] write(@NotNull Block message) {
        return Companion.write(message);
    }

    @JvmStatic
    @NotNull
    public static Block read(@NotNull String input) {
        return Companion.read(input);
    }

    @JvmStatic
    @NotNull
    public static Block read(@NotNull byte[] input) {
        return Companion.read(input);
    }

    @JvmStatic
    public static void validate(@NotNull Block message) {
        Companion.validate(message);
    }

    @JvmStatic
    public static final boolean checkProofOfWork(@NotNull Block block) {
        return Companion.checkProofOfWork(block);
    }

    @JvmStatic
    @NotNull
    public static final Pair<BlockHeader, List<Pair<ByteVector32, Integer>>> verifyTxOutProof(@NotNull byte[] proof) {
        return Companion.verifyTxOutProof(proof);
    }

    static {
        Companion $this$LivenetGenesisBlock_u24lambda_u2d0 = Companion = new Companion(null);
        boolean bl = false;
        Object[] objectArray = new OP_PUSHDATA[]{new OP_PUSHDATA(BtcSerializer.Companion.writeUInt32-WZ4Q5Ns(486604799)), new OP_PUSHDATA(new ByteVector("04")), new OP_PUSHDATA(StringsKt.encodeToByteArray((String)"The Times 03/Jan/2009 Chancellor on brink of second bailout for banks"))};
        List script = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new ScriptElt[]{new OP_PUSHDATA(new ByteVector("04678afdb0fe5548271967f1a67130b7105cd6a828e03909a67962e0ea1f61deb649f6bc3f4cef38c4f35504e51ec112de5c384df7ba0b8d578a4c702b6bf11d5f")), OP_CHECKSIG.INSTANCE};
        List scriptPubKey = CollectionsKt.listOf((Object[])objectArray2);
        LivenetGenesisBlock = new Block(new BlockHeader(1L, ByteVector32.Zeroes, new ByteVector32("3ba3edfd7a7b12b27ac72c3e67768f617fc81bc3888a51323a9fb8aa4b1e5e4a"), 1231006505L, 486604799L, 2083236893L), CollectionsKt.listOf((Object)new Transaction(1L, CollectionsKt.listOf((Object)TxIn.Companion.coinbase(script)), CollectionsKt.listOf((Object)new TxOut(SatoshiKt.toSatoshi(5000000000L), scriptPubKey)), 0L)));
        TestnetGenesisBlock = Block.copy$default(LivenetGenesisBlock, BlockHeader.copy$default(Block.LivenetGenesisBlock.header, 0L, null, null, 1296688602L, 0L, 414098458L, 23, null), null, 2, null);
        RegtestGenesisBlock = Block.copy$default(LivenetGenesisBlock, BlockHeader.copy$default(Block.LivenetGenesisBlock.header, 0L, null, null, 1296688602L, 545259519L, 2L, 7, null), null, 2, null);
        SignetGenesisBlock = Block.copy$default(LivenetGenesisBlock, BlockHeader.copy$default(Block.LivenetGenesisBlock.header, 0L, null, null, 1598918400L, 503543726L, 52613770L, 7, null), null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0007J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0010H\u0017J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0017J.\u0010\u0015\u001a \u0012\u0004\u0012\u00020\u0017\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00160\u00180\u00162\u0006\u0010\u001b\u001a\u00020\u0010H\u0007J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0017J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0004\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lfr/acinq/bitcoin/Block$Companion;", "Lfr/acinq/bitcoin/BtcSerializer;", "Lfr/acinq/bitcoin/Block;", "()V", "LivenetGenesisBlock", "RegtestGenesisBlock", "SignetGenesisBlock", "TestnetGenesisBlock", "checkProofOfWork", "", "block", "read", "input", "Lfr/acinq/bitcoin/io/Input;", "protocolVersion", "", "", "", "validate", "", "message", "verifyTxOutProof", "Lkotlin/Pair;", "Lfr/acinq/bitcoin/BlockHeader;", "", "Lfr/acinq/bitcoin/ByteVector32;", "", "proof", "write", "out", "Lfr/acinq/bitcoin/io/Output;", "bitcoin-kmp"})
    public static final class Companion
    extends BtcSerializer<Block> {
        private Companion() {
        }

        @Override
        public void write(@NotNull Block message, @NotNull Output out, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            BlockHeader.Companion.write(message.header, out);
            BtcSerializer.Companion.writeCollection(message.tx, out, Transaction.Companion, protocolVersion);
        }

        @Override
        @JvmStatic
        @NotNull
        public byte[] write(@NotNull Block message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return super.write(message);
        }

        @Override
        @NotNull
        public Block read(@NotNull Input input, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            byte[] raw = BtcSerializer.Companion.bytes(input, 80);
            BlockHeader header = BlockHeader.Companion.read(raw);
            return new Block(header, BtcSerializer.Companion.readCollection(input, Transaction.Companion, protocolVersion));
        }

        @Override
        @JvmStatic
        @NotNull
        public Block read(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (Block)super.read(input);
        }

        @Override
        @JvmStatic
        @NotNull
        public Block read(@NotNull byte[] input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (Block)super.read(input);
        }

        @Override
        @JvmStatic
        public void validate(@NotNull Block message) {
            Transaction it;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            BlockHeader.Companion.validate(message.header);
            Iterable iterable = message.tx;
            Object object = message.header.hashMerkleRoot;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Transaction transaction = (Transaction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.hash);
            }
            if (!Intrinsics.areEqual((Object)object, (Object)MerkleTree.computeRoot((List)destination$iv$iv))) {
                boolean $i$a$-require-Block$Companion$validate$32 = false;
                String $i$a$-require-Block$Companion$validate$32 = "invalid block:  merkle root mismatch";
                throw new IllegalArgumentException($i$a$-require-Block$Companion$validate$32.toString());
            }
            $this$map$iv = message.tx;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Transaction)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.hash);
            }
            if (!(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() == message.tx.size())) {
                boolean $i$a$-require-Block$Companion$validate$52 = false;
                String $i$a$-require-Block$Companion$validate$52 = "invalid block: duplicate transactions";
                throw new IllegalArgumentException($i$a$-require-Block$Companion$validate$52.toString());
            }
            $this$map$iv = message.tx;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Transaction)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Transaction.Companion.validate(it);
                object.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }

        @JvmStatic
        public final boolean checkProofOfWork(@NotNull Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return BlockHeader.Companion.checkProofOfWork(block.header);
        }

        @JvmStatic
        @NotNull
        public final Pair<BlockHeader, List<Pair<ByteVector32, Integer>>> verifyTxOutProof(@NotNull byte[] proof) {
            Intrinsics.checkNotNullParameter((Object)proof, (String)"proof");
            BlockHeader header = BlockHeader.Companion.read(CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])proof, (int)80)));
            ByteArrayInput inputStream = new ByteArrayInput(CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])proof, (int)80)));
            int txCount = BtcSerializer.Companion.uint32-OGnWXxg(inputStream);
            List<ByteVector32> hashes2 = BtcSerializer.Companion.readCollection((Input)inputStream, verifyTxOutProof.hashes.1.INSTANCE, null, 70015L);
            byte[] bits = BtcSerializer.Companion.script(inputStream);
            Ref.IntRef bitsUsed = new Ref.IntRef();
            Ref.IntRef hashUsed = new Ref.IntRef();
            Ref.ObjectRef matched = new Ref.ObjectRef();
            matched.element = CollectionsKt.emptyList();
            int height = 0;
            while (fr.acinq.bitcoin.Block$Companion.verifyTxOutProof$calcTreeWidth(txCount, height) > 1) {
                ++height;
            }
            ByteVector32 root = fr.acinq.bitcoin.Block$Companion.verifyTxOutProof$traverseAndExtract(bits, bitsUsed, hashes2, hashUsed, (Ref.ObjectRef<List<Pair<ByteVector32, Integer>>>)matched, txCount, height, 0);
            if (!Intrinsics.areEqual((Object)root, (Object)header.hashMerkleRoot)) {
                boolean bl = false;
                String string = "invalid merkle root: expected " + header.hashMerkleRoot.toHex() + ", got " + root.toHex();
                throw new IllegalArgumentException(string.toString());
            }
            return new Pair((Object)header, matched.element);
        }

        private static final boolean verifyTxOutProof$bit(byte[] bits, int pos) {
            byte elt = bits[pos / 8];
            return (byte)(elt & (byte)(1 << pos % 8)) != 0;
        }

        private static final int verifyTxOutProof$calcTreeWidth(int txCount, int height) {
            return txCount + (1 << height) - 1 >> height;
        }

        private static final ByteVector32 verifyTxOutProof$traverseAndExtract(byte[] bits, Ref.IntRef bitsUsed, List<ByteVector32> hashes2, Ref.IntRef hashUsed, Ref.ObjectRef<List<Pair<ByteVector32, Integer>>> matched, int txCount, int height, int pos) {
            ByteVector32 byteVector32;
            int n = bitsUsed.element;
            bitsUsed.element = n + 1;
            boolean parentOfMatch = fr.acinq.bitcoin.Block$Companion.verifyTxOutProof$bit(bits, n);
            if (height == 0) {
                int n2 = hashUsed.element;
                hashUsed.element = n2 + 1;
                ByteVector32 hash = hashes2.get(n2);
                if (parentOfMatch) {
                    matched.element = CollectionsKt.plus((Collection)((Collection)matched.element), (Object)new Pair((Object)hash, (Object)pos));
                }
                byteVector32 = hash;
            } else if (!parentOfMatch) {
                int hash = hashUsed.element;
                hashUsed.element = hash + 1;
                byteVector32 = hashes2.get(hash);
            } else {
                ByteVector32 byteVector322;
                ByteVector32 left = fr.acinq.bitcoin.Block$Companion.verifyTxOutProof$traverseAndExtract(bits, bitsUsed, hashes2, hashUsed, matched, txCount, height - 1, pos * 2);
                if (pos * 2 + 1 < fr.acinq.bitcoin.Block$Companion.verifyTxOutProof$calcTreeWidth(txCount, height - 1)) {
                    ByteVector32 hash = fr.acinq.bitcoin.Block$Companion.verifyTxOutProof$traverseAndExtract(bits, bitsUsed, hashes2, hashUsed, matched, txCount, height - 1, pos * 2 + 1);
                    if (!(!Intrinsics.areEqual((Object)hash, (Object)left))) {
                        boolean bl = false;
                        String string = "invalid leaf hash";
                        throw new IllegalArgumentException(string.toString());
                    }
                    byteVector322 = hash;
                } else {
                    byteVector322 = left;
                }
                ByteVector32 right = byteVector322;
                byteVector32 = left.concat(right).sha256().sha256();
            }
            return byteVector32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

