/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.BtcSerializable;
import fr.acinq.bitcoin.BtcSerializer;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.UInt256;
import fr.acinq.bitcoin.io.Input;
import fr.acinq.bitcoin.io.Output;
import fr.acinq.secp256k1.Hex;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.UInt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001%B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0010\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lfr/acinq/bitcoin/BlockHeader;", "Lfr/acinq/bitcoin/BtcSerializable;", "version", "", "hashPreviousBlock", "Lfr/acinq/bitcoin/ByteVector32;", "hashMerkleRoot", "time", "bits", "nonce", "(JLfr/acinq/bitcoin/ByteVector32;Lfr/acinq/bitcoin/ByteVector32;JJJ)V", "blockId", "hash", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "serializer", "Lfr/acinq/bitcoin/BtcSerializer;", "setBits", "input", "setHashMerkleRoot", "setHashPreviousBlock", "setNonce", "setTime", "setVersion", "toString", "", "Companion", "bitcoin-kmp"})
public final class BlockHeader
implements BtcSerializable<BlockHeader> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final long version;
    @JvmField
    @NotNull
    public final ByteVector32 hashPreviousBlock;
    @JvmField
    @NotNull
    public final ByteVector32 hashMerkleRoot;
    @JvmField
    public final long time;
    @JvmField
    public final long bits;
    @JvmField
    public final long nonce;
    @JvmField
    @NotNull
    public final ByteVector32 hash;
    @JvmField
    @NotNull
    public final ByteVector32 blockId;

    public BlockHeader(long version, @NotNull ByteVector32 hashPreviousBlock, @NotNull ByteVector32 hashMerkleRoot, long time, long bits, long nonce) {
        Intrinsics.checkNotNullParameter((Object)hashPreviousBlock, (String)"hashPreviousBlock");
        Intrinsics.checkNotNullParameter((Object)hashMerkleRoot, (String)"hashMerkleRoot");
        this.version = version;
        this.hashPreviousBlock = hashPreviousBlock;
        this.hashMerkleRoot = hashMerkleRoot;
        this.time = time;
        this.bits = bits;
        this.nonce = nonce;
        this.hash = new ByteVector32(Crypto.hash256(Companion.write(this)));
        this.blockId = this.hash.reversed();
    }

    @NotNull
    public final BlockHeader setVersion(long input) {
        return BlockHeader.copy$default(this, input, null, null, 0L, 0L, 0L, 62, null);
    }

    @NotNull
    public final BlockHeader setHashPreviousBlock(@NotNull ByteVector32 input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return BlockHeader.copy$default(this, 0L, input, null, 0L, 0L, 0L, 61, null);
    }

    @NotNull
    public final BlockHeader setHashMerkleRoot(@NotNull ByteVector32 input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return BlockHeader.copy$default(this, 0L, null, input, 0L, 0L, 0L, 59, null);
    }

    @NotNull
    public final BlockHeader setTime(long input) {
        return BlockHeader.copy$default(this, 0L, null, null, input, 0L, 0L, 55, null);
    }

    @NotNull
    public final BlockHeader setBits(long input) {
        return BlockHeader.copy$default(this, 0L, null, null, 0L, input, 0L, 47, null);
    }

    @NotNull
    public final BlockHeader setNonce(long input) {
        return BlockHeader.copy$default(this, 0L, null, null, 0L, 0L, input, 31, null);
    }

    @Override
    @NotNull
    public BtcSerializer<BlockHeader> serializer() {
        return Companion;
    }

    public final long component1() {
        return this.version;
    }

    @NotNull
    public final ByteVector32 component2() {
        return this.hashPreviousBlock;
    }

    @NotNull
    public final ByteVector32 component3() {
        return this.hashMerkleRoot;
    }

    public final long component4() {
        return this.time;
    }

    public final long component5() {
        return this.bits;
    }

    public final long component6() {
        return this.nonce;
    }

    @NotNull
    public final BlockHeader copy(long version, @NotNull ByteVector32 hashPreviousBlock, @NotNull ByteVector32 hashMerkleRoot, long time, long bits, long nonce) {
        Intrinsics.checkNotNullParameter((Object)hashPreviousBlock, (String)"hashPreviousBlock");
        Intrinsics.checkNotNullParameter((Object)hashMerkleRoot, (String)"hashMerkleRoot");
        return new BlockHeader(version, hashPreviousBlock, hashMerkleRoot, time, bits, nonce);
    }

    public static /* synthetic */ BlockHeader copy$default(BlockHeader blockHeader, long l, ByteVector32 byteVector32, ByteVector32 byteVector322, long l2, long l3, long l4, int n, Object object) {
        if ((n & 1) != 0) {
            l = blockHeader.version;
        }
        if ((n & 2) != 0) {
            byteVector32 = blockHeader.hashPreviousBlock;
        }
        if ((n & 4) != 0) {
            byteVector322 = blockHeader.hashMerkleRoot;
        }
        if ((n & 8) != 0) {
            l2 = blockHeader.time;
        }
        if ((n & 0x10) != 0) {
            l3 = blockHeader.bits;
        }
        if ((n & 0x20) != 0) {
            l4 = blockHeader.nonce;
        }
        return blockHeader.copy(l, byteVector32, byteVector322, l2, l3, l4);
    }

    @NotNull
    public String toString() {
        return "BlockHeader(version=" + this.version + ", hashPreviousBlock=" + this.hashPreviousBlock + ", hashMerkleRoot=" + this.hashMerkleRoot + ", time=" + this.time + ", bits=" + this.bits + ", nonce=" + this.nonce + ')';
    }

    public int hashCode() {
        int result = Long.hashCode(this.version);
        result = result * 31 + this.hashPreviousBlock.hashCode();
        result = result * 31 + this.hashMerkleRoot.hashCode();
        result = result * 31 + Long.hashCode(this.time);
        result = result * 31 + Long.hashCode(this.bits);
        result = result * 31 + Long.hashCode(this.nonce);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlockHeader)) {
            return false;
        }
        BlockHeader blockHeader = (BlockHeader)other;
        if (this.version != blockHeader.version) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hashPreviousBlock, (Object)blockHeader.hashPreviousBlock)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hashMerkleRoot, (Object)blockHeader.hashMerkleRoot)) {
            return false;
        }
        if (this.time != blockHeader.time) {
            return false;
        }
        if (this.bits != blockHeader.bits) {
            return false;
        }
        return this.nonce == blockHeader.nonce;
    }

    @JvmStatic
    @NotNull
    public static BlockHeader read(@NotNull String input) {
        return Companion.read(input);
    }

    @JvmStatic
    @NotNull
    public static BlockHeader read(@NotNull byte[] input) {
        return Companion.read(input);
    }

    @JvmStatic
    @NotNull
    public static byte[] write(@NotNull BlockHeader message) {
        return Companion.write(message);
    }

    @JvmStatic
    @NotNull
    public static final UInt256 getDifficulty(@NotNull BlockHeader header) {
        return Companion.getDifficulty(header);
    }

    @JvmStatic
    @NotNull
    public static final UInt256 blockProof(long bits) {
        return Companion.blockProof(bits);
    }

    @JvmStatic
    @NotNull
    public static final UInt256 blockProof(@NotNull BlockHeader header) {
        return Companion.blockProof(header);
    }

    @JvmStatic
    public static final boolean checkProofOfWork(@NotNull BlockHeader header) {
        return Companion.checkProofOfWork(header);
    }

    @JvmStatic
    public static final long calculateNextWorkRequired(@NotNull BlockHeader lastHeader, long lastRetargetTime) {
        return Companion.calculateNextWorkRequired(lastHeader, lastRetargetTime);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0007J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0013H\u0017J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0002H\u0017J \u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\bH\u0016\u00a8\u0006\u001a"}, d2={"Lfr/acinq/bitcoin/BlockHeader$Companion;", "Lfr/acinq/bitcoin/BtcSerializer;", "Lfr/acinq/bitcoin/BlockHeader;", "()V", "blockProof", "Lfr/acinq/bitcoin/UInt256;", "header", "bits", "", "calculateNextWorkRequired", "lastHeader", "lastRetargetTime", "checkProofOfWork", "", "getDifficulty", "read", "input", "Lfr/acinq/bitcoin/io/Input;", "protocolVersion", "", "", "write", "message", "", "output", "Lfr/acinq/bitcoin/io/Output;", "bitcoin-kmp"})
    public static final class Companion
    extends BtcSerializer<BlockHeader> {
        private Companion() {
        }

        @Override
        @NotNull
        public BlockHeader read(@NotNull Input input, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int version = BtcSerializer.Companion.uint32-OGnWXxg(input);
            byte[] hashPreviousBlock = BtcSerializer.Companion.hash(input);
            byte[] hashMerkleRoot = BtcSerializer.Companion.hash(input);
            int time = BtcSerializer.Companion.uint32-OGnWXxg(input);
            int bits = BtcSerializer.Companion.uint32-OGnWXxg(input);
            int nonce = BtcSerializer.Companion.uint32-OGnWXxg(input);
            return new BlockHeader((long)version & 0xFFFFFFFFL, ByteVectorKt.byteVector32(hashPreviousBlock), ByteVectorKt.byteVector32(hashMerkleRoot), (long)time & 0xFFFFFFFFL, (long)bits & 0xFFFFFFFFL, (long)nonce & 0xFFFFFFFFL);
        }

        @Override
        @JvmStatic
        @NotNull
        public BlockHeader read(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (BlockHeader)super.read(input);
        }

        @Override
        @JvmStatic
        @NotNull
        public BlockHeader read(@NotNull byte[] input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (BlockHeader)super.read(input);
        }

        @Override
        public void write(@NotNull BlockHeader message, @NotNull Output output, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)message.version)), output);
            BtcSerializer.Companion.writeBytes(message.hashPreviousBlock, output);
            BtcSerializer.Companion.writeBytes(message.hashMerkleRoot, output);
            BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)message.time)), output);
            BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)message.bits)), output);
            BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)message.nonce)), output);
        }

        @Override
        @JvmStatic
        @NotNull
        public byte[] write(@NotNull BlockHeader message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return super.write(message);
        }

        @JvmStatic
        @NotNull
        public final UInt256 getDifficulty(@NotNull BlockHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Triple<UInt256, Boolean, Boolean> triple = UInt256.Companion.decodeCompact(header.bits);
            UInt256 diff = (UInt256)triple.component1();
            boolean neg = (Boolean)triple.component2();
            return neg ? diff.unaryMinus() : diff;
        }

        @JvmStatic
        @NotNull
        public final UInt256 blockProof(long bits) {
            UInt256 uInt256;
            Triple<UInt256, Boolean, Boolean> triple = UInt256.Companion.decodeCompact(bits);
            UInt256 target = (UInt256)triple.component1();
            boolean negative = (Boolean)triple.component2();
            boolean overflow = (Boolean)triple.component3();
            if (Intrinsics.areEqual((Object)target, (Object)UInt256.Zero) || negative || overflow) {
                uInt256 = UInt256.Zero;
            } else {
                UInt256 work = target.inv();
                work.divAssign(target.inc());
                uInt256 = work.inc();
            }
            return uInt256;
        }

        @JvmStatic
        @NotNull
        public final UInt256 blockProof(@NotNull BlockHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            return this.blockProof(header.bits);
        }

        @JvmStatic
        public final boolean checkProofOfWork(@NotNull BlockHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            UInt256 target = (UInt256)UInt256.Companion.decodeCompact(header.bits).component1();
            UInt256 hash = new UInt256(header.blockId.toByteArray());
            return hash.compareTo(target) <= 0;
        }

        @JvmStatic
        public final long calculateNextWorkRequired(@NotNull BlockHeader lastHeader, long lastRetargetTime) {
            Intrinsics.checkNotNullParameter((Object)lastHeader, (String)"lastHeader");
            long actualTimespan = lastHeader.time - lastRetargetTime;
            long targetTimespan = 1209600L;
            if (actualTimespan < targetTimespan / (long)4) {
                actualTimespan = targetTimespan / (long)4;
            }
            if (actualTimespan > targetTimespan * (long)4) {
                actualTimespan = targetTimespan * (long)4;
            }
            Triple<UInt256, Boolean, Boolean> triple = UInt256.Companion.decodeCompact(lastHeader.bits);
            UInt256 target = (UInt256)triple.component1();
            boolean isnegative = (Boolean)triple.component2();
            boolean overflow = (Boolean)triple.component3();
            if (!(!isnegative)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!overflow)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            target.timesAssign(new UInt256(actualTimespan));
            target.divAssign(new UInt256(targetTimespan));
            UInt256 powLimit = new UInt256(Hex.decode((String)"00000000ffffffffffffffffffffffffffffffffffffffffffffffffffffffff"));
            if (target.compareTo(powLimit) > 0) {
                target = powLimit;
            }
            return target.encodeCompact(false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

