/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.ByteVector64;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.PrivateKey;
import fr.acinq.bitcoin.PublicKey;
import fr.acinq.bitcoin.XonlyPublicKey;
import fr.acinq.bitcoin.crypto.Digest;
import fr.acinq.bitcoin.crypto.HMacKt;
import fr.acinq.bitcoin.io.ByteArrayInput;
import fr.acinq.secp256k1.Secp256k1;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002@AB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J \u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0007J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J \u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0007J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0018\u0010+\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0002J$\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0006H\u0007J \u0010,\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\bH\u0007J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J \u0010/\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0007J\u0010\u00100\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u0010\u00101\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u0010\u00101\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J \u00101\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0007J\u0018\u00102\u001a\u00020\u000f2\u0006\u0010!\u001a\u0002032\u0006\u00104\u001a\u00020\u0019H\u0007J\u0018\u00102\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0019H\u0007J,\u00105\u001a\u00020\u000f2\u0006\u0010!\u001a\u0002032\u0006\u00104\u001a\u00020\u00192\u0006\u00106\u001a\u0002072\n\b\u0002\u00108\u001a\u0004\u0018\u000103H\u0007J\u0018\u00109\u001a\u0002032\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010:\u001a\u00020;H\u0007J \u0010<\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u001bH\u0007J \u0010>\u001a\u00020\u00042\u0006\u0010!\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010=\u001a\u00020?H\u0007\u00a8\u0006B"}, d2={"Lfr/acinq/bitcoin/Crypto;", "", "()V", "checkPubKeyEncoding", "", "key", "", "flags", "", "sigVersion", "checkSignatureEncoding", "sig", "compact2der", "Lfr/acinq/bitcoin/ByteVector;", "signature", "Lfr/acinq/bitcoin/ByteVector64;", "decodeSignatureLax", "Lkotlin/Pair;", "input", "Lfr/acinq/bitcoin/io/ByteArrayInput;", "der2compact", "dropZeroAndFixSize", "size", "ecdh", "priv", "Lfr/acinq/bitcoin/PrivateKey;", "pub", "Lfr/acinq/bitcoin/PublicKey;", "hash160", "offset", "len", "hash256", "hmac512", "data", "isDERSignature", "isDefinedHashTypeSignature", "isLowDERSignature", "isPrivKeyValid", "isPubKeyCompressed", "isPubKeyCompressedOrUncompressed", "isPubKeyUncompressed", "isPubKeyValid", "normalize", "padLeft", "recoverPublicKey", "message", "recid", "ripemd160", "sha1", "sha256", "sign", "Lfr/acinq/bitcoin/ByteVector32;", "privateKey", "signSchnorr", "schnorrTweak", "Lfr/acinq/bitcoin/Crypto$SchnorrTweak;", "auxrand32", "taggedHash", "tag", "", "verifySignature", "publicKey", "verifySignatureSchnorr", "Lfr/acinq/bitcoin/XonlyPublicKey;", "SchnorrTweak", "TaprootTweak", "bitcoin-kmp"})
public final class Crypto {
    @NotNull
    public static final Crypto INSTANCE = new Crypto();

    private Crypto() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] sha1(@NotNull ByteVector input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Digest.Companion.sha1().hash(input.toByteArray());
    }

    @JvmStatic
    @NotNull
    public static final byte[] sha256(@NotNull byte[] input, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Digest.Companion.sha256().hash(input, offset, len);
    }

    @JvmStatic
    @NotNull
    public static final byte[] sha256(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Crypto.sha256(input, 0, input.length);
    }

    @JvmStatic
    @NotNull
    public static final byte[] sha256(@NotNull ByteVector input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Crypto.sha256(input.toByteArray(), 0, input.size());
    }

    @JvmStatic
    @NotNull
    public static final byte[] ripemd160(@NotNull byte[] input, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Digest.Companion.ripemd160().hash(input, offset, len);
    }

    @JvmStatic
    @NotNull
    public static final byte[] ripemd160(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Crypto.ripemd160(input, 0, input.length);
    }

    @JvmStatic
    @NotNull
    public static final byte[] ripemd160(@NotNull ByteVector input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Crypto.ripemd160(input.toByteArray(), 0, input.size());
    }

    @JvmStatic
    @NotNull
    public static final byte[] hash256(@NotNull byte[] input, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Digest it = Digest.Companion.sha256();
        boolean bl = false;
        return it.hash(it.hash(input, offset, len));
    }

    @JvmStatic
    @NotNull
    public static final byte[] hash256(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Crypto.hash256(input, 0, input.length);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hash256(@NotNull ByteVector input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Crypto.hash256(input.toByteArray(), 0, input.size());
    }

    @JvmStatic
    @NotNull
    public static final byte[] hash160(@NotNull byte[] input, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Digest.Companion.ripemd160().hash(Digest.Companion.sha256().hash(input, offset, len));
    }

    @JvmStatic
    @NotNull
    public static final byte[] hash160(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Crypto.hash160(input, 0, input.length);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hash160(@NotNull ByteVector input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Crypto.hash160(input.toByteArray(), 0, input.size());
    }

    @JvmStatic
    @NotNull
    public static final byte[] hmac512(@NotNull byte[] key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return HMacKt.hmac(Digest.Companion.sha512(), key, data, 128);
    }

    @JvmStatic
    @NotNull
    public static final byte[] ecdh(@NotNull PrivateKey priv, @NotNull PublicKey pub) {
        Intrinsics.checkNotNullParameter((Object)priv, (String)"priv");
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        return Secp256k1.Companion.ecdh(priv.value.toByteArray(), pub.value.toByteArray());
    }

    @JvmStatic
    public static final boolean isPrivKeyValid(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Secp256k1.Companion.secKeyVerify(key);
    }

    @JvmStatic
    public static final boolean isPubKeyValid(@NotNull byte[] key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Secp256k1.Companion.pubkeyParse(key);
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isPubKeyCompressedOrUncompressed(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (Crypto.isPubKeyCompressed(key)) return true;
        if (!Crypto.isPubKeyUncompressed(key)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isPubKeyCompressed(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return key.length == 33 && (key[0] == 2 || key[0] == 3);
    }

    @JvmStatic
    public static final boolean isPubKeyUncompressed(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return key.length == 65 && key[0] == 4;
    }

    @JvmStatic
    @NotNull
    public static final ByteVector64 sign(@NotNull byte[] data, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        byte[] bin = Secp256k1.Companion.sign(data, privateKey.value.toByteArray());
        return new ByteVector64(bin);
    }

    @JvmStatic
    @NotNull
    public static final ByteVector64 sign(@NotNull ByteVector32 data, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return Crypto.sign(data.toByteArray(), privateKey);
    }

    @JvmStatic
    public static final boolean verifySignature(@NotNull byte[] data, @NotNull ByteVector64 signature, @NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return Secp256k1.Companion.verify(signature.toByteArray(), data, publicKey.value.toByteArray());
    }

    @JvmStatic
    @NotNull
    public static final ByteVector64 signSchnorr(@NotNull ByteVector32 data, @NotNull PrivateKey privateKey, @NotNull SchnorrTweak schnorrTweak, @Nullable ByteVector32 auxrand32) {
        PrivateKey privateKey2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)schnorrTweak, (String)"schnorrTweak");
        SchnorrTweak schnorrTweak2 = schnorrTweak;
        if (Intrinsics.areEqual((Object)schnorrTweak2, (Object)SchnorrTweak.NoTweak.INSTANCE)) {
            privateKey2 = privateKey;
        } else if (schnorrTweak2 instanceof TaprootTweak.NoScriptTweak) {
            privateKey2 = privateKey.tweak(privateKey.xOnlyPublicKey().tweak((TaprootTweak)schnorrTweak));
        } else if (schnorrTweak2 instanceof TaprootTweak.ScriptTweak) {
            privateKey2 = privateKey.tweak(privateKey.xOnlyPublicKey().tweak((TaprootTweak)schnorrTweak));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PrivateKey priv = privateKey2;
        ByteVector32 byteVector32 = auxrand32;
        ByteVector64 sig = ByteVectorKt.byteVector64(Secp256k1.Companion.signSchnorr(data.toByteArray(), priv.value.toByteArray(), (byte[])(byteVector32 != null ? byteVector32.toByteArray() : null)));
        if (!Crypto.verifySignatureSchnorr(data, sig, priv.xOnlyPublicKey())) {
            boolean bl = false;
            String string = "Cannot create Schnorr signature";
            throw new IllegalArgumentException(string.toString());
        }
        return sig;
    }

    public static /* synthetic */ ByteVector64 signSchnorr$default(ByteVector32 byteVector32, PrivateKey privateKey, SchnorrTweak schnorrTweak, ByteVector32 byteVector322, int n, Object object) {
        if ((n & 8) != 0) {
            byteVector322 = null;
        }
        return Crypto.signSchnorr(byteVector32, privateKey, schnorrTweak, byteVector322);
    }

    @JvmStatic
    public static final boolean verifySignatureSchnorr(@NotNull ByteVector32 data, @NotNull ByteVector signature, @NotNull XonlyPublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return Secp256k1.Companion.verifySchnorr(signature.toByteArray(), data.toByteArray(), publicKey.value.toByteArray());
    }

    private final byte[] padLeft(byte[] data, int size) {
        byte[] byArray;
        if (data.length == size) {
            byArray = data;
        } else if (data.length < size) {
            byArray = ArraysKt.plus((byte[])new byte[size - data.length], (byte[])data);
        } else {
            throw new RuntimeException("cannot pad left: byte array is too big (" + data.length + " > " + size + ')');
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] dropZeroAndFixSize(byte[] input, int size) {
        void $this$dropWhile$iv;
        byte[] byArray = input;
        Crypto crypto = this;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList<Byte> list$iv = new ArrayList<Byte>();
        for (void item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add((byte)item$iv);
                continue;
            }
            void it = item$iv;
            boolean bl = false;
            if (it == false) continue;
            list$iv.add((byte)item$iv);
            yielding$iv = true;
        }
        return crypto.padLeft(CollectionsKt.toByteArray((Collection)list$iv), size);
    }

    @JvmStatic
    @NotNull
    public static final ByteVector compact2der(@NotNull ByteVector64 signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        byte[] normalized = (byte[])Secp256k1.Companion.signatureNormalize(signature.toByteArray()).getFirst();
        byte[] der = Secp256k1.Companion.compact2der(normalized);
        return new ByteVector(der);
    }

    @JvmStatic
    @NotNull
    public static final ByteVector64 der2compact(@NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Pair<byte[], byte[]> pair = Crypto.decodeSignatureLax(new ByteArrayInput(signature));
        byte[] r = (byte[])pair.component1();
        byte[] s = (byte[])pair.component2();
        byte[] lax = ArraysKt.plus((byte[])INSTANCE.dropZeroAndFixSize(r, 32), (byte[])INSTANCE.dropZeroAndFixSize(s, 32));
        return new ByteVector64((byte[])Secp256k1.Companion.signatureNormalize(lax).getFirst());
    }

    @JvmStatic
    @NotNull
    public static final Pair<ByteVector64, Boolean> normalize(@NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Pair<byte[], byte[]> pair = Crypto.decodeSignatureLax(new ByteArrayInput(signature));
        byte[] r = (byte[])pair.component1();
        byte[] s = (byte[])pair.component2();
        byte[] compact = ArraysKt.plus((byte[])INSTANCE.dropZeroAndFixSize(r, 32), (byte[])INSTANCE.dropZeroAndFixSize(s, 32));
        Pair it = Secp256k1.Companion.signatureNormalize(compact);
        boolean bl = false;
        return TuplesKt.to((Object)new ByteVector64((byte[])it.getFirst()), (Object)it.getSecond());
    }

    @JvmStatic
    public static final boolean isDERSignature(@NotNull byte[] sig) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        if (sig.length < 9) {
            return false;
        }
        if (sig.length > 73) {
            return false;
        }
        if (sig[0] != 48) {
            return false;
        }
        if (sig[1] != (byte)(sig.length - 3)) {
            return false;
        }
        byte lenR = sig[3];
        if (5 + lenR >= sig.length) {
            return false;
        }
        byte lenS = sig[5 + lenR];
        if (lenR + lenS + 7 != sig.length) {
            return false;
        }
        if (sig[2] != 2) {
            return false;
        }
        if (lenR == 0) {
            return false;
        }
        if ((sig[4] & 0x80) != 0) {
            return false;
        }
        if (lenR > 1 && sig[4] == 0 && (sig[5] & 0x80) == 0) {
            return false;
        }
        if (sig[lenR + 4] != 2) {
            return false;
        }
        if (lenS == 0) {
            return false;
        }
        if ((sig[lenR + 6] & 0x80) != 0) {
            return false;
        }
        return lenS <= 1 || sig[lenR + 6] != 0 || (sig[lenR + 7] & 0x80) != 0;
    }

    @JvmStatic
    public static final boolean isLowDERSignature(@NotNull byte[] sig) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        return (Boolean)Secp256k1.Companion.signatureNormalize(sig).getSecond() == false;
    }

    @JvmStatic
    public static final boolean isDefinedHashTypeSignature(@NotNull byte[] sig) {
        int hashType;
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        return sig.length == 0 ? false : (hashType = ArraysKt.last((byte[])sig) & 0xFF & 0xFFFFFF7F) >= 1 && hashType <= 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean checkSignatureEncoding(@NotNull byte[] sig, int flags) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        if (sig.length == 0) {
            return true;
        }
        boolean bl = false;
        if (bl) {
            return true;
        }
        if ((flags & 0xE) != 0) {
            if (!Crypto.isDERSignature(sig)) {
                return false;
            }
        }
        if ((flags & 8) != 0) {
            if (!Crypto.isLowDERSignature(CollectionsKt.toByteArray((Collection)ArraysKt.dropLast((byte[])sig, (int)1)))) {
                return false;
            }
        }
        if ((flags & 2) == 0) return true;
        if (Crypto.isDefinedHashTypeSignature(sig)) return true;
        return false;
    }

    @JvmStatic
    public static final boolean checkPubKeyEncoding(@NotNull byte[] key, int flags, int sigVersion) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if ((flags & 2) != 0) {
            if (!Crypto.isPubKeyCompressedOrUncompressed(key)) {
                boolean $i$a$-require-Crypto$checkPubKeyEncoding$32 = false;
                String $i$a$-require-Crypto$checkPubKeyEncoding$32 = "invalid public key";
                throw new IllegalArgumentException($i$a$-require-Crypto$checkPubKeyEncoding$32.toString());
            }
        }
        if ((flags & 0x8000) != 0 && sigVersion == 1) {
            if (!Crypto.isPubKeyCompressed(key)) {
                boolean bl = false;
                String string = "public key must be compressed in segwit";
                throw new IllegalArgumentException(string.toString());
            }
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final Pair<byte[], byte[]> decodeSignatureLax(@NotNull ByteArrayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(input.read() == 48)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Crypto.decodeSignatureLax$readLength(input);
        if (!(input.read() == 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int lenR = Crypto.decodeSignatureLax$readLength(input);
        byte[] r = new byte[lenR];
        input.read(r, 0, lenR);
        if (!(input.read() == 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int lenS = Crypto.decodeSignatureLax$readLength(input);
        byte[] s = new byte[lenS];
        input.read(s, 0, lenS);
        return new Pair((Object)r, (Object)s);
    }

    @JvmStatic
    @NotNull
    public static final Pair<PublicKey, PublicKey> recoverPublicKey(@NotNull ByteVector64 sig, @NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PublicKey p0 = Crypto.recoverPublicKey(sig, message, 0);
        PublicKey p1 = Crypto.recoverPublicKey(sig, message, 1);
        return new Pair((Object)p0, (Object)p1);
    }

    @JvmStatic
    @NotNull
    public static final PublicKey recoverPublicKey(@NotNull ByteVector64 sig, @NotNull byte[] message, int recid) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new PublicKey(PublicKey.Companion.compress(Secp256k1.Companion.ecdsaRecover(sig.toByteArray(), message, recid)));
    }

    @JvmStatic
    @NotNull
    public static final ByteVector32 taggedHash(@NotNull byte[] input, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        byte[] hashedTag = Crypto.sha256(StringsKt.encodeToByteArray((String)tag));
        return ByteVectorKt.byteVector32(Crypto.sha256(ArraysKt.plus((byte[])ArraysKt.plus((byte[])hashedTag, (byte[])hashedTag), (byte[])input)));
    }

    /*
     * WARNING - void declaration
     */
    private static final int decodeSignatureLax$readLength(ByteArrayInput $input) {
        int n;
        int len = $input.read();
        if ((len & 0x80) == 0) {
            n = len;
        } else {
            void var3_3;
            int len1 = 0;
            for (int n2 = len - 128; n2 > 0; --n2) {
                len1 = (len1 << 8) + $input.read();
            }
            n = var3_3;
        }
        return n;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lfr/acinq/bitcoin/Crypto$SchnorrTweak;", "", "()V", "NoTweak", "Lfr/acinq/bitcoin/Crypto$SchnorrTweak$NoTweak;", "Lfr/acinq/bitcoin/Crypto$TaprootTweak;", "bitcoin-kmp"})
    public static abstract class SchnorrTweak {
        private SchnorrTweak() {
        }

        public /* synthetic */ SchnorrTweak(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lfr/acinq/bitcoin/Crypto$SchnorrTweak$NoTweak;", "Lfr/acinq/bitcoin/Crypto$SchnorrTweak;", "()V", "bitcoin-kmp"})
        public static final class NoTweak
        extends SchnorrTweak {
            @NotNull
            public static final NoTweak INSTANCE = new NoTweak();

            private NoTweak() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lfr/acinq/bitcoin/Crypto$TaprootTweak;", "Lfr/acinq/bitcoin/Crypto$SchnorrTweak;", "()V", "NoScriptTweak", "ScriptTweak", "Lfr/acinq/bitcoin/Crypto$TaprootTweak$NoScriptTweak;", "Lfr/acinq/bitcoin/Crypto$TaprootTweak$ScriptTweak;", "bitcoin-kmp"})
    public static abstract class TaprootTweak
    extends SchnorrTweak {
        private TaprootTweak() {
            super(null);
        }

        public /* synthetic */ TaprootTweak(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lfr/acinq/bitcoin/Crypto$TaprootTweak$NoScriptTweak;", "Lfr/acinq/bitcoin/Crypto$TaprootTweak;", "()V", "bitcoin-kmp"})
        public static final class NoScriptTweak
        extends TaprootTweak {
            @NotNull
            public static final NoScriptTweak INSTANCE = new NoScriptTweak();

            private NoScriptTweak() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lfr/acinq/bitcoin/Crypto$TaprootTweak$ScriptTweak;", "Lfr/acinq/bitcoin/Crypto$TaprootTweak;", "merkleRoot", "Lfr/acinq/bitcoin/ByteVector32;", "(Lfr/acinq/bitcoin/ByteVector32;)V", "getMerkleRoot", "()Lfr/acinq/bitcoin/ByteVector32;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "bitcoin-kmp"})
        public static final class ScriptTweak
        extends TaprootTweak {
            @NotNull
            private final ByteVector32 merkleRoot;

            public ScriptTweak(@NotNull ByteVector32 merkleRoot) {
                Intrinsics.checkNotNullParameter((Object)merkleRoot, (String)"merkleRoot");
                super(null);
                this.merkleRoot = merkleRoot;
            }

            @NotNull
            public final ByteVector32 getMerkleRoot() {
                return this.merkleRoot;
            }

            @NotNull
            public final ByteVector32 component1() {
                return this.merkleRoot;
            }

            @NotNull
            public final ScriptTweak copy(@NotNull ByteVector32 merkleRoot) {
                Intrinsics.checkNotNullParameter((Object)merkleRoot, (String)"merkleRoot");
                return new ScriptTweak(merkleRoot);
            }

            public static /* synthetic */ ScriptTweak copy$default(ScriptTweak scriptTweak, ByteVector32 byteVector32, int n, Object object) {
                if ((n & 1) != 0) {
                    byteVector32 = scriptTweak.merkleRoot;
                }
                return scriptTweak.copy(byteVector32);
            }

            @NotNull
            public String toString() {
                return "ScriptTweak(merkleRoot=" + this.merkleRoot + ')';
            }

            public int hashCode() {
                return this.merkleRoot.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ScriptTweak)) {
                    return false;
                }
                ScriptTweak scriptTweak = (ScriptTweak)other;
                return Intrinsics.areEqual((Object)this.merkleRoot, (Object)scriptTweak.merkleRoot);
            }
        }
    }
}

