/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.Block;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.DeterministicWallet;
import fr.acinq.bitcoin.KeyPath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lfr/acinq/bitcoin/Descriptor;", "", "()V", "BIP84Descriptors", "Lkotlin/Pair;", "", "chainHash", "Lfr/acinq/bitcoin/ByteVector32;", "master", "Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPrivateKey;", "fingerprint", "", "accountPub", "Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPublicKey;", "checksum", "span", "getBIP84KeyPath", "", "polyMod", "cc", "value", "bitcoin-kmp"})
public final class Descriptor {
    @NotNull
    public static final Descriptor INSTANCE = new Descriptor();

    private Descriptor() {
    }

    private final long polyMod(long cc, int value) {
        long c = cc;
        long c0 = c >> 35;
        c = (c & 0x7FFFFFFFFL) << 5 ^ (long)value;
        if ((c0 & 1L) != 0L) {
            c ^= 0xF5DEE51989L;
        }
        if ((c0 & 2L) != 0L) {
            c ^= 0xA9FDCA3312L;
        }
        if ((c0 & 4L) != 0L) {
            c ^= 0x1BAB10E32DL;
        }
        if ((c0 & 8L) != 0L) {
            c ^= 0x3706B1677AL;
        }
        if ((c0 & 0x10L) != 0L) {
            c ^= 0x644D626FFDL;
        }
        return c;
    }

    @JvmStatic
    @NotNull
    public static final String checksum(@NotNull String span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        String INPUT_CHARSET = "0123456789()[],'/*abcdefgh@:$%{}IJKLMNOPQRSTUVWXYZ&+-.;<=>?!^_|~ijklmnopqrstuvwxyzABCDEFGH`#\"\\ ";
        String CHECKSUM_CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
        long c = 0L;
        c = 1L;
        int cls = 0;
        int clscount = 0;
        CharSequence $this$forEach$iv = span;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            int pos = StringsKt.indexOf$default((CharSequence)INPUT_CHARSET, (char)ch, (int)0, (boolean)false, (int)6, null);
            if (pos == -1) {
                return "";
            }
            c = INSTANCE.polyMod(c, pos & 0x1F);
            cls = cls * 3 + (pos >> 5);
            if (++clscount != 3) continue;
            c = INSTANCE.polyMod(c, cls);
            cls = 0;
            clscount = 0;
        }
        if (clscount > 0) {
            c = INSTANCE.polyMod(c, cls);
        }
        for (int j = 0; j < 8; ++j) {
            c = INSTANCE.polyMod(c, 0);
        }
        c ^= 1L;
        StringBuilder ret = new StringBuilder("        ");
        for (int j = 0; j < 8; ++j) {
            long pos1 = c >> 5 * (7 - j) & 0x1FL;
            char c2 = CHECKSUM_CHARSET.charAt((int)pos1);
            ret.setCharAt(j, c2);
        }
        String string = ret.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ret.toString()");
        return string;
    }

    private final Pair<String, Integer> getBIP84KeyPath(ByteVector32 chainHash) {
        Pair pair;
        ByteVector32 byteVector32 = chainHash;
        if (Intrinsics.areEqual((Object)byteVector32, (Object)Block.RegtestGenesisBlock.hash) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.TestnetGenesisBlock.hash)) {
            pair = TuplesKt.to((Object)"84'/1'/0'/0", (Object)70617039);
        } else if (Intrinsics.areEqual((Object)byteVector32, (Object)Block.LivenetGenesisBlock.hash)) {
            pair = TuplesKt.to((Object)"84'/0'/0'/0", (Object)76067358);
        } else {
            throw new IllegalStateException(("invalid chain hash " + chainHash).toString());
        }
        return pair;
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> BIP84Descriptors(@NotNull ByteVector32 chainHash, @NotNull DeterministicWallet.ExtendedPrivateKey master) {
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        Intrinsics.checkNotNullParameter((Object)master, (String)"master");
        String keyPath = (String)INSTANCE.getBIP84KeyPath(chainHash).component1();
        DeterministicWallet.ExtendedPublicKey accountPub = DeterministicWallet.publicKey(DeterministicWallet.derivePrivateKey(master, new KeyPath(keyPath)));
        long fingerprint = DeterministicWallet.fingerprint(master) & 0xFFFFFFFFL;
        return Descriptor.BIP84Descriptors(chainHash, fingerprint, accountPub);
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> BIP84Descriptors(@NotNull ByteVector32 chainHash, long fingerprint, @NotNull DeterministicWallet.ExtendedPublicKey accountPub) {
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        Intrinsics.checkNotNullParameter((Object)accountPub, (String)"accountPub");
        Pair<String, Integer> pair = INSTANCE.getBIP84KeyPath(chainHash);
        String keyPath = (String)pair.component1();
        int prefix = ((Number)pair.component2()).intValue();
        StringBuilder stringBuilder = new StringBuilder().append("wpkh([");
        String string = Long.toString(fingerprint, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        String accountDesc = stringBuilder.append(string).append('/').append(keyPath).append(']').append(DeterministicWallet.encode(accountPub, prefix)).append("/0/*)").toString();
        StringBuilder stringBuilder2 = new StringBuilder().append("wpkh([");
        String string2 = Long.toString(fingerprint, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        String changeDesc = stringBuilder2.append(string2).append('/').append(keyPath).append(']').append(DeterministicWallet.encode(accountPub, prefix)).append("/1/*)").toString();
        return new Pair((Object)(accountDesc + '#' + Descriptor.checksum(accountDesc)), (Object)(changeDesc + '#' + Descriptor.checksum(changeDesc)));
    }
}

