/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.MnemonicCode;
import fr.acinq.bitcoin.crypto.Pbkdf2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004H\u0002JA\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00040\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0010\u001a\u00020\u000b2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00040\u0004H\u0082\u0010J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0013\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u0015H\u0007J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0007J\u001e\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001b\u001a\u00020\u0005H\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0005H\u0007J&\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lfr/acinq/bitcoin/MnemonicCode;", "", "()V", "englishWordlist", "", "", "getEnglishWordlist", "()Ljava/util/List;", "englishWordlist$delegate", "Lkotlin/Lazy;", "fromBinary", "", "bin", "", "group", "items", "size", "acc", "toBinary", "x", "", "", "toMnemonics", "entropy", "wordlist", "toSeed", "mnemonics", "passphrase", "validate", "", "bitcoin-kmp"})
public final class MnemonicCode {
    @NotNull
    public static final MnemonicCode INSTANCE = new MnemonicCode();
    @NotNull
    private static final Lazy englishWordlist$delegate = LazyKt.lazy((Function0)englishWordlist.2.INSTANCE);

    private MnemonicCode() {
    }

    @NotNull
    public final List<String> getEnglishWordlist() {
        Lazy lazy = englishWordlist$delegate;
        return (List)lazy.getValue();
    }

    private final List<Boolean> toBinary(byte x) {
        List digits = MnemonicCode.toBinary$loop$default(x & 0xFF, null, 2, null);
        int n = 8 - digits.size();
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Boolean> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(false);
        }
        List zeroes = arrayList;
        return CollectionsKt.plus((Collection)zeroes, (Iterable)digits);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Boolean> toBinary(byte[] x) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        byte[] byArray = x;
        MnemonicCode mnemonicCode = INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mnemonicCode.toBinary((byte)p0));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final int fromBinary(List<Boolean> bin) {
        void $this$fold$iv;
        Iterable iterable = bin;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void flag;
            boolean bl = (Boolean)element$iv;
            int acc = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = flag != false ? 2 * acc + 1 : 2 * acc;
        }
        return accumulator$iv;
    }

    private final List<List<Boolean>> group(List<Boolean> items, int size, List<? extends List<Boolean>> acc) {
        List list;
        MnemonicCode mnemonicCode = this;
        List list2 = items;
        int n = size;
        List list3 = acc;
        while (true) {
            MnemonicCode mnemonicCode2 = mnemonicCode;
            List list4 = list2;
            int n2 = n;
            List list5 = list3;
            if (list4.isEmpty()) {
                list = list5;
                break;
            }
            if (list4.size() < n2) {
                list = CollectionsKt.plus((Collection)list5, (Iterable)CollectionsKt.listOf(list4));
                break;
            }
            List list6 = CollectionsKt.drop((Iterable)list4, (int)n2);
            List list7 = CollectionsKt.plus((Collection)list5, (Iterable)CollectionsKt.listOf((Object)CollectionsKt.take((Iterable)list4, (int)n2)));
            mnemonicCode = mnemonicCode2;
            list2 = list6;
            n = n2;
            list3 = list7;
        }
        return list;
    }

    static /* synthetic */ List group$default(MnemonicCode mnemonicCode, List list, int n, List list2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return mnemonicCode.group(list, n, list2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void validate(@NotNull List<String> mnemonics, @NotNull List<String> wordlist) {
        Iterable $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Object element$iv2;
        Collection collection;
        Iterator $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(mnemonics, (String)"mnemonics");
        Intrinsics.checkNotNullParameter(wordlist, (String)"wordlist");
        if (!(wordlist.size() == 2048)) {
            boolean $i$a$-require-MnemonicCode$validate$42 = false;
            String $i$a$-require-MnemonicCode$validate$42 = "invalid word list (size should be 2048)";
            throw new IllegalArgumentException($i$a$-require-MnemonicCode$validate$42.toString());
        }
        if (!(!((Collection)mnemonics).isEmpty())) {
            boolean $i$a$-require-MnemonicCode$validate$62 = false;
            String $i$a$-require-MnemonicCode$validate$62 = "mnemonic code cannot be empty";
            throw new IllegalArgumentException($i$a$-require-MnemonicCode$validate$62.toString());
        }
        if (!(mnemonics.size() % 3 == 0)) {
            boolean $i$a$-require-MnemonicCode$validate$72 = false;
            String $i$a$-require-MnemonicCode$validate$72 = "invalid mnemonic word count " + mnemonics.size() + ", it must be a multiple of 3";
            throw new IllegalArgumentException($i$a$-require-MnemonicCode$validate$72.toString());
        }
        Iterable $this$mapIndexed$iv = wordlist;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        Iterator iterator = $this$mapIndexedTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void index;
            void s;
            int n;
            Object item$iv$iv = iterator.next();
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)s, (Object)((int)index)));
        }
        Map wordMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = mnemonics;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String word = (String)element$iv2;
            boolean bl = false;
            if (wordMap.containsKey(word)) continue;
            boolean $i$a$-require-MnemonicCode$validate$4$22 = false;
            String $i$a$-require-MnemonicCode$validate$4$22 = "invalid mnemonic word " + word;
            throw new IllegalArgumentException($i$a$-require-MnemonicCode$validate$4$22.toString());
        }
        Iterable $this$map$iv = mnemonics;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void word;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Number)MapsKt.getValue((Map)wordMap, (Object)word)).intValue());
        }
        List indexes = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = indexes;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            int bl = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv3;
            boolean bl2 = false;
            collection.add(MnemonicCode.validate$toBits$default((int)it, null, 2, null));
        }
        List bits = CollectionsKt.flatten((Iterable)((List)destination$iv$iv3));
        int bitlength = bits.size() * 32 / 33;
        List databits = bits.subList(0, bitlength);
        List checksumbits = bits.subList(bitlength, bits.size());
        Iterable $this$map$iv3 = MnemonicCode.group$default(INSTANCE, databits, 8, null, 4, null);
        boolean $i$f$map3 = false;
        Iterable item$iv$iv = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv2;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(INSTANCE.fromBinary((List<Boolean>)it));
        }
        $this$map$iv3 = (List)destination$iv$iv4;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            int it = ((Number)item$iv$iv2).intValue();
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add((byte)it);
        }
        byte[] data = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv4));
        List check = CollectionsKt.take((Iterable)INSTANCE.toBinary(Crypto.sha256(data)), (int)(data.length / 4));
        if (!Intrinsics.areEqual((Object)check, checksumbits)) {
            boolean bl = false;
            String string = "invalid checksum";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static /* synthetic */ void validate$default(List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = INSTANCE.getEnglishWordlist();
        }
        MnemonicCode.validate(list, list2);
    }

    @JvmStatic
    public static final void validate(@NotNull String mnemonics) {
        Intrinsics.checkNotNullParameter((Object)mnemonics, (String)"mnemonics");
        String[] stringArray = new String[]{" "};
        MnemonicCode.validate$default(StringsKt.split$default((CharSequence)mnemonics, (String[])stringArray, (boolean)false, (int)0, (int)6, null), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> toMnemonics(@NotNull byte[] entropy, @NotNull List<String> wordlist) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        Intrinsics.checkNotNullParameter(wordlist, (String)"wordlist");
        if (!(wordlist.size() == 2048)) {
            boolean $i$a$-require-MnemonicCode$toMnemonics$22 = false;
            String $i$a$-require-MnemonicCode$toMnemonics$22 = "invalid word list (size should be 2048)";
            throw new IllegalArgumentException($i$a$-require-MnemonicCode$toMnemonics$22.toString());
        }
        List digits = CollectionsKt.plus((Collection)INSTANCE.toBinary(entropy), (Iterable)CollectionsKt.take((Iterable)INSTANCE.toBinary(Crypto.sha256(entropy)), (int)(entropy.length / 4)));
        Iterable $i$a$-require-MnemonicCode$toMnemonics$22 = MnemonicCode.group$default(INSTANCE, digits, 11, null, 4, null);
        MnemonicCode mnemonicCode = INSTANCE;
        boolean $i$f$map22 = false;
        void var6_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            List list = (List)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mnemonicCode.fromBinary((List<Boolean>)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int item$iv$iv2 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(wordlist.get((int)it));
        }
        return (List)destination$iv$iv2;
    }

    @JvmStatic
    @NotNull
    public static final List<String> toMnemonics(@NotNull byte[] entropy) {
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        return MnemonicCode.toMnemonics(entropy, INSTANCE.getEnglishWordlist());
    }

    @JvmStatic
    @NotNull
    public static final byte[] toSeed(@NotNull List<String> mnemonics, @NotNull String passphrase) {
        Intrinsics.checkNotNullParameter(mnemonics, (String)"mnemonics");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        byte[] password = StringsKt.encodeToByteArray((String)CollectionsKt.joinToString$default((Iterable)mnemonics, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        byte[] salt = StringsKt.encodeToByteArray((String)("mnemonic" + passphrase));
        return Pbkdf2.withHmacSha512(password, salt, 2048, 64);
    }

    @JvmStatic
    @NotNull
    public static final byte[] toSeed(@NotNull String mnemonics, @NotNull String passphrase) {
        Intrinsics.checkNotNullParameter((Object)mnemonics, (String)"mnemonics");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        String[] stringArray = new String[]{" "};
        return MnemonicCode.toSeed(StringsKt.split$default((CharSequence)mnemonics, (String[])stringArray, (boolean)false, (int)0, (int)6, null), passphrase);
    }

    private static final List<Boolean> toBinary$loop(int x, List<Boolean> acc) {
        List list;
        int n = x;
        List list2 = acc;
        while (true) {
            int n2 = n;
            list = list2;
            if (n2 == 0) break;
            int n3 = n2 / 2;
            List list3 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)(n2 % 2 != 0 ? 1 : 0)), (Iterable)list);
            n = n3;
            list2 = list3;
        }
        return list;
    }

    static /* synthetic */ List toBinary$loop$default(int n, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return MnemonicCode.toBinary$loop(n, list);
    }

    private static final List<Boolean> validate$toBits(int index, List<Boolean> acc) {
        List list;
        int n = index;
        List list2 = acc;
        while (true) {
            int n2 = n;
            list = list2;
            if (list.size() == 11) break;
            int n3 = n2 / 2;
            List list3 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)(n2 % 2 != 0 ? 1 : 0)), (Iterable)list);
            n = n3;
            list2 = list3;
        }
        return list;
    }

    static /* synthetic */ List validate$toBits$default(int n, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return MnemonicCode.validate$toBits(n, list);
    }
}

