/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.OP_0;
import fr.acinq.bitcoin.OP_1;
import fr.acinq.bitcoin.OP_1NEGATE;
import fr.acinq.bitcoin.OP_PUSHDATA1;
import fr.acinq.bitcoin.OP_PUSHDATA2;
import fr.acinq.bitcoin.PublicKey;
import fr.acinq.bitcoin.ScriptElt;
import fr.acinq.bitcoin.XonlyPublicKey;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0002\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lfr/acinq/bitcoin/OP_PUSHDATA;", "Lfr/acinq/bitcoin/ScriptElt;", "data", "", "code", "", "([BI)V", "([B)V", "Lfr/acinq/bitcoin/ByteVector;", "(Lfr/acinq/bitcoin/ByteVector;)V", "Lfr/acinq/bitcoin/ByteVector32;", "(Lfr/acinq/bitcoin/ByteVector32;)V", "publicKey", "Lfr/acinq/bitcoin/PublicKey;", "(Lfr/acinq/bitcoin/PublicKey;)V", "Lfr/acinq/bitcoin/XonlyPublicKey;", "(Lfr/acinq/bitcoin/XonlyPublicKey;)V", "opCode", "(Lfr/acinq/bitcoin/ByteVector;I)V", "getCode", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "bitcoin-kmp"})
public final class OP_PUSHDATA
extends ScriptElt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ByteVector data;
    @JvmField
    public final int opCode;

    public OP_PUSHDATA(@NotNull ByteVector data, int opCode) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(null);
        this.data = data;
        this.opCode = opCode;
    }

    @Override
    public int getCode() {
        return this.opCode;
    }

    public OP_PUSHDATA(@NotNull byte[] data, int code) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(ByteVectorKt.byteVector(data), code);
    }

    public OP_PUSHDATA(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, Companion.codeFromDataLength(data.length));
    }

    public OP_PUSHDATA(@NotNull ByteVector data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, Companion.codeFromDataLength(data.size()));
    }

    public OP_PUSHDATA(@NotNull ByteVector32 data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, Companion.codeFromDataLength(data.size()));
    }

    public OP_PUSHDATA(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this(publicKey.value);
    }

    public OP_PUSHDATA(@NotNull XonlyPublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this(publicKey.value);
    }

    @NotNull
    public final ByteVector component1() {
        return this.data;
    }

    public final int component2() {
        return this.opCode;
    }

    @NotNull
    public final OP_PUSHDATA copy(@NotNull ByteVector data, int opCode) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new OP_PUSHDATA(data, opCode);
    }

    public static /* synthetic */ OP_PUSHDATA copy$default(OP_PUSHDATA oP_PUSHDATA, ByteVector byteVector, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            byteVector = oP_PUSHDATA.data;
        }
        if ((n2 & 2) != 0) {
            n = oP_PUSHDATA.opCode;
        }
        return oP_PUSHDATA.copy(byteVector, n);
    }

    @NotNull
    public String toString() {
        return "OP_PUSHDATA(data=" + this.data + ", opCode=" + this.opCode + ')';
    }

    public int hashCode() {
        int result = this.data.hashCode();
        result = result * 31 + Integer.hashCode(this.opCode);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OP_PUSHDATA)) {
            return false;
        }
        OP_PUSHDATA oP_PUSHDATA = (OP_PUSHDATA)other;
        if (!Intrinsics.areEqual((Object)this.data, (Object)oP_PUSHDATA.data)) {
            return false;
        }
        return this.opCode == oP_PUSHDATA.opCode;
    }

    @JvmStatic
    public static final int codeFromDataLength(int length) {
        return Companion.codeFromDataLength(length);
    }

    @JvmStatic
    public static final boolean isMinimal(@NotNull byte[] data, int code) {
        return Companion.isMinimal(data, code);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lfr/acinq/bitcoin/OP_PUSHDATA$Companion;", "", "()V", "codeFromDataLength", "", "length", "isMinimal", "", "data", "", "code", "bitcoin-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int codeFromDataLength(int length) {
            int n;
            if (length < 76) {
                n = length;
            } else if (length < 255) {
                n = 76;
            } else if (length < 65535) {
                n = 77;
            } else if ((long)length < 0xFFFFFFFFL) {
                n = 78;
            } else {
                throw new IllegalArgumentException("data length is " + length + "}, too big for OP_PUSHDATA");
            }
            int code = n;
            return code;
        }

        @JvmStatic
        public final boolean isMinimal(@NotNull byte[] data, int code) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.length == 0 ? code == OP_0.INSTANCE.getCode() : (data.length == 1 && data[0] >= 1 && data[0] <= 16 ? code == OP_1.INSTANCE.getCode() + (data[0] - 1) : (data.length == 1 && data[0] == -127 ? code == OP_1NEGATE.INSTANCE.getCode() : (data.length <= 75 ? code == data.length : (data.length <= 255 ? code == OP_PUSHDATA1.INSTANCE.getCode() : (data.length <= 65535 ? code == OP_PUSHDATA2.INSTANCE.getCode() : true)))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

