/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.BtcSerializable;
import fr.acinq.bitcoin.BtcSerializer;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.Transaction;
import fr.acinq.bitcoin.io.Input;
import fr.acinq.bitcoin.io.Output;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0010\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\n2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lfr/acinq/bitcoin/OutPoint;", "Lfr/acinq/bitcoin/BtcSerializable;", "hash", "", "index", "", "([BJ)V", "tx", "Lfr/acinq/bitcoin/Transaction;", "(Lfr/acinq/bitcoin/Transaction;J)V", "Lfr/acinq/bitcoin/ByteVector32;", "(Lfr/acinq/bitcoin/ByteVector32;J)V", "isCoinbase", "", "()Z", "txid", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "serializer", "Lfr/acinq/bitcoin/BtcSerializer;", "toString", "", "Companion", "bitcoin-kmp"})
public final class OutPoint
implements BtcSerializable<OutPoint> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ByteVector32 hash;
    @JvmField
    public final long index;
    @JvmField
    @NotNull
    public final ByteVector32 txid;

    public OutPoint(@NotNull ByteVector32 hash, long index) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        this.hash = hash;
        this.index = index;
        if (!(this.index >= -1L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.txid = this.hash.reversed();
    }

    public OutPoint(@NotNull byte[] hash, long index) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        this(ByteVectorKt.byteVector32(hash), index);
    }

    public OutPoint(@NotNull Transaction tx, long index) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        this(tx.hash, index);
    }

    public final boolean isCoinbase() {
        return Companion.isCoinbase(this);
    }

    @Override
    @NotNull
    public BtcSerializer<OutPoint> serializer() {
        return Companion;
    }

    @NotNull
    public final ByteVector32 component1() {
        return this.hash;
    }

    public final long component2() {
        return this.index;
    }

    @NotNull
    public final OutPoint copy(@NotNull ByteVector32 hash, long index) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return new OutPoint(hash, index);
    }

    public static /* synthetic */ OutPoint copy$default(OutPoint outPoint, ByteVector32 byteVector32, long l, int n, Object object) {
        if ((n & 1) != 0) {
            byteVector32 = outPoint.hash;
        }
        if ((n & 2) != 0) {
            l = outPoint.index;
        }
        return outPoint.copy(byteVector32, l);
    }

    @NotNull
    public String toString() {
        return "OutPoint(hash=" + this.hash + ", index=" + this.index + ')';
    }

    public int hashCode() {
        int result = this.hash.hashCode();
        result = result * 31 + Long.hashCode(this.index);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OutPoint)) {
            return false;
        }
        OutPoint outPoint = (OutPoint)other;
        if (!Intrinsics.areEqual((Object)this.hash, (Object)outPoint.hash)) {
            return false;
        }
        return this.index == outPoint.index;
    }

    @JvmStatic
    @NotNull
    public static OutPoint read(@NotNull Input input, long protocolVersion) {
        return Companion.read(input, protocolVersion);
    }

    @JvmStatic
    @NotNull
    public static OutPoint read(@NotNull byte[] input) {
        return Companion.read(input);
    }

    @JvmStatic
    public static void write(@NotNull OutPoint message, @NotNull Output out, long protocolVersion) {
        Companion.write(message, out, protocolVersion);
    }

    @JvmStatic
    @NotNull
    public static byte[] write(@NotNull OutPoint message) {
        return Companion.write(message);
    }

    @JvmStatic
    public static final boolean isCoinbase(@NotNull OutPoint input) {
        return Companion.isCoinbase(input);
    }

    @JvmStatic
    public static final boolean isNull(@NotNull OutPoint input) {
        return Companion.isNull(input);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0007J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0007J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0017J \u0010\r\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\u0012"}, d2={"Lfr/acinq/bitcoin/OutPoint$Companion;", "Lfr/acinq/bitcoin/BtcSerializer;", "Lfr/acinq/bitcoin/OutPoint;", "()V", "isCoinbase", "", "input", "isNull", "read", "Lfr/acinq/bitcoin/io/Input;", "protocolVersion", "", "", "write", "message", "", "out", "Lfr/acinq/bitcoin/io/Output;", "bitcoin-kmp"})
    public static final class Companion
    extends BtcSerializer<OutPoint> {
        private Companion() {
        }

        @Override
        @JvmStatic
        @NotNull
        public OutPoint read(@NotNull Input input, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new OutPoint(BtcSerializer.Companion.hash(input), (long)BtcSerializer.Companion.uint32-OGnWXxg(input) & 0xFFFFFFFFL);
        }

        @Override
        @JvmStatic
        @NotNull
        public OutPoint read(@NotNull byte[] input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (OutPoint)super.read(input);
        }

        @Override
        @JvmStatic
        public void write(@NotNull OutPoint message, @NotNull Output out, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Output.DefaultImpls.write$default(out, message.hash.toByteArray(), 0, 0, 6, null);
            BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)message.index)), out);
        }

        @Override
        @JvmStatic
        @NotNull
        public byte[] write(@NotNull OutPoint message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return super.write(message);
        }

        @JvmStatic
        public final boolean isCoinbase(@NotNull OutPoint input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return input.index == 0xFFFFFFFFL && Intrinsics.areEqual((Object)input.hash, (Object)ByteVector32.Zeroes);
        }

        @JvmStatic
        public final boolean isNull(@NotNull OutPoint input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return this.isCoinbase(input);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

