/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.Base58Check;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.PublicKey;
import fr.acinq.bitcoin.XonlyPublicKey;
import fr.acinq.secp256k1.Hex;
import fr.acinq.secp256k1.Secp256k1;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\n\u001a\u00020\bH\u00c6\u0003J\u0006\u0010\u000b\u001a\u00020\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001aJ\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\bJ\t\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0006\u0010!\u001a\u00020\"R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lfr/acinq/bitcoin/PrivateKey;", "", "data", "", "([B)V", "Lfr/acinq/bitcoin/ByteVector;", "(Lfr/acinq/bitcoin/ByteVector;)V", "value", "Lfr/acinq/bitcoin/ByteVector32;", "(Lfr/acinq/bitcoin/ByteVector32;)V", "component1", "compress", "copy", "equals", "", "other", "hashCode", "", "isValid", "minus", "that", "plus", "publicKey", "Lfr/acinq/bitcoin/PublicKey;", "times", "toBase58", "", "prefix", "", "toHex", "toString", "tweak", "unaryMinus", "xOnlyPublicKey", "Lfr/acinq/bitcoin/XonlyPublicKey;", "Companion", "bitcoin-kmp"})
public final class PrivateKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ByteVector32 value;

    public PrivateKey(@NotNull ByteVector32 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    public PrivateKey(@NotNull byte[] data) {
        ByteVector32 byteVector32;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length == 32) {
            byte[] byArray = Arrays.copyOf(data, data.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
            byteVector32 = new ByteVector32(byArray);
        } else if (data.length == 33 && ArraysKt.last((byte[])data) == 1) {
            byte[] byArray = Arrays.copyOf(data, 32);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
            byteVector32 = new ByteVector32(byArray);
        } else {
            throw new RuntimeException("invalid private key length");
        }
        this(byteVector32);
    }

    public PrivateKey(@NotNull ByteVector data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data.toByteArray());
    }

    public final boolean isValid() {
        return Crypto.isPrivKeyValid(this.value.toByteArray());
    }

    @NotNull
    public final PrivateKey plus(@NotNull PrivateKey that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return new PrivateKey(Secp256k1.Companion.privKeyTweakAdd(this.value.toByteArray(), that.value.toByteArray()));
    }

    @NotNull
    public final PrivateKey unaryMinus() {
        return new PrivateKey(Secp256k1.Companion.privKeyNegate(this.value.toByteArray()));
    }

    @NotNull
    public final PrivateKey minus(@NotNull PrivateKey that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return this.plus(that.unaryMinus());
    }

    @NotNull
    public final PrivateKey times(@NotNull PrivateKey that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return new PrivateKey(Secp256k1.Companion.privKeyTweakMul(this.value.toByteArray(), that.value.toByteArray()));
    }

    @NotNull
    public final PrivateKey tweak(@NotNull ByteVector32 tweak) {
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        PrivateKey key = this.publicKey().isEven() ? this : this.unaryMinus();
        return key.plus(new PrivateKey(tweak));
    }

    @NotNull
    public final PublicKey publicKey() {
        byte[] pub = Secp256k1.Companion.pubkeyCreate(this.value.toByteArray());
        return new PublicKey(PublicKey.Companion.compress(pub));
    }

    @NotNull
    public final XonlyPublicKey xOnlyPublicKey() {
        return new XonlyPublicKey(this.publicKey());
    }

    @NotNull
    public final byte[] compress() {
        return ArraysKt.plus((byte[])this.value.toByteArray(), (byte)1);
    }

    @NotNull
    public final String toBase58(byte prefix) {
        return Base58Check.encode(prefix, this.compress());
    }

    @NotNull
    public final String toHex() {
        return this.value.toHex();
    }

    @NotNull
    public String toString() {
        return "<private_key>";
    }

    @NotNull
    public final ByteVector32 component1() {
        return this.value;
    }

    @NotNull
    public final PrivateKey copy(@NotNull ByteVector32 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new PrivateKey(value);
    }

    public static /* synthetic */ PrivateKey copy$default(PrivateKey privateKey, ByteVector32 byteVector32, int n, Object object) {
        if ((n & 1) != 0) {
            byteVector32 = privateKey.value;
        }
        return privateKey.copy(byteVector32);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrivateKey)) {
            return false;
        }
        PrivateKey privateKey = (PrivateKey)other;
        return Intrinsics.areEqual((Object)this.value, (Object)privateKey.value);
    }

    @JvmStatic
    public static final boolean isCompressed(@NotNull byte[] data) {
        return Companion.isCompressed(data);
    }

    @JvmStatic
    @NotNull
    public static final Pair<PrivateKey, Boolean> fromBase58(@NotNull String value, byte prefix) {
        return Companion.fromBase58(value, prefix);
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey fromHex(@NotNull String hex) {
        return Companion.fromHex(hex);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lfr/acinq/bitcoin/PrivateKey$Companion;", "", "()V", "fromBase58", "Lkotlin/Pair;", "Lfr/acinq/bitcoin/PrivateKey;", "", "value", "", "prefix", "", "fromHex", "hex", "isCompressed", "data", "", "bitcoin-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isCompressed(@NotNull byte[] data) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (data.length == 32) {
                bl = false;
            } else if (data.length == 33 && ArraysKt.last((byte[])data) == 1) {
                bl = true;
            } else {
                throw new IllegalArgumentException("invalid private key " + Hex.encode((byte[])data));
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public final Pair<PrivateKey, Boolean> fromBase58(@NotNull String value, byte prefix) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Byte[] byteArray = new Byte[]{(byte)-128, (byte)-17};
            if (!SetsKt.setOf((Object[])byteArray).contains(prefix)) {
                boolean $i$a$-require-PrivateKey$Companion$fromBase58$32 = false;
                String $i$a$-require-PrivateKey$Companion$fromBase58$32 = "invalid base 58 prefix for a private key";
                throw new IllegalArgumentException($i$a$-require-PrivateKey$Companion$fromBase58$32.toString());
            }
            byteArray = Base58Check.decode(value);
            byte prefix1 = ((Number)byteArray.component1()).byteValue();
            byte[] data = (byte[])byteArray.component2();
            if (!(prefix1 == prefix)) {
                boolean bl = false;
                String string = "prefix " + prefix1 + " does not match expected prefix " + prefix;
                throw new IllegalArgumentException(string.toString());
            }
            return new Pair((Object)new PrivateKey(data), (Object)this.isCompressed(data));
        }

        @JvmStatic
        @NotNull
        public final PrivateKey fromHex(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            return new PrivateKey(Hex.decode((String)hex));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

