/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.BtcSerializable;
import fr.acinq.bitcoin.BtcSerializer;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.ByteVector64;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.OP_CODESEPARATOR;
import fr.acinq.bitcoin.OutPoint;
import fr.acinq.bitcoin.PrivateKey;
import fr.acinq.bitcoin.Satoshi;
import fr.acinq.bitcoin.SatoshiKt;
import fr.acinq.bitcoin.Script;
import fr.acinq.bitcoin.ScriptElt;
import fr.acinq.bitcoin.ScriptWitness;
import fr.acinq.bitcoin.SigHash;
import fr.acinq.bitcoin.TxIn;
import fr.acinq.bitcoin.TxOut;
import fr.acinq.bitcoin.io.ByteArrayOutput;
import fr.acinq.bitcoin.io.Input;
import fr.acinq.bitcoin.io.Output;
import fr.acinq.secp256k1.Hex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00015B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010'\u001a\u00020\u001fJ\u0014\u0010(\u001a\u00020\u00002\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0014\u0010)\u001a\u00020\u00002\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u0005J\u0016\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020%J\u001c\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0005J\u0016\u0010/\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u001f2\u0006\u00100\u001a\u000201J\u0014\u00102\u001a\u00020\u00002\f\u00103\u001a\b\u0012\u0004\u0012\u0002010\u0005J\u0006\u00104\u001a\u00020\u001fR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lfr/acinq/bitcoin/Transaction;", "Lfr/acinq/bitcoin/BtcSerializable;", "version", "", "txIn", "", "Lfr/acinq/bitcoin/TxIn;", "txOut", "Lfr/acinq/bitcoin/TxOut;", "lockTime", "(JLjava/util/List;Ljava/util/List;J)V", "hasWitness", "", "getHasWitness", "()Z", "hash", "Lfr/acinq/bitcoin/ByteVector32;", "txid", "addInput", "input", "addOutput", "output", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "serializer", "Lfr/acinq/bitcoin/BtcSerializer;", "toString", "", "transactionData", "", "inputs", "sighashType", "updateInputs", "updateOutputs", "outputs", "updateSigScript", "i", "sigScript", "Lfr/acinq/bitcoin/ScriptElt;", "updateWitness", "witness", "Lfr/acinq/bitcoin/ScriptWitness;", "updateWitnesses", "witnesses", "weight", "Companion", "bitcoin-kmp"})
public final class Transaction
implements BtcSerializable<Transaction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final long version;
    @JvmField
    @NotNull
    public final List<TxIn> txIn;
    @JvmField
    @NotNull
    public final List<TxOut> txOut;
    @JvmField
    public final long lockTime;
    @JvmField
    @NotNull
    public final ByteVector32 hash;
    @JvmField
    @NotNull
    public final ByteVector32 txid;
    public static final long SERIALIZE_TRANSACTION_NO_WITNESS = 0x40000000L;
    public static final long LOCKTIME_THRESHOLD = 500000000L;

    public Transaction(long version, @NotNull List<TxIn> txIn, @NotNull List<TxOut> txOut, long lockTime) {
        Intrinsics.checkNotNullParameter(txIn, (String)"txIn");
        Intrinsics.checkNotNullParameter(txOut, (String)"txOut");
        this.version = version;
        this.txIn = txIn;
        this.txOut = txOut;
        this.lockTime = lockTime;
        this.hash = ByteVectorKt.byteVector32(Crypto.hash256(Companion.write(this, 0x40000000L)));
        this.txid = this.hash.reversed();
    }

    public final boolean getHasWitness() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.txIn;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TxIn it = (TxIn)element$iv;
                    boolean bl2 = false;
                    if (!it.getHasWitness()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Transaction updateSigScript(int i, @NotNull byte[] sigScript) {
        List list;
        Intrinsics.checkNotNullParameter((Object)sigScript, (String)"sigScript");
        TxIn updatedElement = TxIn.copy$default(this.txIn.get(i), null, ByteVectorKt.byteVector(sigScript), 0L, null, 13, null);
        List $this$updateSigScript_u24lambda_u2d1 = list = CollectionsKt.toMutableList((Collection)this.txIn);
        boolean bl = false;
        $this$updateSigScript_u24lambda_u2d1.set(i, updatedElement);
        List updated = list;
        return Transaction.copy$default(this, 0L, CollectionsKt.toList((Iterable)updated), null, 0L, 13, null);
    }

    @NotNull
    public final Transaction updateSigScript(int i, @NotNull List<? extends ScriptElt> sigScript) {
        Intrinsics.checkNotNullParameter(sigScript, (String)"sigScript");
        return this.updateSigScript(i, Script.write(sigScript));
    }

    @NotNull
    public final Transaction updateWitness(int i, @NotNull ScriptWitness witness) {
        List list;
        Intrinsics.checkNotNullParameter((Object)witness, (String)"witness");
        TxIn updatedElement = TxIn.copy$default(this.txIn.get(i), null, null, 0L, witness, 7, null);
        List $this$updateWitness_u24lambda_u2d2 = list = CollectionsKt.toMutableList((Collection)this.txIn);
        boolean bl = false;
        $this$updateWitness_u24lambda_u2d2.set(i, updatedElement);
        List updated = list;
        return Transaction.copy$default(this, 0L, CollectionsKt.toList((Iterable)updated), null, 0L, 13, null);
    }

    @NotNull
    public final Transaction updateWitnesses(@NotNull List<ScriptWitness> witnesses) {
        Intrinsics.checkNotNullParameter(witnesses, (String)"witnesses");
        if (!(((Collection)witnesses).size() == ((Collection)this.txIn).size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Transaction tx = this;
        int i = 0;
        int n = CollectionsKt.getLastIndex(this.txIn);
        if (i <= n) {
            while (true) {
                tx = tx.updateWitness(i, witnesses.get(i));
                if (i == n) break;
                ++i;
            }
        }
        return tx;
    }

    @NotNull
    public final Transaction updateInputs(@NotNull List<TxIn> inputs) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        return Transaction.copy$default(this, 0L, inputs, null, 0L, 13, null);
    }

    @NotNull
    public final Transaction addInput(@NotNull TxIn input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Transaction.copy$default(this, 0L, CollectionsKt.plus((Collection)this.txIn, (Object)input), null, 0L, 13, null);
    }

    @NotNull
    public final Transaction updateOutputs(@NotNull List<TxOut> outputs) {
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        return Transaction.copy$default(this, 0L, null, outputs, 0L, 11, null);
    }

    @NotNull
    public final Transaction addOutput(@NotNull TxOut output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return Transaction.copy$default(this, 0L, null, CollectionsKt.plus((Collection)this.txOut, (Object)output), 0L, 11, null);
    }

    public final int weight() {
        return Companion.weight(this);
    }

    @NotNull
    public final byte[] transactionData(@NotNull List<TxOut> inputs, int sighashType) {
        int outputType;
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        ByteArrayOutput out = new ByteArrayOutput();
        BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)this.version)), out);
        BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)this.lockTime)), out);
        int inputType = sighashType & 0x80;
        if (inputType != 128) {
            Output.DefaultImpls.write$default(out, Companion.prevoutsSha256(this), 0, 0, 6, null);
            Output.DefaultImpls.write$default(out, Companion.amountsSha256(inputs), 0, 0, 6, null);
            Output.DefaultImpls.write$default(out, Companion.scriptPubkeysSha256(inputs), 0, 0, 6, null);
            Output.DefaultImpls.write$default(out, Companion.sequencesSha256(this), 0, 0, 6, null);
        }
        int n = outputType = sighashType == 0 ? 1 : sighashType & 3;
        if (outputType == 1) {
            Output.DefaultImpls.write$default(out, Companion.outputsSha256(this), 0, 0, 6, null);
        }
        return out.toByteArray();
    }

    @NotNull
    public String toString() {
        return Hex.encode((byte[])Companion.write(this));
    }

    @Override
    @NotNull
    public BtcSerializer<Transaction> serializer() {
        return Companion;
    }

    public final long component1() {
        return this.version;
    }

    @NotNull
    public final List<TxIn> component2() {
        return this.txIn;
    }

    @NotNull
    public final List<TxOut> component3() {
        return this.txOut;
    }

    public final long component4() {
        return this.lockTime;
    }

    @NotNull
    public final Transaction copy(long version, @NotNull List<TxIn> txIn, @NotNull List<TxOut> txOut, long lockTime) {
        Intrinsics.checkNotNullParameter(txIn, (String)"txIn");
        Intrinsics.checkNotNullParameter(txOut, (String)"txOut");
        return new Transaction(version, txIn, txOut, lockTime);
    }

    public static /* synthetic */ Transaction copy$default(Transaction transaction, long l, List list, List list2, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = transaction.version;
        }
        if ((n & 2) != 0) {
            list = transaction.txIn;
        }
        if ((n & 4) != 0) {
            list2 = transaction.txOut;
        }
        if ((n & 8) != 0) {
            l2 = transaction.lockTime;
        }
        return transaction.copy(l, list, list2, l2);
    }

    public int hashCode() {
        int result = Long.hashCode(this.version);
        result = result * 31 + ((Object)this.txIn).hashCode();
        result = result * 31 + ((Object)this.txOut).hashCode();
        result = result * 31 + Long.hashCode(this.lockTime);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Transaction)) {
            return false;
        }
        Transaction transaction = (Transaction)other;
        if (this.version != transaction.version) {
            return false;
        }
        if (!Intrinsics.areEqual(this.txIn, transaction.txIn)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.txOut, transaction.txOut)) {
            return false;
        }
        return this.lockTime == transaction.lockTime;
    }

    @JvmStatic
    public static final boolean serializeTxWitness(long version) {
        return Companion.serializeTxWitness(version);
    }

    @JvmStatic
    public static void write(@NotNull Transaction tx, @NotNull Output out, long protocolVersion) {
        Companion.write(tx, out, protocolVersion);
    }

    @JvmStatic
    @NotNull
    public static byte[] write(@NotNull Transaction message) {
        return Companion.write(message);
    }

    @JvmStatic
    @NotNull
    public static Transaction read(@NotNull Input input, long protocolVersion) {
        return Companion.read(input, protocolVersion);
    }

    @JvmStatic
    @NotNull
    public static Transaction read(@NotNull String input) {
        return Companion.read(input);
    }

    @JvmStatic
    @NotNull
    public static Transaction read(@NotNull byte[] input) {
        return Companion.read(input);
    }

    @JvmStatic
    public static void validate(@NotNull Transaction input) {
        Companion.validate(input);
    }

    @JvmStatic
    public static final int baseSize(@NotNull Transaction tx, long protocolVersion) {
        return Companion.baseSize(tx, protocolVersion);
    }

    @JvmStatic
    public static final int totalSize(@NotNull Transaction tx, long protocolVersion) {
        return Companion.totalSize(tx, protocolVersion);
    }

    @JvmStatic
    public static final int weight(@NotNull Transaction tx, long protocolVersion) {
        return Companion.weight(tx, protocolVersion);
    }

    @JvmStatic
    public static final int weight(@NotNull Transaction tx) {
        return Companion.weight(tx);
    }

    @JvmStatic
    public static final boolean isCoinbase(@NotNull Transaction input) {
        return Companion.isCoinbase(input);
    }

    @JvmStatic
    @NotNull
    public static final byte[] prevoutsSha256(@NotNull Transaction tx) {
        return Companion.prevoutsSha256(tx);
    }

    @JvmStatic
    @NotNull
    public static final byte[] amountsSha256(@NotNull List<TxOut> inputs) {
        return Companion.amountsSha256(inputs);
    }

    @JvmStatic
    @NotNull
    public static final byte[] scriptPubkeysSha256(@NotNull List<TxOut> inputs) {
        return Companion.scriptPubkeysSha256(inputs);
    }

    @JvmStatic
    @NotNull
    public static final byte[] sequencesSha256(@NotNull Transaction tx) {
        return Companion.sequencesSha256(tx);
    }

    @JvmStatic
    @NotNull
    public static final byte[] outputsSha256(@NotNull Transaction tx) {
        return Companion.outputsSha256(tx);
    }

    @JvmStatic
    @NotNull
    public static final Transaction prepareForSigning(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType) {
        return Companion.prepareForSigning(tx, inputIndex, previousOutputScript, sighashType);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hashForSigning(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType) {
        return Companion.hashForSigning(tx, inputIndex, previousOutputScript, sighashType);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hashForSigning(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion) {
        return Companion.hashForSigning(tx, inputIndex, previousOutputScript, sighashType, amount2, signatureVersion);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hashForSigning(@NotNull Transaction tx, int inputIndex, @NotNull List<? extends ScriptElt> previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion) {
        return Companion.hashForSigning(tx, inputIndex, previousOutputScript, sighashType, amount2, signatureVersion);
    }

    @JvmStatic
    @NotNull
    public static final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion, @NotNull PrivateKey privateKey) {
        return Companion.signInput(tx, inputIndex, previousOutputScript, sighashType, amount2, signatureVersion, privateKey);
    }

    @JvmStatic
    @NotNull
    public static final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull ByteVector previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion, @NotNull PrivateKey privateKey) {
        return Companion.signInput(tx, inputIndex, previousOutputScript, sighashType, amount2, signatureVersion, privateKey);
    }

    @JvmStatic
    @NotNull
    public static final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull List<? extends ScriptElt> previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion, @NotNull PrivateKey privateKey) {
        return Companion.signInput(tx, inputIndex, previousOutputScript, sighashType, amount2, signatureVersion, privateKey);
    }

    @JvmStatic
    @NotNull
    public static final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType, @NotNull PrivateKey privateKey) {
        return Companion.signInput(tx, inputIndex, previousOutputScript, sighashType, privateKey);
    }

    @JvmStatic
    @NotNull
    public static final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull ByteVector previousOutputScript, int sighashType, @NotNull PrivateKey privateKey) {
        return Companion.signInput(tx, inputIndex, previousOutputScript, sighashType, privateKey);
    }

    @JvmStatic
    @NotNull
    public static final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull List<? extends ScriptElt> previousOutputScript, int sighashType, @NotNull PrivateKey privateKey) {
        return Companion.signInput(tx, inputIndex, previousOutputScript, sighashType, privateKey);
    }

    @JvmStatic
    @NotNull
    public static final ByteVector32 hashForSigningSchnorr(@NotNull Transaction tx, int inputIndex, @NotNull List<TxOut> inputs, int sighashType, int sigVersion, @NotNull Script.ExecutionData executionData) {
        return Companion.hashForSigningSchnorr(tx, inputIndex, inputs, sighashType, sigVersion, executionData);
    }

    @JvmStatic
    public static final void correctlySpends(@NotNull Transaction tx, @NotNull Map<OutPoint, TxOut> previousOutputs, int scriptFlags) {
        Companion.correctlySpends(tx, previousOutputs, scriptFlags);
    }

    @JvmStatic
    public static final void correctlySpends(@NotNull Transaction tx, @NotNull List<Transaction> inputs, int scriptFlags) {
        Companion.correctlySpends(tx, inputs, scriptFlags);
    }

    @JvmStatic
    public static final void correctlySpends(@NotNull Transaction tx, @NotNull Transaction parent, int scriptFlags) {
        Companion.correctlySpends(tx, parent, scriptFlags);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\rH\u0007J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0013\u001a\u00020\rH\u0007J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u0013\u001a\u00020\rH\u0007J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\rH\u0007J8\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0007J>\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001e0\n2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0007J@\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0002H\u0007J\u0010\u0010'\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0007J(\u0010(\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\rH\u0007J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0007J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010&\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u0005H\u0017J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\bH\u0017J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010&\u001a\u00020,H\u0017J\u0016\u0010-\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0007J\u0010\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u0005H\u0007J0\u00101\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u0002022\u0006\u0010\u001a\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0007J@\u00101\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u0002022\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0007J0\u00101\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0007J@\u00101\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0007J6\u00101\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001e0\n2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0007JF\u00101\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001e0\n2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0007J\u001a\u00105\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u00106\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0002H\u0017J\u0010\u00107\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0007J\u001a\u00107\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\u0002H\u0017J \u00108\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010:\u001a\u00020;2\u0006\u0010\u000f\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lfr/acinq/bitcoin/Transaction$Companion;", "Lfr/acinq/bitcoin/BtcSerializer;", "Lfr/acinq/bitcoin/Transaction;", "()V", "LOCKTIME_THRESHOLD", "", "SERIALIZE_TRANSACTION_NO_WITNESS", "amountsSha256", "", "inputs", "", "Lfr/acinq/bitcoin/TxOut;", "baseSize", "", "tx", "protocolVersion", "correctlySpends", "", "parent", "scriptFlags", "previousOutputs", "", "Lfr/acinq/bitcoin/OutPoint;", "hashForSigning", "inputIndex", "previousOutputScript", "sighashType", "amount", "Lfr/acinq/bitcoin/Satoshi;", "signatureVersion", "Lfr/acinq/bitcoin/ScriptElt;", "hashForSigningSchnorr", "Lfr/acinq/bitcoin/ByteVector32;", "sigVersion", "executionData", "Lfr/acinq/bitcoin/Script$ExecutionData;", "isCoinbase", "", "input", "outputsSha256", "prepareForSigning", "prevoutsSha256", "read", "Lfr/acinq/bitcoin/io/Input;", "", "scriptPubkeysSha256", "sequencesSha256", "serializeTxWitness", "version", "signInput", "Lfr/acinq/bitcoin/ByteVector;", "privateKey", "Lfr/acinq/bitcoin/PrivateKey;", "totalSize", "validate", "weight", "write", "message", "out", "Lfr/acinq/bitcoin/io/Output;", "bitcoin-kmp"})
    public static final class Companion
    extends BtcSerializer<Transaction> {
        private Companion() {
        }

        @JvmStatic
        public final boolean serializeTxWitness(long version) {
            return (version & 0x40000000L) == 0L;
        }

        @Override
        @JvmStatic
        public void write(@NotNull Transaction tx, @NotNull Output out, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            if (this.serializeTxWitness(protocolVersion) && tx.getHasWitness()) {
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)tx.version)), out);
                BtcSerializer.Companion.writeUInt8-0ky7B_Q((byte)0, out);
                BtcSerializer.Companion.writeUInt8-0ky7B_Q((byte)1, out);
                BtcSerializer.Companion.writeCollection(tx.txIn, out, TxIn.Companion, protocolVersion);
                BtcSerializer.Companion.writeCollection(tx.txOut, out, TxOut.Companion, protocolVersion);
                Iterable $this$forEach$iv = tx.txIn;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TxIn it = (TxIn)element$iv;
                    boolean bl = false;
                    ScriptWitness.Companion.write(it.witness, out, protocolVersion);
                }
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)tx.lockTime)), out);
            } else {
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)tx.version)), out);
                BtcSerializer.Companion.writeCollection(tx.txIn, out, TxIn.Companion, protocolVersion);
                BtcSerializer.Companion.writeCollection(tx.txOut, out, TxOut.Companion, protocolVersion);
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)tx.lockTime)), out);
            }
        }

        @Override
        @JvmStatic
        @NotNull
        public byte[] write(@NotNull Transaction message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return super.write(message);
        }

        @Override
        @JvmStatic
        @NotNull
        public Transaction read(@NotNull Input input, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Transaction tx = new Transaction((long)BtcSerializer.Companion.uint32-OGnWXxg(input) & 0xFFFFFFFFL, BtcSerializer.Companion.readCollection(input, TxIn.Companion, protocolVersion), CollectionsKt.emptyList(), 0L);
            int flags = 0;
            if (tx.txIn.isEmpty() && this.serializeTxWitness(protocolVersion)) {
                flags = BtcSerializer.Companion.uint8-Wa3L5BU(input) & 0xFF;
                if (flags != 0) {
                    tx = tx.updateInputs(BtcSerializer.Companion.readCollection(input, TxIn.Companion, protocolVersion));
                    tx = tx.updateOutputs(BtcSerializer.Companion.readCollection(input, TxOut.Companion, protocolVersion));
                }
            } else {
                tx = tx.updateOutputs(BtcSerializer.Companion.readCollection(input, TxOut.Companion, protocolVersion));
            }
            if ((flags & 1) != 0 && this.serializeTxWitness(protocolVersion)) {
                flags ^= 1;
                List witnesses = new ArrayList();
                int i = 0;
                int n = CollectionsKt.getLastIndex(tx.txIn);
                if (i <= n) {
                    while (true) {
                        ((Collection)witnesses).add(ScriptWitness.Companion.read(input, protocolVersion));
                        if (i == n) break;
                        ++i;
                    }
                }
                if (!(tx = tx.updateWitnesses(CollectionsKt.toList((Iterable)witnesses))).getHasWitness()) {
                    boolean bl = false;
                    String string = "Superfluous witness record";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            if (!(flags == 0)) {
                boolean bl = false;
                String string = "Unknown transaction optional data";
                throw new IllegalArgumentException(string.toString());
            }
            tx = Transaction.copy$default(tx, 0L, null, null, (long)BtcSerializer.Companion.uint32-OGnWXxg(input) & 0xFFFFFFFFL, 7, null);
            return tx;
        }

        @Override
        @JvmStatic
        @NotNull
        public Transaction read(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (Transaction)super.read(input);
        }

        @Override
        @JvmStatic
        @NotNull
        public Transaction read(@NotNull byte[] input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (Transaction)super.read(input);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @JvmStatic
        public void validate(@NotNull Transaction input) {
            void $this$mapTo$iv$iv;
            BtcSerializable<TxIn> it;
            Object element$iv2;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (!(!((Collection)input.txIn).isEmpty())) {
                boolean $i$a$-require-Transaction$Companion$validate$32 = false;
                String $i$a$-require-Transaction$Companion$validate$32 = "input list cannot be empty";
                throw new IllegalArgumentException($i$a$-require-Transaction$Companion$validate$32.toString());
            }
            if (!(!((Collection)input.txOut).isEmpty())) {
                boolean $i$a$-require-Transaction$Companion$validate$42 = false;
                String $i$a$-require-Transaction$Companion$validate$42 = "output list cannot be empty";
                throw new IllegalArgumentException($i$a$-require-Transaction$Companion$validate$42.toString());
            }
            Iterable $this$forEach$iv = input.txIn;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (TxIn)element$iv2;
                boolean bl = false;
                TxIn.Companion.validate((TxIn)it);
            }
            $this$forEach$iv = input.txOut;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (TxOut)element$iv2;
                boolean bl = false;
                TxOut.Companion.validate((TxOut)it);
            }
            Iterable $this$map$iv = input.txIn;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                TxIn txIn = (TxIn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.outPoint);
            }
            List outPoints = (List)destination$iv$iv;
            if (!(((Collection)outPoints).size() == CollectionsKt.toSet((Iterable)outPoints).size())) {
                boolean $i$a$-require-Transaction$Companion$validate$82 = false;
                String $i$a$-require-Transaction$Companion$validate$82 = "duplicate inputs";
                throw new IllegalArgumentException($i$a$-require-Transaction$Companion$validate$82.toString());
            }
            if (this.isCoinbase(input)) {
                if (!(((TxIn)CollectionsKt.first(input.txIn)).signatureScript.size() >= 2)) {
                    boolean $i$a$-require-Transaction$Companion$validate$102 = false;
                    String $i$a$-require-Transaction$Companion$validate$102 = "coinbase script size";
                    throw new IllegalArgumentException($i$a$-require-Transaction$Companion$validate$102.toString());
                }
                if (!(((TxIn)CollectionsKt.first(input.txIn)).signatureScript.size() <= 100)) {
                    boolean $i$a$-require-Transaction$Companion$validate$112 = false;
                    String $i$a$-require-Transaction$Companion$validate$112 = "coinbase script size";
                    throw new IllegalArgumentException($i$a$-require-Transaction$Companion$validate$112.toString());
                }
            } else {
                boolean bl;
                block14: {
                    Iterable $this$all$iv = input.txIn;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv3 : $this$all$iv) {
                            TxIn it3 = (TxIn)element$iv3;
                            boolean bl2 = false;
                            if (!OutPoint.Companion.isCoinbase(it3.outPoint)) continue;
                            bl = false;
                            break block14;
                        }
                        bl = true;
                    }
                }
                if (!bl) {
                    boolean bl3 = false;
                    String string = "prevout is null";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        @JvmStatic
        public final int baseSize(@NotNull Transaction tx, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            return this.write(tx, protocolVersion | 0x40000000L).length;
        }

        public static /* synthetic */ int baseSize$default(Companion companion, Transaction transaction, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 70015L;
            }
            return companion.baseSize(transaction, l);
        }

        @JvmStatic
        public final int totalSize(@NotNull Transaction tx, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            return this.write(tx, protocolVersion).length;
        }

        public static /* synthetic */ int totalSize$default(Companion companion, Transaction transaction, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 70015L;
            }
            return companion.totalSize(transaction, l);
        }

        @JvmStatic
        public final int weight(@NotNull Transaction tx, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            return this.totalSize(tx, protocolVersion) + 3 * this.baseSize(tx, protocolVersion);
        }

        public static /* synthetic */ int weight$default(Companion companion, Transaction transaction, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 70015L;
            }
            return companion.weight(transaction, l);
        }

        @JvmStatic
        public final int weight(@NotNull Transaction tx) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            return this.weight(tx, 70015L);
        }

        @JvmStatic
        public final boolean isCoinbase(@NotNull Transaction input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return ((Collection)input.txIn).size() == 1 && OutPoint.Companion.isCoinbase(((TxIn)CollectionsKt.first(input.txIn)).outPoint);
        }

        @JvmStatic
        @NotNull
        public final byte[] prevoutsSha256(@NotNull Transaction tx) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            ByteArrayOutput buffer = new ByteArrayOutput();
            Iterable $this$forEach$iv = tx.txIn;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TxIn it = (TxIn)element$iv;
                boolean bl = false;
                OutPoint.Companion.write(it.outPoint, buffer);
            }
            return Crypto.sha256(buffer.toByteArray());
        }

        @JvmStatic
        @NotNull
        public final byte[] amountsSha256(@NotNull List<TxOut> inputs) {
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            ByteArrayOutput buffer = new ByteArrayOutput();
            Iterable $this$forEach$iv = inputs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TxOut it = (TxOut)element$iv;
                boolean bl = false;
                BtcSerializer.Companion.writeUInt64-4PLdz1A(it.amount.toULong-s-VKNKU(), buffer);
            }
            return Crypto.sha256(buffer.toByteArray());
        }

        @JvmStatic
        @NotNull
        public final byte[] scriptPubkeysSha256(@NotNull List<TxOut> inputs) {
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            ByteArrayOutput buffer = new ByteArrayOutput();
            Iterable $this$forEach$iv = inputs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TxOut it = (TxOut)element$iv;
                boolean bl = false;
                BtcSerializer.Companion.writeScript(it.publicKeyScript, (Output)buffer);
            }
            return Crypto.sha256(buffer.toByteArray());
        }

        @JvmStatic
        @NotNull
        public final byte[] sequencesSha256(@NotNull Transaction tx) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            ByteArrayOutput buffer = new ByteArrayOutput();
            Iterable $this$forEach$iv = tx.txIn;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TxIn it = (TxIn)element$iv;
                boolean bl = false;
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)it.sequence)), buffer);
            }
            return Crypto.sha256(buffer.toByteArray());
        }

        @JvmStatic
        @NotNull
        public final byte[] outputsSha256(@NotNull Transaction tx) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            ByteArrayOutput buffer = new ByteArrayOutput();
            Iterable $this$forEach$iv = tx.txOut;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TxOut it = (TxOut)element$iv;
                boolean bl = false;
                TxOut.Companion.write(it, buffer);
            }
            return Crypto.sha256(buffer.toByteArray());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Transaction prepareForSigning(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType) {
            Transaction transaction;
            List<TxIn> inputs;
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)previousOutputScript, (String)"previousOutputScript");
            Iterable $this$filterNot$iv = Script.parse(previousOutputScript);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ScriptElt it = (ScriptElt)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)OP_CODESEPARATOR.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            byte[] filteredScript = Script.write((List)destination$iv$iv);
            Transaction tx1 = fr.acinq.bitcoin.Transaction$Companion.prepareForSigning$removeAllSignatureScripts(tx);
            Transaction tx2 = fr.acinq.bitcoin.Transaction$Companion.prepareForSigning$updateSignatureScript(tx1, inputIndex, filteredScript);
            if (SigHash.isHashNone(sighashType)) {
                inputs = fr.acinq.bitcoin.Transaction$Companion.prepareForSigning$resetSequence(tx2.txIn, inputIndex);
                transaction = Transaction.copy$default(tx2, 0L, inputs, CollectionsKt.emptyList(), 0L, 9, null);
            } else if (SigHash.isHashSingle(sighashType)) {
                inputs = fr.acinq.bitcoin.Transaction$Companion.prepareForSigning$resetSequence(tx2.txIn, inputIndex);
                List outputs = new ArrayList();
                int i = 0;
                if (i <= inputIndex) {
                    while (true) {
                        ((Collection)outputs).add(i == inputIndex ? tx2.txOut.get(inputIndex) : new TxOut(SatoshiKt.toSatoshi(-1L), new byte[0]));
                        if (i == inputIndex) break;
                        ++i;
                    }
                }
                transaction = Transaction.copy$default(tx2, 0L, inputs, CollectionsKt.toList((Iterable)outputs), 0L, 9, null);
            } else {
                transaction = tx2;
            }
            Transaction tx3 = transaction;
            Transaction tx4 = SigHash.isAnyoneCanPay(sighashType) ? Transaction.copy$default(tx3, 0L, CollectionsKt.listOf((Object)tx3.txIn.get(inputIndex)), null, 0L, 13, null) : tx3;
            return tx4;
        }

        @JvmStatic
        @NotNull
        public final byte[] hashForSigning(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)previousOutputScript, (String)"previousOutputScript");
            if (SigHash.isHashSingle(sighashType) && inputIndex >= ((Collection)tx.txOut).size()) {
                byArray = ByteVector32.One.toByteArray();
            } else {
                Transaction txCopy = this.prepareForSigning(tx, inputIndex, previousOutputScript, sighashType);
                byArray = Crypto.hash256(ArraysKt.plus((byte[])Companion.write(txCopy, 0x40000000L), (byte[])BtcSerializer.Companion.writeUInt32-WZ4Q5Ns(UInt.constructor-impl((int)sighashType))));
            }
            return byArray;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final byte[] hashForSigning(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)previousOutputScript, (String)"previousOutputScript");
            Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
            if (signatureVersion == 1) {
                byte[] byArray;
                byte[] hashSequence;
                byte[] byArray2;
                byte[] hashPrevOut;
                byte[] byArray3;
                Collection collection;
                if (!SigHash.isAnyoneCanPay(sighashType)) {
                    void $this$fold$iv;
                    Object it;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv = tx.txIn;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Iterator iterator = (TxIn)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(((TxIn)it).outPoint);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (OutPoint)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(OutPoint.Companion.write(it, 70015L));
                    }
                    List arrays = (List)destination$iv$iv;
                    Iterable $i$f$map2 = arrays;
                    byte[] initial$iv = new byte[]{};
                    boolean $i$f$fold = false;
                    byte[] accumulator$iv = initial$iv;
                    for (Iterator element$iv : $this$fold$iv) {
                        void b;
                        it = (byte[])element$iv;
                        byte[] acc = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = ArraysKt.plus((byte[])acc, (byte[])b);
                    }
                    byte[] concatenated = accumulator$iv;
                    byArray3 = Crypto.hash256(concatenated);
                } else {
                    byArray3 = hashPrevOut = new byte[32];
                }
                if (!(SigHash.isAnyoneCanPay(sighashType) || SigHash.isHashSingle(sighashType) || SigHash.isHashNone(sighashType))) {
                    void $this$fold$iv;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv = tx.txIn;
                    boolean $i$f$map = false;
                    Iterable $i$f$fold = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        TxIn acc = (TxIn)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.sequence);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        long it = ((Number)item$iv$iv).longValue();
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(BtcSerializer.Companion.writeUInt32-WZ4Q5Ns(UInt.constructor-impl((int)((int)it))));
                    }
                    List arrays = (List)destination$iv$iv;
                    Iterable $i$f$map3 = arrays;
                    byte[] initial$iv = new byte[]{};
                    boolean $i$f$fold2 = false;
                    byte[] accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void b;
                        byte[] it = (byte[])element$iv;
                        byte[] acc = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = ArraysKt.plus((byte[])acc, (byte[])b);
                    }
                    byte[] concatenated = accumulator$iv;
                    byArray2 = Crypto.hash256(concatenated);
                } else {
                    byArray2 = hashSequence = new byte[32];
                }
                if (!SigHash.isHashSingle(sighashType) && !SigHash.isHashNone(sighashType)) {
                    void $this$fold$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = tx.txOut;
                    boolean $i$f$map42 = false;
                    Iterable $i$f$fold2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        TxOut acc = (TxOut)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(TxOut.Companion.write(it, 70015L));
                    }
                    List arrays = (List)destination$iv$iv;
                    Iterable $i$f$map42 = arrays;
                    byte[] initial$iv = new byte[]{};
                    boolean $i$f$fold = false;
                    byte[] accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void b;
                        byte[] it = (byte[])element$iv;
                        byte[] acc = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = ArraysKt.plus((byte[])acc, (byte[])b);
                    }
                    byte[] concatenated = accumulator$iv;
                    byArray = Crypto.hash256(concatenated);
                } else {
                    byArray = SigHash.isHashSingle(sighashType) && inputIndex < ((Collection)tx.txOut).size() ? Crypto.hash256(TxOut.Companion.write(tx.txOut.get(inputIndex), 70015L)) : new byte[32];
                }
                byte[] hashOutputs = byArray;
                ByteArrayOutput out = new ByteArrayOutput();
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)tx.version)), out);
                Output.DefaultImpls.write$default(out, hashPrevOut, 0, 0, 6, null);
                Output.DefaultImpls.write$default(out, hashSequence, 0, 0, 6, null);
                Output.DefaultImpls.write$default(out, OutPoint.Companion.write(tx.txIn.get((int)inputIndex).outPoint, 70015L), 0, 0, 6, null);
                BtcSerializer.Companion.writeScript(previousOutputScript, (Output)out);
                BtcSerializer.Companion.writeUInt64-4PLdz1A(amount2.toULong-s-VKNKU(), out);
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)tx.txIn.get((int)inputIndex).sequence)), out);
                Output.DefaultImpls.write$default(out, hashOutputs, 0, 0, 6, null);
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)tx.lockTime)), out);
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)sighashType), out);
                byte[] preimage = out.toByteArray();
                return Crypto.hash256(preimage);
            }
            return this.hashForSigning(tx, inputIndex, previousOutputScript, sighashType);
        }

        @JvmStatic
        @NotNull
        public final byte[] hashForSigning(@NotNull Transaction tx, int inputIndex, @NotNull List<? extends ScriptElt> previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter(previousOutputScript, (String)"previousOutputScript");
            Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
            return this.hashForSigning(tx, inputIndex, Script.write(previousOutputScript), sighashType, amount2, signatureVersion);
        }

        @JvmStatic
        @NotNull
        public final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion, @NotNull PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)previousOutputScript, (String)"previousOutputScript");
            Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            byte[] hash = this.hashForSigning(tx, inputIndex, previousOutputScript, sighashType, amount2, signatureVersion);
            ByteVector64 sig = Crypto.sign(hash, privateKey);
            return ArraysKt.plus((byte[])Crypto.compact2der(sig).toByteArray(), (byte)((byte)sighashType));
        }

        @JvmStatic
        @NotNull
        public final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull ByteVector previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion, @NotNull PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)previousOutputScript, (String)"previousOutputScript");
            Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            return this.signInput(tx, inputIndex, previousOutputScript.toByteArray(), sighashType, amount2, signatureVersion, privateKey);
        }

        @JvmStatic
        @NotNull
        public final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull List<? extends ScriptElt> previousOutputScript, int sighashType, @NotNull Satoshi amount2, int signatureVersion, @NotNull PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter(previousOutputScript, (String)"previousOutputScript");
            Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            return this.signInput(tx, inputIndex, Script.write(previousOutputScript), sighashType, amount2, signatureVersion, privateKey);
        }

        @JvmStatic
        @NotNull
        public final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull byte[] previousOutputScript, int sighashType, @NotNull PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)previousOutputScript, (String)"previousOutputScript");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            return this.signInput(tx, inputIndex, previousOutputScript, sighashType, new Satoshi(0L), 0, privateKey);
        }

        @JvmStatic
        @NotNull
        public final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull ByteVector previousOutputScript, int sighashType, @NotNull PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)previousOutputScript, (String)"previousOutputScript");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            return this.signInput(tx, inputIndex, previousOutputScript.toByteArray(), sighashType, privateKey);
        }

        @JvmStatic
        @NotNull
        public final byte[] signInput(@NotNull Transaction tx, int inputIndex, @NotNull List<? extends ScriptElt> previousOutputScript, int sighashType, @NotNull PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter(previousOutputScript, (String)"previousOutputScript");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            return this.signInput(tx, inputIndex, Script.write(previousOutputScript), sighashType, privateKey);
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @NotNull
        public final ByteVector32 hashForSigningSchnorr(@NotNull Transaction tx, int inputIndex, @NotNull List<TxOut> inputs, int sighashType, int sigVersion, @NotNull Script.ExecutionData executionData) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            Intrinsics.checkNotNullParameter((Object)executionData, (String)"executionData");
            out = new ByteArrayOutput();
            out.write(0);
            if (sighashType <= 3) ** GOTO lbl-1000
            v0 = 129 <= sighashType ? sighashType < 132 : false;
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (!v1) {
                var9_8 = "Failed requirement.";
                throw new IllegalArgumentException(var9_8.toString());
            }
            out.write(sighashType);
            txData = tx.transactionData(inputs, sighashType);
            Output.DefaultImpls.write$default(out, txData, 0, 0, 6, null);
            var9_9 = sigVersion == 3 ? new Pair((Object)1, (Object)0) : new Pair((Object)0, (Object)0);
            extFlag = ((Number)var9_9.component1()).intValue();
            keyVersion = ((Number)var9_9.component2()).intValue();
            spendType = 2 * extFlag + (executionData.getAnnex() != null ? 1 : 0);
            out.write(spendType);
            inputType = sighashType & 128;
            if (inputType == 128) {
                OutPoint.Companion.write(tx.txIn.get((int)inputIndex).outPoint, out);
                TxOut.Companion.write(inputs.get(inputIndex), out);
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)tx.txIn.get((int)inputIndex).sequence)), out);
            } else {
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)inputIndex), out);
            }
            if (executionData.getAnnex() != null) {
                buffer = new ByteArrayOutput();
                BtcSerializer.Companion.writeScript(executionData.getAnnex(), (Output)buffer);
                annexHash = Crypto.sha256(buffer.toByteArray());
                Output.DefaultImpls.write$default(out, annexHash, 0, 0, 6, null);
            }
            v2 = outputType = sighashType == 0 ? 1 : sighashType & 3;
            if (outputType == 3) {
                Output.DefaultImpls.write$default(out, Crypto.sha256(TxOut.Companion.write(tx.txOut.get(inputIndex))), 0, 0, 6, null);
            }
            if (sigVersion == 3) {
                if (!(executionData.getTapleafHash() != null)) {
                    $i$a$-require-Transaction$Companion$hashForSigningSchnorr$1 = false;
                    var16_19 = "tapleaf hash is missing";
                    throw new IllegalArgumentException(var16_19.toString());
                }
                Output.DefaultImpls.write$default(out, executionData.getTapleafHash().toByteArray(), 0, 0, 6, null);
                out.write(keyVersion);
                BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)executionData.getCodeSeparatorPos())), out);
            }
            preimage = out.toByteArray();
            return Crypto.taggedHash(preimage, "TapSighash");
        }

        public static /* synthetic */ ByteVector32 hashForSigningSchnorr$default(Companion companion, Transaction transaction, int n, List list, int n2, int n3, Script.ExecutionData executionData, int n4, Object object) {
            if ((n4 & 0x20) != 0) {
                executionData = Script.ExecutionData.Companion.getEmpty();
            }
            return companion.hashForSigningSchnorr(transaction, n, list, n2, n3, executionData);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void correctlySpends(@NotNull Transaction tx, @NotNull Map<OutPoint, TxOut> previousOutputs, int scriptFlags) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter(previousOutputs, (String)"previousOutputs");
            Iterable $this$map$iv = tx.txIn;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TxIn txIn = (TxIn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TxOut txOut = previousOutputs.get(it.outPoint);
                Intrinsics.checkNotNull((Object)txOut);
                collection.add(txOut);
            }
            List prevouts = (List)destination$iv$iv;
            int n = ((Collection)tx.txIn).size();
            for (int i = 0; i < n; ++i) {
                if (OutPoint.Companion.isCoinbase(tx.txIn.get((int)i).outPoint)) continue;
                TxOut prevOutput = (TxOut)MapsKt.getValue(previousOutputs, (Object)tx.txIn.get((int)i).outPoint);
                Satoshi amount2 = prevOutput.amount;
                Script.Context ctx = new Script.Context(tx, i, amount2, prevouts);
                Script.Runner runner = new Script.Runner(ctx, scriptFlags);
                ByteVector prevOutputScript = prevOutput.publicKeyScript;
                if (runner.verifyScripts(tx.txIn.get((int)i).signatureScript, prevOutputScript, tx.txIn.get((int)i).witness)) continue;
                throw new RuntimeException("tx " + tx.txid + " does not spend its input #" + i);
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void correctlySpends(@NotNull Transaction tx, @NotNull List<Transaction> inputs, int scriptFlags) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            Map map = new LinkedHashMap();
            Iterable $this$map$iv = tx.txIn;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TxIn txIn = (TxIn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.outPoint);
            }
            for (OutPoint outPoint : (List)destination$iv$iv) {
                Transaction prevTx;
                Iterator iterator;
                block3: {
                    Iterable iterable2 = inputs;
                    for (Iterator iterator2 : iterable2) {
                        Transaction it = (Transaction)((Object)iterator2);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.txid, (Object)outPoint.txid)) continue;
                        iterator = iterator2;
                        break block3;
                    }
                    iterator = null;
                }
                Transaction transaction = prevTx = (Transaction)((Object)iterator);
                List<TxOut> list = transaction != null ? transaction.txOut : null;
                Intrinsics.checkNotNull(list);
                TxOut prevOut = list.get((int)outPoint.index);
                map.put(outPoint, prevOut);
            }
            this.correctlySpends(tx, MapsKt.toMap((Map)map), scriptFlags);
        }

        @JvmStatic
        public final void correctlySpends(@NotNull Transaction tx, @NotNull Transaction parent, int scriptFlags) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.correctlySpends(tx, CollectionsKt.listOf((Object)parent), scriptFlags);
        }

        private static final TxIn prepareForSigning$removeSignatureScript(TxIn txin) {
            return TxIn.copy$default(txin, null, ByteVector.empty, 0L, null, 13, null);
        }

        /*
         * WARNING - void declaration
         */
        private static final Transaction prepareForSigning$removeAllSignatureScripts(Transaction tx) {
            Collection<TxIn> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = tx.txIn;
            long l = 0L;
            Transaction transaction = tx;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TxIn txIn = (TxIn)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(fr.acinq.bitcoin.Transaction$Companion.prepareForSigning$removeSignatureScript((TxIn)it));
            }
            collection = (List)destination$iv$iv;
            return Transaction.copy$default(transaction, l, (List)collection, null, 0L, 13, null);
        }

        private static final Transaction prepareForSigning$updateSignatureScript(Transaction tx, int index, byte[] script) {
            return tx.updateSigScript(index, script);
        }

        private static final List<TxIn> prepareForSigning$resetSequence(List<TxIn> txins, int inputIndex) {
            int i = 0;
            List result = CollectionsKt.toMutableList((Collection)txins);
            int n = CollectionsKt.getLastIndex((List)result);
            if (i <= n) {
                while (true) {
                    if (i != inputIndex) {
                        result.set(i, TxIn.copy$default((TxIn)result.get(i), null, null, 0L, null, 11, null));
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            return CollectionsKt.toList((Iterable)result);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

