/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.BtcSerializable;
import fr.acinq.bitcoin.BtcSerializer;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.Satoshi;
import fr.acinq.bitcoin.SatoshiKt;
import fr.acinq.bitcoin.Script;
import fr.acinq.bitcoin.ScriptElt;
import fr.acinq.bitcoin.io.Input;
import fr.acinq.bitcoin.io.Output;
import java.util.List;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\nH\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0005J\u0014\u0010\u001b\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010\u001d\u001a\u00020\u0014R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lfr/acinq/bitcoin/TxOut;", "Lfr/acinq/bitcoin/BtcSerializable;", "amount", "Lfr/acinq/bitcoin/Satoshi;", "publicKeyScript", "", "(Lfr/acinq/bitcoin/Satoshi;[B)V", "", "Lfr/acinq/bitcoin/ScriptElt;", "(Lfr/acinq/bitcoin/Satoshi;Ljava/util/List;)V", "Lfr/acinq/bitcoin/ByteVector;", "(Lfr/acinq/bitcoin/Satoshi;Lfr/acinq/bitcoin/ByteVector;)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "serializer", "Lfr/acinq/bitcoin/BtcSerializer;", "toString", "", "updateAmount", "newAmount", "updatePublicKeyScript", "input", "weight", "Companion", "bitcoin-kmp"})
public final class TxOut
implements BtcSerializable<TxOut> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Satoshi amount;
    @JvmField
    @NotNull
    public final ByteVector publicKeyScript;

    public TxOut(@NotNull Satoshi amount2, @NotNull ByteVector publicKeyScript) {
        Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)publicKeyScript, (String)"publicKeyScript");
        this.amount = amount2;
        this.publicKeyScript = publicKeyScript;
    }

    public TxOut(@NotNull Satoshi amount2, @NotNull byte[] publicKeyScript) {
        Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)publicKeyScript, (String)"publicKeyScript");
        this(amount2, ByteVectorKt.byteVector(publicKeyScript));
    }

    public TxOut(@NotNull Satoshi amount2, @NotNull List<? extends ScriptElt> publicKeyScript) {
        Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
        Intrinsics.checkNotNullParameter(publicKeyScript, (String)"publicKeyScript");
        this(amount2, ByteVectorKt.byteVector(Script.write(publicKeyScript)));
    }

    @NotNull
    public final TxOut updateAmount(@NotNull Satoshi newAmount) {
        Intrinsics.checkNotNullParameter((Object)newAmount, (String)"newAmount");
        return TxOut.copy$default(this, newAmount, null, 2, null);
    }

    @NotNull
    public final TxOut updatePublicKeyScript(@NotNull ByteVector input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return TxOut.copy$default(this, null, input, 1, null);
    }

    @NotNull
    public final TxOut updatePublicKeyScript(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.updatePublicKeyScript(ByteVectorKt.byteVector(input));
    }

    @NotNull
    public final TxOut updatePublicKeyScript(@NotNull List<? extends ScriptElt> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return this.updatePublicKeyScript(Script.write(input));
    }

    public final int weight() {
        return fr.acinq.bitcoin.TxOut$Companion.weight$default(Companion, this, 0L, 2, null);
    }

    @Override
    @NotNull
    public BtcSerializer<TxOut> serializer() {
        return Companion;
    }

    @NotNull
    public final Satoshi component1() {
        return this.amount;
    }

    @NotNull
    public final ByteVector component2() {
        return this.publicKeyScript;
    }

    @NotNull
    public final TxOut copy(@NotNull Satoshi amount2, @NotNull ByteVector publicKeyScript) {
        Intrinsics.checkNotNullParameter((Object)amount2, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)publicKeyScript, (String)"publicKeyScript");
        return new TxOut(amount2, publicKeyScript);
    }

    public static /* synthetic */ TxOut copy$default(TxOut txOut, Satoshi satoshi, ByteVector byteVector, int n, Object object) {
        if ((n & 1) != 0) {
            satoshi = txOut.amount;
        }
        if ((n & 2) != 0) {
            byteVector = txOut.publicKeyScript;
        }
        return txOut.copy(satoshi, byteVector);
    }

    @NotNull
    public String toString() {
        return "TxOut(amount=" + this.amount + ", publicKeyScript=" + this.publicKeyScript + ')';
    }

    public int hashCode() {
        int result = this.amount.hashCode();
        result = result * 31 + this.publicKeyScript.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TxOut)) {
            return false;
        }
        TxOut txOut = (TxOut)other;
        if (!Intrinsics.areEqual((Object)this.amount, (Object)txOut.amount)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.publicKeyScript, (Object)txOut.publicKeyScript);
    }

    @JvmStatic
    public static void write(@NotNull TxOut t, @NotNull Output out, long protocolVersion) {
        Companion.write(t, out, protocolVersion);
    }

    @JvmStatic
    @NotNull
    public static byte[] write(@NotNull TxOut message) {
        return Companion.write(message);
    }

    @JvmStatic
    @NotNull
    public static TxOut read(@NotNull Input input, long protocolVersion) {
        return Companion.read(input, protocolVersion);
    }

    @JvmStatic
    @NotNull
    public static TxOut read(@NotNull byte[] input) {
        return Companion.read(input);
    }

    @JvmStatic
    public static void validate(@NotNull TxOut t) {
        Companion.validate(t);
    }

    @JvmStatic
    public static final int totalSize(@NotNull TxOut txOut, long protocolVersion) {
        return Companion.totalSize(txOut, protocolVersion);
    }

    @JvmStatic
    public static final int weight(@NotNull TxOut txOut, long protocolVersion) {
        return Companion.weight(txOut, protocolVersion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\tH\u0017J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0017J\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0002H\u0017J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u0015"}, d2={"Lfr/acinq/bitcoin/TxOut$Companion;", "Lfr/acinq/bitcoin/BtcSerializer;", "Lfr/acinq/bitcoin/TxOut;", "()V", "read", "input", "Lfr/acinq/bitcoin/io/Input;", "protocolVersion", "", "", "totalSize", "", "txOut", "validate", "", "t", "weight", "write", "message", "out", "Lfr/acinq/bitcoin/io/Output;", "bitcoin-kmp"})
    public static final class Companion
    extends BtcSerializer<TxOut> {
        private Companion() {
        }

        @Override
        @JvmStatic
        public void write(@NotNull TxOut t, @NotNull Output out, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            BtcSerializer.Companion.writeUInt64-4PLdz1A(ULong.constructor-impl((long)t.amount.toLong()), out);
            BtcSerializer.Companion.writeScript(t.publicKeyScript, out);
        }

        @Override
        @JvmStatic
        @NotNull
        public byte[] write(@NotNull TxOut message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return super.write(message);
        }

        @Override
        @JvmStatic
        @NotNull
        public TxOut read(@NotNull Input input, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new TxOut(SatoshiKt.toSatoshi(BtcSerializer.Companion.uint64-I7RO_PI(input)), BtcSerializer.Companion.script(input));
        }

        @Override
        @JvmStatic
        @NotNull
        public TxOut read(@NotNull byte[] input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (TxOut)super.read(input);
        }

        @Override
        @JvmStatic
        public void validate(@NotNull TxOut t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Satoshi satoshi = new Satoshi(0L);
            Satoshi satoshi2 = Satoshi.Companion.getMAX_MONEY();
            Satoshi satoshi3 = t.amount;
            if (!(0 <= satoshi3.compareTo((Object)satoshi) ? satoshi3.compareTo((Object)satoshi2) <= 0 : false)) {
                boolean $i$a$-require-TxOut$Companion$validate$32 = false;
                String $i$a$-require-TxOut$Companion$validate$32 = "invalid txout amount: " + t.amount;
                throw new IllegalArgumentException($i$a$-require-TxOut$Companion$validate$32.toString());
            }
            if (!(t.publicKeyScript.size() < 520)) {
                boolean bl = false;
                String string = "public key script is " + t.publicKeyScript.size() + " bytes, limit is 520 bytes";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @JvmStatic
        public final int totalSize(@NotNull TxOut txOut, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)txOut, (String)"txOut");
            return this.write(txOut, protocolVersion).length;
        }

        public static /* synthetic */ int totalSize$default(Companion companion, TxOut txOut, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 70015L;
            }
            return companion.totalSize(txOut, l);
        }

        @JvmStatic
        public final int weight(@NotNull TxOut txOut, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)txOut, (String)"txOut");
            return 4 * this.totalSize(txOut, protocolVersion);
        }

        public static /* synthetic */ int weight$default(Companion companion, TxOut txOut, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 70015L;
            }
            return companion.weight(txOut, l);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

