/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.crypto.Pack;
import fr.acinq.secp256k1.Hex;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.UInt;
import kotlin.UIntArray;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u0011\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0016\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0006\u0010\u0018\u001a\u00020\u0005J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\t\u0010\u001a\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u001b\u001a\u00020\u0000J\u0011\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000eH\u0086\u0004J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000eH\u0086\u0004J\u0011\u0010\"\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020&H\u0016J\t\u0010'\u001a\u00020\u0000H\u0086\u0002R\u0019\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006)"}, d2={"Lfr/acinq/bitcoin/UInt256;", "", "rhs", "(Lfr/acinq/bitcoin/UInt256;)V", "value", "", "(J)V", "", "([B)V", "()V", "pn", "Lkotlin/UIntArray;", "[I", "bits", "", "compareTo", "other", "divAssign", "", "encodeCompact", "fNegative", "", "equals", "", "getLow64", "hashCode", "inc", "inv", "minusAssign", "plusAssign", "setUInt64", "shl", "bitCount", "shr", "timesAssign", "toDouble", "", "toString", "", "unaryMinus", "Companion", "bitcoin-kmp"})
public final class UInt256
implements Comparable<UInt256> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] pn;
    private static final int WIDTH = 8;
    @JvmField
    @NotNull
    public static final UInt256 Zero = new UInt256();

    public UInt256() {
        this.pn = UIntArray.constructor-impl((int)8);
    }

    public UInt256(@NotNull UInt256 rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        this();
        int[] nArray = rhs.pn;
        int[] nArray2 = this.pn;
        int n = 0;
        int n2 = 0;
        int n3 = UIntArray.getSize-impl((int[])nArray);
        ArraysKt.copyInto((int[])nArray, (int[])nArray2, (int)n, (int)n2, (int)n3);
    }

    public UInt256(long value) {
        this();
        this.setUInt64(value);
    }

    public UInt256(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this();
        if (!(value.length <= 32)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] reversed = ArraysKt.plus((byte[])ArraysKt.reversedArray((byte[])value), (byte[])new byte[32 - value.length]);
        for (int i = 0; i < 8; ++i) {
            UIntArray.set-VXSXFK8((int[])this.pn, (int)i, (int)UInt.constructor-impl((int)Pack.int32LE(reversed, 4 * i)));
        }
    }

    public final void setUInt64(long value) {
        UIntArray.set-VXSXFK8((int[])this.pn, (int)0, (int)UInt.constructor-impl((int)((int)(value & 0xFFFFFFFFL))));
        UIntArray.set-VXSXFK8((int[])this.pn, (int)1, (int)UInt.constructor-impl((int)((int)(value >>> 32 & 0xFFFFFFFFL))));
        for (int i = 2; i < 8; ++i) {
            UIntArray.set-VXSXFK8((int[])this.pn, (int)i, (int)0);
        }
    }

    @Override
    public int compareTo(@NotNull UInt256 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (int i = 7; -1 < i; --i) {
            if (Integer.compareUnsigned(UIntArray.get-pVg5ArA((int[])this.pn, (int)i), UIntArray.get-pVg5ArA((int[])other.pn, (int)i)) < 0) {
                return -1;
            }
            if (Integer.compareUnsigned(UIntArray.get-pVg5ArA((int[])this.pn, (int)i), UIntArray.get-pVg5ArA((int[])other.pn, (int)i)) <= 0) continue;
            return 1;
        }
        return 0;
    }

    @NotNull
    public final UInt256 inc() {
        int i = 0;
        while (i < 8) {
            int[] nArray = this.pn;
            int n = i++;
            UIntArray.set-VXSXFK8((int[])nArray, (int)n, (int)UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])nArray, (int)n) + 1)));
            if (UIntArray.get-pVg5ArA((int[])nArray, (int)n) == 0) continue;
        }
        return this;
    }

    @NotNull
    public final UInt256 unaryMinus() {
        UInt256 a = new UInt256(this);
        int n = UIntArray.getSize-impl((int[])a.pn);
        for (int i = 0; i < n; ++i) {
            UIntArray.set-VXSXFK8((int[])a.pn, (int)i, (int)UInt.constructor-impl((int)(~UIntArray.get-pVg5ArA((int[])a.pn, (int)i))));
        }
        return a.inc();
    }

    public final void plusAssign(@NotNull UInt256 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long carry = 0L;
        for (int i = 0; i < 8; ++i) {
            long n = carry + ((long)UIntArray.get-pVg5ArA((int[])this.pn, (int)i) & 0xFFFFFFFFL) + ((long)UIntArray.get-pVg5ArA((int[])other.pn, (int)i) & 0xFFFFFFFFL);
            UIntArray.set-VXSXFK8((int[])this.pn, (int)i, (int)UInt.constructor-impl((int)((int)(n & 0xFFFFFFFFL))));
            carry = n >>> 32;
        }
    }

    public final void minusAssign(@NotNull UInt256 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.plusAssign(other.unaryMinus());
    }

    public final void divAssign(@NotNull UInt256 other) {
        int shift;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        UInt256 div = other;
        UInt256 num = new UInt256(this);
        int n = UIntArray.getSize-impl((int[])this.pn);
        for (int i = 0; i < n; ++i) {
            UIntArray.set-VXSXFK8((int[])this.pn, (int)i, (int)0);
        }
        int num_bits = num.bits();
        int div_bits = div.bits();
        if (!(div_bits > 0)) {
            boolean bl = false;
            String string = "division by zero";
            throw new IllegalArgumentException(string.toString());
        }
        if (div_bits > num_bits) {
            return;
        }
        div = div.shl(shift);
        for (shift = num_bits - div_bits; shift >= 0; --shift) {
            if (num.compareTo(div) >= 0) {
                num.minusAssign(div);
                UIntArray.set-VXSXFK8((int[])this.pn, (int)(shift / 32), (int)UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])this.pn, (int)(shift / 32)) | UInt.constructor-impl((int)(1 << (shift & 0x1F))))));
            }
            div = div.shr(1);
        }
    }

    public final void timesAssign(@NotNull UInt256 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        UInt256 a = new UInt256();
        for (int j = 0; j < 8; ++j) {
            long carry = 0L;
            int i = 0;
            while (i + j < 8) {
                long n = ULong.constructor-impl((long)(ULong.constructor-impl((long)(carry + ULong.constructor-impl((long)((long)UIntArray.get-pVg5ArA((int[])a.pn, (int)(i + j)) & 0xFFFFFFFFL)))) + ULong.constructor-impl((long)(ULong.constructor-impl((long)((long)UIntArray.get-pVg5ArA((int[])this.pn, (int)j) & 0xFFFFFFFFL)) * ULong.constructor-impl((long)((long)UIntArray.get-pVg5ArA((int[])other.pn, (int)i) & 0xFFFFFFFFL))))));
                UIntArray.set-VXSXFK8((int[])a.pn, (int)(i + j), (int)UInt.constructor-impl((int)((int)ULong.constructor-impl((long)(n & 0xFFFFFFFFL)))));
                carry = ULong.constructor-impl((long)(n >>> 32));
                ++i;
            }
        }
        int[] nArray = a.pn;
        int[] nArray2 = this.pn;
        int n = 0;
        int n2 = 0;
        int n3 = UIntArray.getSize-impl((int[])nArray);
        ArraysKt.copyInto((int[])nArray, (int[])nArray2, (int)n, (int)n2, (int)n3);
    }

    @NotNull
    public final UInt256 shl(int bitCount) {
        UInt256 a = new UInt256();
        int k = bitCount / 32;
        int shift = bitCount % 32;
        for (int i = 0; i < 8; ++i) {
            if (i + k + 1 < 8 && shift != 0) {
                UIntArray.set-VXSXFK8((int[])a.pn, (int)(i + k + 1), (int)UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])a.pn, (int)(i + k + 1)) | UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])this.pn, (int)i) >>> 32 - shift)))));
            }
            if (i + k >= 8) continue;
            UIntArray.set-VXSXFK8((int[])a.pn, (int)(i + k), (int)UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])a.pn, (int)(i + k)) | UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])this.pn, (int)i) << shift)))));
        }
        return a;
    }

    @NotNull
    public final UInt256 shr(int bitCount) {
        UInt256 a = new UInt256();
        int k = bitCount / 32;
        int shift = bitCount % 32;
        for (int i = 0; i < 8; ++i) {
            if (i - k - 1 >= 0 && shift != 0) {
                UIntArray.set-VXSXFK8((int[])a.pn, (int)(i - k - 1), (int)UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])a.pn, (int)(i - k - 1)) | UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])this.pn, (int)i) << 32 - shift)))));
            }
            if (i - k < 0) continue;
            UIntArray.set-VXSXFK8((int[])a.pn, (int)(i - k), (int)UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])a.pn, (int)(i - k)) | UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])this.pn, (int)i) >>> shift)))));
        }
        return a;
    }

    @NotNull
    public final UInt256 inv() {
        UInt256 a = new UInt256(this);
        int n = UIntArray.getSize-impl((int[])a.pn);
        for (int i = 0; i < n; ++i) {
            UIntArray.set-VXSXFK8((int[])a.pn, (int)i, (int)UInt.constructor-impl((int)(~UIntArray.get-pVg5ArA((int[])a.pn, (int)i))));
        }
        return a;
    }

    public final int bits() {
        for (int pos = 7; -1 < pos; --pos) {
            if (UIntArray.get-pVg5ArA((int[])this.pn, (int)pos) == 0) continue;
            for (int nbits = 31; -1 < nbits; --nbits) {
                if (UInt.constructor-impl((int)(UIntArray.get-pVg5ArA((int[])this.pn, (int)pos) & UInt.constructor-impl((int)(1 << nbits)))) == 0) continue;
                return 32 * pos + nbits + 1;
            }
            return 32 * pos + 1;
        }
        return 0;
    }

    public final long getLow64() {
        return (long)UIntArray.get-pVg5ArA((int[])this.pn, (int)0) & 0xFFFFFFFFL | ((long)UIntArray.get-pVg5ArA((int[])this.pn, (int)1) & 0xFFFFFFFFL) << 32;
    }

    public final long encodeCompact(boolean fNegative) {
        long nCompact;
        long l;
        int nSize = (this.bits() + 7) / 8;
        if (nSize <= 3) {
            l = this.getLow64() << 8 * (3 - nSize);
        } else {
            UInt256 bn = new UInt256(this).shr(8 * (nSize - 3));
            l = nCompact = bn.getLow64();
        }
        if ((nCompact & 0x800000L) != 0L) {
            nCompact >>>= 8;
            ++nSize;
        }
        if (!((nCompact & 0xFFFFFFFFFF800000L) == 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(nSize < 256)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (fNegative && ((nCompact |= (long)nSize << 24) & 0xFFFFFFFFFF800000L) != 0L) {
            nCompact |= 0x800000L;
        }
        return nCompact;
    }

    public final double toDouble() {
        double ret = 0.0;
        double fact = 1.0;
        for (int i = 0; i < 8; ++i) {
            ret += fact * UnsignedKt.uintToDouble((int)UIntArray.get-pVg5ArA((int[])this.pn, (int)i));
            fact *= 4.294967296E9;
        }
        return ret;
    }

    @NotNull
    public String toString() {
        byte[] bytes = new byte[32];
        for (int i = 0; i < 8; ++i) {
            Pack.writeInt32LE(UIntArray.get-pVg5ArA((int[])this.pn, (int)i), bytes, 4 * i);
        }
        return Hex.encode((byte[])ArraysKt.reversedArray((byte[])bytes));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        UInt256 cfr_ignored_0 = (UInt256)other;
        return UArraysKt.contentEquals-KJPZfPQ((int[])this.pn, (int[])((UInt256)other).pn);
    }

    public int hashCode() {
        return UArraysKt.contentHashCode-XUkPCBk((int[])this.pn);
    }

    @JvmStatic
    @NotNull
    public static final Triple<UInt256, Boolean, Boolean> decodeCompact(long nCompact) {
        return Companion.decodeCompact(nCompact);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lfr/acinq/bitcoin/UInt256$Companion;", "", "()V", "WIDTH", "", "Zero", "Lfr/acinq/bitcoin/UInt256;", "decodeCompact", "Lkotlin/Triple;", "", "nCompact", "", "bitcoin-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Triple<UInt256, Boolean, Boolean> decodeCompact(long nCompact) {
            int nSize = (int)(nCompact >>> 24);
            long nWord = nCompact & 0x7FFFFFL;
            UInt256 result = new UInt256();
            if (nSize <= 3) {
                result.setUInt64(nWord >>>= 8 * (3 - nSize));
            } else {
                result.setUInt64(nWord);
                result = result.shl(8 * (nSize - 3));
            }
            boolean pfNegative = nWord != 0L && (nCompact & 0x800000L) != 0L;
            boolean pfOverflow = nWord != 0L && (nSize > 34 || nWord > 255L && nSize > 33 || nWord > 65535L && nSize > 32);
            return new Triple((Object)result, (Object)pfNegative, (Object)pfOverflow);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

