/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin.crypto;

import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lfr/acinq/bitcoin/crypto/Pbkdf2;", "", "()V", "withHmacSha512", "", "password", "salt", "count", "", "dkLen", "bitcoin-kmp"})
public final class Pbkdf2 {
    @NotNull
    public static final Pbkdf2 INSTANCE = new Pbkdf2();

    private Pbkdf2() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] withHmacSha512(@NotNull byte[] password, @NotNull byte[] salt, int count, int dkLen) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        int n = 0;
        int n2 = password.length;
        char[] cArray = new char[n2];
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = (char)password[n3];
        }
        int n4 = dkLen * 8;
        int n5 = count;
        byte[] byArray = salt;
        char[] cArray2 = cArray;
        byte[] byArray2 = secretKeyFactory.generateSecret(new PBEKeySpec(cArray2, byArray, n5, n4)).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getInstance(\"PBKDF2WithH\u2026   )\n            .encoded");
        return byArray2;
    }
}

