/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin.io;

import fr.acinq.bitcoin.io.Input;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u0006H\u0016J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfr/acinq/bitcoin/io/ByteArrayInput;", "Lfr/acinq/bitcoin/io/Input;", "array", "", "([B)V", "availableBytes", "", "getAvailableBytes", "()I", "position", "read", "b", "offset", "length", "bitcoin-kmp"})
public final class ByteArrayInput
implements Input {
    @NotNull
    private final byte[] array;
    private int position;

    public ByteArrayInput(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
    }

    @Override
    public int getAvailableBytes() {
        return this.array.length - this.position;
    }

    @Override
    public int read() {
        int n;
        if (this.position < this.array.length) {
            int n2 = this.position;
            this.position = n2 + 1;
            n = this.array[n2] & 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] b, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (offset < 0 || offset > b.length || length < 0 || length > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.array.length) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        int copied = this.array.length - this.position < length ? this.array.length - this.position : length;
        ArraysKt.copyInto((byte[])this.array, (byte[])b, (int)offset, (int)this.position, (int)(this.position + copied));
        this.position += copied;
        return copied;
    }
}

