/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.secp256k1;

import fr.acinq.secp256k1.Secp256k1;
import fr.acinq.secp256k1.Secp256k1CFunctions;
import fr.acinq.secp256k1.Secp256k1Context;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0016J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\"2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J \u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0016\u00a8\u0006&"}, d2={"Lfr/acinq/secp256k1/NativeSecp256k1;", "Lfr/acinq/secp256k1/Secp256k1;", "()V", "cleanup", "", "compact2der", "", "sig", "ecdh", "seckey", "pubkey", "ecdsaRecover", "message", "recid", "", "privKeyNegate", "privkey", "privKeyTweakAdd", "tweak", "privKeyTweakMul", "pubKeyAdd", "pubkey1", "pubkey2", "pubKeyNegate", "pubKeyTweakAdd", "pubKeyTweakMul", "pubkeyCreate", "pubkeyParse", "secKeyVerify", "", "sign", "data", "sec", "signatureNormalize", "Lkotlin/Pair;", "verify", "signature", "pub", "jni"})
public final class NativeSecp256k1
implements Secp256k1 {
    @NotNull
    public static final NativeSecp256k1 INSTANCE;

    public boolean verify(@NotNull byte[] signature, @NotNull byte[] data, @NotNull byte[] pub) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        return Secp256k1CFunctions.secp256k1_ecdsa_verify(Secp256k1Context.getContext(), signature, data, pub) == 1;
    }

    @NotNull
    public byte[] sign(@NotNull byte[] data, @NotNull byte[] sec) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)sec, (String)"sec");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ecdsa_sign(Secp256k1Context.getContext(), data, sec);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026.getContext(), data, sec)");
        return byArray;
    }

    @NotNull
    public Pair<byte[], Boolean> signatureNormalize(@NotNull byte[] sig) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        byte[] sigout = new byte[64];
        int result = Secp256k1CFunctions.secp256k1_ecdsa_signature_normalize(Secp256k1Context.getContext(), sig, sigout);
        return new Pair((Object)sigout, (Object)(result == 1 ? 1 : 0));
    }

    public boolean secKeyVerify(@NotNull byte[] seckey) {
        Intrinsics.checkNotNullParameter((Object)seckey, (String)"seckey");
        int result = Secp256k1CFunctions.secp256k1_ec_seckey_verify(Secp256k1Context.getContext(), seckey);
        return result == 1;
    }

    @NotNull
    public byte[] pubkeyCreate(@NotNull byte[] seckey) {
        Intrinsics.checkNotNullParameter((Object)seckey, (String)"seckey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_create(Secp256k1Context.getContext(), seckey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026ext.getContext(), seckey)");
        return byArray;
    }

    @NotNull
    public byte[] pubkeyParse(@NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_parse(Secp256k1Context.getContext(), pubkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026ext.getContext(), pubkey)");
        return byArray;
    }

    public void cleanup() {
        Secp256k1CFunctions.secp256k1_context_destroy(Secp256k1Context.getContext());
    }

    @NotNull
    public byte[] privKeyNegate(@NotNull byte[] privkey) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_privkey_negate(Secp256k1Context.getContext(), privkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026xt.getContext(), privkey)");
        return byArray;
    }

    @NotNull
    public byte[] privKeyTweakMul(@NotNull byte[] privkey, @NotNull byte[] tweak) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_privkey_tweak_mul(Secp256k1Context.getContext(), privkey, tweak);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026ontext(), privkey, tweak)");
        return byArray;
    }

    @NotNull
    public byte[] privKeyTweakAdd(@NotNull byte[] privkey, @NotNull byte[] tweak) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_privkey_tweak_add(Secp256k1Context.getContext(), privkey, tweak);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026ontext(), privkey, tweak)");
        return byArray;
    }

    @NotNull
    public byte[] pubKeyNegate(@NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_negate(Secp256k1Context.getContext(), pubkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026ext.getContext(), pubkey)");
        return byArray;
    }

    @NotNull
    public byte[] pubKeyTweakAdd(@NotNull byte[] pubkey, @NotNull byte[] tweak) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_tweak_add(Secp256k1Context.getContext(), pubkey, tweak);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026Context(), pubkey, tweak)");
        return byArray;
    }

    @NotNull
    public byte[] pubKeyTweakMul(@NotNull byte[] pubkey, @NotNull byte[] tweak) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_tweak_mul(Secp256k1Context.getContext(), pubkey, tweak);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026Context(), pubkey, tweak)");
        return byArray;
    }

    @NotNull
    public byte[] pubKeyAdd(@NotNull byte[] pubkey1, @NotNull byte[] pubkey2) {
        Intrinsics.checkNotNullParameter((Object)pubkey1, (String)"pubkey1");
        Intrinsics.checkNotNullParameter((Object)pubkey2, (String)"pubkey2");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_add(Secp256k1Context.getContext(), pubkey1, pubkey2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026text(), pubkey1, pubkey2)");
        return byArray;
    }

    @NotNull
    public byte[] ecdh(@NotNull byte[] seckey, @NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)seckey, (String)"seckey");
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ecdh(Secp256k1Context.getContext(), seckey, pubkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026ontext(), seckey, pubkey)");
        return byArray;
    }

    @NotNull
    public byte[] ecdsaRecover(@NotNull byte[] sig, @NotNull byte[] message, int recid) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ecdsa_recover(Secp256k1Context.getContext(), sig, message, recid);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026t(), sig, message, recid)");
        return byArray;
    }

    @NotNull
    public byte[] compact2der(@NotNull byte[] sig) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        byte[] byArray = Secp256k1CFunctions.secp256k1_compact_to_der(Secp256k1Context.getContext(), sig);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Secp256k1CFunctions.secp\u2026ontext.getContext(), sig)");
        return byArray;
    }

    private NativeSecp256k1() {
    }

    static {
        NativeSecp256k1 nativeSecp256k1;
        INSTANCE = nativeSecp256k1 = new NativeSecp256k1();
    }

    @NotNull
    public byte[] pubKeyCompress(@NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        return Secp256k1.DefaultImpls.pubKeyCompress((Secp256k1)this, (byte[])pubkey);
    }
}

