/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.secp256k1;

import fr.acinq.secp256k1.Secp256k1;
import fr.acinq.secp256k1.Secp256k1CFunctions;
import fr.acinq.secp256k1.Secp256k1Context;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u001b\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\"\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0$2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J \u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J \u0010'\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0016\u00a8\u0006)"}, d2={"Lfr/acinq/secp256k1/NativeSecp256k1;", "Lfr/acinq/secp256k1/Secp256k1;", "()V", "cleanup", "", "compact2der", "", "sig", "ecdh", "privkey", "pubkey", "ecdsaRecover", "message", "recid", "", "privKeyNegate", "privKeyTweakAdd", "tweak", "privKeyTweakMul", "pubKeyCombine", "pubkeys", "", "([[B)[B", "pubKeyNegate", "pubKeyTweakAdd", "pubKeyTweakMul", "pubkeyCreate", "pubkeyParse", "secKeyVerify", "", "sign", "signSchnorr", "data", "sec", "auxrand32", "signatureNormalize", "Lkotlin/Pair;", "verify", "signature", "verifySchnorr", "pub", "jni"})
public final class NativeSecp256k1
implements Secp256k1 {
    @NotNull
    public static final NativeSecp256k1 INSTANCE = new NativeSecp256k1();

    private NativeSecp256k1() {
    }

    public boolean verify(@NotNull byte[] signature, @NotNull byte[] message, @NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        return Secp256k1CFunctions.secp256k1_ecdsa_verify(Secp256k1Context.getContext(), signature, message, pubkey) == 1;
    }

    @NotNull
    public byte[] sign(@NotNull byte[] message, @NotNull byte[] privkey) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ecdsa_sign(Secp256k1Context.getContext(), message, privkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ecdsa_sign(Sec\u2026text(), message, privkey)");
        return byArray;
    }

    @NotNull
    public Pair<byte[], Boolean> signatureNormalize(@NotNull byte[] sig) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        byte[] sigout = new byte[64];
        int result = Secp256k1CFunctions.secp256k1_ecdsa_signature_normalize(Secp256k1Context.getContext(), sig, sigout);
        return new Pair((Object)sigout, (Object)(result == 1 ? 1 : 0));
    }

    public boolean secKeyVerify(@NotNull byte[] privkey) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        return Secp256k1CFunctions.secp256k1_ec_seckey_verify(Secp256k1Context.getContext(), privkey) == 1;
    }

    @NotNull
    public byte[] pubkeyCreate(@NotNull byte[] privkey) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_create(Secp256k1Context.getContext(), privkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_pubkey_crea\u2026xt.getContext(), privkey)");
        return byArray;
    }

    @NotNull
    public byte[] pubkeyParse(@NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_parse(Secp256k1Context.getContext(), pubkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_pubkey_pars\u2026ext.getContext(), pubkey)");
        return byArray;
    }

    @NotNull
    public byte[] privKeyNegate(@NotNull byte[] privkey) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_privkey_negate(Secp256k1Context.getContext(), privkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_privkey_neg\u2026xt.getContext(), privkey)");
        return byArray;
    }

    @NotNull
    public byte[] privKeyTweakAdd(@NotNull byte[] privkey, @NotNull byte[] tweak) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_privkey_tweak_add(Secp256k1Context.getContext(), privkey, tweak);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_privkey_twe\u2026ontext(), privkey, tweak)");
        return byArray;
    }

    @NotNull
    public byte[] privKeyTweakMul(@NotNull byte[] privkey, @NotNull byte[] tweak) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_privkey_tweak_mul(Secp256k1Context.getContext(), privkey, tweak);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_privkey_twe\u2026ontext(), privkey, tweak)");
        return byArray;
    }

    @NotNull
    public byte[] pubKeyNegate(@NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_negate(Secp256k1Context.getContext(), pubkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_pubkey_nega\u2026ext.getContext(), pubkey)");
        return byArray;
    }

    @NotNull
    public byte[] pubKeyTweakAdd(@NotNull byte[] pubkey, @NotNull byte[] tweak) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_tweak_add(Secp256k1Context.getContext(), pubkey, tweak);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_pubkey_twea\u2026Context(), pubkey, tweak)");
        return byArray;
    }

    @NotNull
    public byte[] pubKeyTweakMul(@NotNull byte[] pubkey, @NotNull byte[] tweak) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        Intrinsics.checkNotNullParameter((Object)tweak, (String)"tweak");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_tweak_mul(Secp256k1Context.getContext(), pubkey, tweak);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_pubkey_twea\u2026Context(), pubkey, tweak)");
        return byArray;
    }

    @NotNull
    public byte[] pubKeyCombine(@NotNull byte[][] pubkeys) {
        Intrinsics.checkNotNullParameter((Object)pubkeys, (String)"pubkeys");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ec_pubkey_combine(Secp256k1Context.getContext(), pubkeys);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ec_pubkey_comb\u2026xt.getContext(), pubkeys)");
        return byArray;
    }

    @NotNull
    public byte[] ecdh(@NotNull byte[] privkey, @NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)privkey, (String)"privkey");
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ecdh(Secp256k1Context.getContext(), privkey, pubkey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ecdh(Secp256k1\u2026ntext(), privkey, pubkey)");
        return byArray;
    }

    @NotNull
    public byte[] ecdsaRecover(@NotNull byte[] sig, @NotNull byte[] message, int recid) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        byte[] byArray = Secp256k1CFunctions.secp256k1_ecdsa_recover(Secp256k1Context.getContext(), sig, message, recid);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_ecdsa_recover(\u2026t(), sig, message, recid)");
        return byArray;
    }

    @NotNull
    public byte[] compact2der(@NotNull byte[] sig) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        byte[] byArray = Secp256k1CFunctions.secp256k1_compact_to_der(Secp256k1Context.getContext(), sig);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_compact_to_der\u2026ontext.getContext(), sig)");
        return byArray;
    }

    public boolean verifySchnorr(@NotNull byte[] signature, @NotNull byte[] data, @NotNull byte[] pub) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        return Secp256k1CFunctions.secp256k1_schnorrsig_verify(Secp256k1Context.getContext(), signature, data, pub) == 1;
    }

    @NotNull
    public byte[] signSchnorr(@NotNull byte[] data, @NotNull byte[] sec, @Nullable byte[] auxrand32) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)sec, (String)"sec");
        byte[] byArray = Secp256k1CFunctions.secp256k1_schnorrsig_sign(Secp256k1Context.getContext(), data, sec, auxrand32);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secp256k1_schnorrsig_sig\u2026(), data, sec, auxrand32)");
        return byArray;
    }

    public void cleanup() {
        Secp256k1CFunctions.secp256k1_context_destroy(Secp256k1Context.getContext());
    }

    @NotNull
    public byte[] pubKeyCompress(@NotNull byte[] pubkey) {
        return Secp256k1.DefaultImpls.pubKeyCompress((Secp256k1)this, (byte[])pubkey);
    }
}

