/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.secp256k1.jni;

import fr.acinq.secp256k1.NativeSecp256k1;
import fr.acinq.secp256k1.Secp256k1;
import fr.acinq.secp256k1.jni.OSInfo;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\u0014\u0010\u0016\u001a\u00020\u0004*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lfr/acinq/secp256k1/jni/NativeSecp256k1JvmLoader;", "", "()V", "extracted", "", "tempDir", "Ljava/io/File;", "getTempDir", "()Ljava/io/File;", "cleanup", "", "extractAndLoadLibraryFile", "libDir", "", "libFileName", "targetDirectory", "load", "Lfr/acinq/secp256k1/Secp256k1;", "loadNativeLibrary", "path", "name", "loadSecp256k1NativeLibrary", "contentsEquals", "Ljava/io/InputStream;", "other", "jvm"})
public final class NativeSecp256k1JvmLoader {
    private static boolean extracted;
    @NotNull
    public static final NativeSecp256k1JvmLoader INSTANCE;

    @JvmStatic
    @NotNull
    public static final synchronized Secp256k1 load() throws Exception {
        if (!extracted) {
            NativeSecp256k1JvmLoader.cleanup();
        }
        INSTANCE.loadSecp256k1NativeLibrary();
        return (Secp256k1)NativeSecp256k1.INSTANCE;
    }

    private final File getTempDir() {
        return new File(System.getProperty("fr.acinq.secp256k1.tmpdir", System.getProperty("java.io.tmpdir")));
    }

    @JvmStatic
    public static final void cleanup() {
        String tempFolder = INSTANCE.getTempDir().getAbsolutePath();
        File dir = new File(tempFolder);
        File[] nativeLibFiles2 = dir.listFiles(new FilenameFilter(){
            private final String searchPattern;

            public boolean accept(@NotNull File dir, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.startsWith$default((String)name, (String)this.searchPattern, (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)".lck", (boolean)false, (int)2, null);
            }
            {
                this.searchPattern = "secp256k1-";
            }
        });
        if (nativeLibFiles2 != null) {
            for (File nativeLibFile : nativeLibFiles2) {
                StringBuilder stringBuilder = new StringBuilder();
                File file = nativeLibFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nativeLibFile");
                File lckFile = new File(stringBuilder.append(file.getAbsolutePath()).append(".lck").toString());
                if (lckFile.exists()) continue;
                try {
                    nativeLibFile.delete();
                }
                catch (SecurityException e) {
                    System.err.println("Failed to delete old native lib" + e.getMessage());
                }
            }
        }
    }

    private final boolean contentsEquals(InputStream $this$contentsEquals, InputStream other) throws IOException {
        int ch2;
        BufferedInputStream bufferedInputStream;
        InputStream inputStream;
        BufferedInputStream bufThis;
        BufferedInputStream bufferedInputStream2;
        InputStream inputStream2 = $this$contentsEquals;
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = null;
        }
        if ((bufferedInputStream2 = (BufferedInputStream)inputStream2) == null) {
            bufferedInputStream2 = bufThis = new BufferedInputStream($this$contentsEquals);
        }
        if (!((inputStream = other) instanceof BufferedInputStream)) {
            inputStream = null;
        }
        if ((bufferedInputStream = (BufferedInputStream)inputStream) == null) {
            bufferedInputStream = new BufferedInputStream(other);
        }
        BufferedInputStream bufOther = bufferedInputStream;
        int ch = bufThis.read();
        while (ch != -1) {
            ch2 = bufOther.read();
            if (ch != ch2) {
                return false;
            }
            ch = bufThis.read();
        }
        ch2 = bufOther.read();
        return ch2 == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean extractAndLoadLibraryFile(String libDir, String libFileName, String targetDirectory) {
        String libPath = libDir + '/' + libFileName;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        String uuid = string;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "secp256k1-%s-%s";
        Object[] objectArray = new Object[]{uuid, libFileName};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        String extractedLibFileName = string3;
        String extractedLckFileName = extractedLibFileName + ".lck";
        File extractedLibFile = new File(targetDirectory, extractedLibFileName);
        File extractedLckFile = new File(targetDirectory, extractedLckFileName);
        try {
            InputStream reader = NativeSecp256k1JvmLoader.class.getResourceAsStream(libPath);
            if (!extractedLckFile.exists()) {
                new FileOutputStream(extractedLckFile).close();
            }
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            try {
                byte[] buffer = new byte[8192];
                int bytesRead = reader.read(buffer);
                while (bytesRead != -1) {
                    writer.write(buffer, 0, bytesRead);
                    bytesRead = reader.read(buffer);
                }
            }
            finally {
                extractedLibFile.deleteOnExit();
                extractedLckFile.deleteOnExit();
                writer.close();
                reader.close();
            }
            extractedLibFile.setReadable(true);
            extractedLibFile.setWritable(true, true);
            extractedLibFile.setExecutable(true);
            Closeable closeable = NativeSecp256k1JvmLoader.class.getResourceAsStream(libPath);
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                InputStream nativeIn = (InputStream)closeable;
                boolean bl4 = false;
                Closeable closeable2 = new FileInputStream(extractedLibFile);
                boolean bl5 = false;
                boolean bl6 = false;
                Throwable throwable2 = null;
                try {
                    FileInputStream extractedLibIn = (FileInputStream)closeable2;
                    boolean bl7 = false;
                    InputStream inputStream = nativeIn;
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"nativeIn");
                    if (!INSTANCE.contentsEquals(inputStream, extractedLibIn)) {
                        StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
                        String string4 = "Failed to write a native library file at %s";
                        Object[] objectArray2 = new Object[]{extractedLibFile};
                        boolean bl8 = false;
                        String string5 = String.format(string4, Arrays.copyOf(objectArray2, objectArray2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                        throw (Throwable)new RuntimeException(string5);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = this.loadNativeLibrary(targetDirectory, extractedLibFileName);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            bl = false;
        }
        return bl;
    }

    private final boolean loadNativeLibrary(String path, String name) {
        boolean bl;
        File libPath = new File(path, name);
        if (libPath.exists()) {
            boolean bl2;
            try {
                System.load(new File(path, name).getAbsolutePath());
                bl2 = true;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Failed to load native library:" + name + ". osinfo: " + OSInfo.getNativeSuffix());
                System.err.println(e);
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void loadSecp256k1NativeLibrary() {
        boolean hasNativeLib;
        String libraryName;
        if (extracted) {
            return;
        }
        String libraryPath = System.getProperty("fr.acinq.secp256k1.lib.path");
        String string = System.getProperty("fr.acinq.secp256k1.lib.name");
        if (string == null) {
            string = libraryName = System.mapLibraryName("secp256k1-jni");
        }
        if (libraryPath != null) {
            String string2 = libraryName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"libraryName");
            if (this.loadNativeLibrary(libraryPath, string2)) {
                extracted = true;
                return;
            }
        }
        Package package_ = NativeSecp256k1JvmLoader.class.getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"NativeSecp256k1JvmLoader::class.java.getPackage()");
        String string3 = package_.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"NativeSecp256k1JvmLoader\u2026ss.java.getPackage().name");
        CharSequence charSequence = string3;
        String string4 = "\\.";
        boolean bl = false;
        string4 = new Regex(string4);
        String string5 = "/";
        boolean bl2 = false;
        String packagePath = string4.replace(charSequence, string5);
        String embeddedLibraryPath = '/' + packagePath + "/native/" + OSInfo.getNativeSuffix();
        boolean bl3 = hasNativeLib = NativeSecp256k1JvmLoader.class.getResource(embeddedLibraryPath + '/' + libraryName) != null;
        if (!hasNativeLib) {
            string5 = "No native library found: at " + embeddedLibraryPath + '/' + libraryName;
            bl2 = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        String string6 = libraryName;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"libraryName");
        String string7 = this.getTempDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"tempDir.absolutePath");
        if (this.extractAndLoadLibraryFile(embeddedLibraryPath, string6, string7)) {
            extracted = true;
            return;
        }
        extracted = false;
    }

    private NativeSecp256k1JvmLoader() {
    }

    static {
        NativeSecp256k1JvmLoader nativeSecp256k1JvmLoader;
        INSTANCE = nativeSecp256k1JvmLoader = new NativeSecp256k1JvmLoader();
    }
}

