/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.secp256k1.jni;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0003J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\rR\u001a\u0010\u0013\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\r\u00a8\u0006\u001e"}, d2={"Lfr/acinq/secp256k1/jni/OSInfo;", "", "()V", "IA64", "", "IA64_32", "PPC", "PPC64", "X86", "X86_64", "arch", "getArch$annotations", "getArch", "()Ljava/lang/String;", "archMapping", "Ljava/util/HashMap;", "hardwareName", "getHardwareName$annotations", "getHardwareName", "nativeSuffix", "getNativeSuffix$annotations", "getNativeSuffix", "os", "getOs$annotations", "getOs", "resolveArmArchType", "translateArchNameToFolderName", "archName", "translateOSName", "osName", "jvm"})
public final class OSInfo {
    private static final HashMap<String, String> archMapping;
    private static final String X86 = "x86";
    private static final String X86_64 = "x86_64";
    private static final String IA64_32 = "ia64_32";
    private static final String IA64 = "ia64";
    private static final String PPC = "ppc";
    private static final String PPC64 = "ppc64";
    @NotNull
    public static final OSInfo INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getNativeSuffix$annotations() {
    }

    @NotNull
    public static final String getNativeSuffix() {
        return OSInfo.getOs() + '-' + OSInfo.getArch();
    }

    @JvmStatic
    public static /* synthetic */ void getOs$annotations() {
    }

    @NotNull
    public static final String getOs() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"os.name\")");
        return OSInfo.translateOSName(string);
    }

    @JvmStatic
    public static /* synthetic */ void getHardwareName$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String getHardwareName() {
        String string;
        try {
            String string2;
            Process p = Runtime.getRuntime().exec("uname -m");
            p.waitFor();
            Process process = p;
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"p");
            InputStream input = process.getInputStream();
            Closeable closeable = input;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                byte[] buf = new byte[32];
                int readLen = it.read(buf, 0, buf.length);
                while (readLen >= 0) {
                    b.write(buf, 0, readLen);
                    readLen = it.read(buf, 0, buf.length);
                }
                String string3 = b.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"b.toString()");
                string2 = string3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            string = string2;
        }
        catch (Throwable e) {
            System.err.println("Error while running uname -m: " + e.getMessage());
            string = "unknown";
        }
        return string;
    }

    @JvmStatic
    private static final String resolveArmArchType() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"os.name\")");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Linux", (boolean)false, (int)2, null)) {
            String[] cmdarray;
            String armType = OSInfo.getHardwareName();
            if (StringsKt.startsWith$default((String)armType, (String)"armv6", (boolean)false, (int)2, null)) {
                return "armv6";
            }
            if (StringsKt.startsWith$default((String)armType, (String)"armv7", (boolean)false, (int)2, null)) {
                return "armv7";
            }
            if (StringsKt.startsWith$default((String)armType, (String)"armv5", (boolean)false, (int)2, null)) {
                return "arm";
            }
            if (Intrinsics.areEqual((Object)armType, (Object)"aarch64")) {
                return "arm64";
            }
            String abi = System.getProperty("sun.arch.abi");
            if (abi != null && StringsKt.startsWith$default((String)abi, (String)"gnueabihf", (boolean)false, (int)2, null)) {
                return "armv7";
            }
            String javaHome = System.getProperty("java.home");
            try {
                int exitCode = Runtime.getRuntime().exec("which readelf").waitFor();
                if (exitCode == 0) {
                    cmdarray = new String[]{"/bin/sh", "-c", "find '" + javaHome + "' -name 'libjvm.so' | head -1 | xargs readelf -A | " + "grep 'Tag_ABI_VFP_args: VFP registers'"};
                    exitCode = Runtime.getRuntime().exec(cmdarray).waitFor();
                    if (exitCode == 0) {
                        return "armv7";
                    }
                } else {
                    System.err.println("WARNING! readelf not found. Cannot check if running on an armhf system, armel architecture will be presumed.");
                }
            }
            catch (IOException exitCode) {
            }
            catch (InterruptedException exitCode) {
                // empty catch block
            }
            if ((abi = System.getProperty("sun.arch.abi")) != null && StringsKt.startsWith$default((String)abi, (String)"gnueabihf", (boolean)false, (int)2, null)) {
                return "armv7";
            }
            javaHome = System.getProperty("java.home");
            try {
                int exitCode = Runtime.getRuntime().exec("which readelf").waitFor();
                if (exitCode == 0) {
                    cmdarray = new String[]{"/bin/sh", "-c", "find '" + javaHome + "' -name 'libjvm.so' | head -1 | xargs readelf -A | " + "grep 'Tag_ABI_VFP_args: VFP registers'"};
                    exitCode = Runtime.getRuntime().exec(cmdarray).waitFor();
                    if (exitCode == 0) {
                        return "armv7";
                    }
                } else {
                    System.err.println("WARNING! readelf not found. Cannot check if running on an armhf system, armel architecture will be presumed.");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "arm";
    }

    @JvmStatic
    public static /* synthetic */ void getArch$annotations() {
    }

    @Nullable
    public static final String getArch() {
        String osArch;
        String string;
        String systemOsArch;
        String string2 = systemOsArch = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"systemOsArch");
        if (StringsKt.startsWith$default((String)string2, (String)"arm", (boolean)false, (int)2, null)) {
            string = OSInfo.resolveArmArchType();
        } else {
            String string3 = systemOsArch;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string4 = string3;
            boolean bl2 = false;
            String string5 = string4.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            String lc = string5;
            if (archMapping.containsKey(lc)) {
                return archMapping.get(lc);
            }
            string = systemOsArch;
        }
        String string6 = osArch = string;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"osArch");
        return OSInfo.translateArchNameToFolderName(string6);
    }

    @JvmStatic
    @NotNull
    public static final String translateOSName(@NotNull String osName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)osName, (String)"osName");
        if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Windows", (boolean)false, (int)2, null)) {
            string = "mingw";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Mac", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"Darwin", (boolean)false, (int)2, null)) {
            string = "darwin";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Linux", (boolean)false, (int)2, null)) {
            string = "linux";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"AIX", (boolean)false, (int)2, null)) {
            string = "aix";
        } else {
            CharSequence charSequence = osName;
            String string2 = "\\W";
            boolean bl = false;
            string2 = new Regex(string2);
            String string3 = "";
            boolean bl2 = false;
            string = string2.replace(charSequence, string3);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String translateArchNameToFolderName(@NotNull String archName) {
        Intrinsics.checkNotNullParameter((Object)archName, (String)"archName");
        CharSequence charSequence = archName;
        String string = "\\W";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        boolean bl2 = false;
        return string.replace(charSequence, string2);
    }

    private OSInfo() {
    }

    static {
        OSInfo oSInfo;
        INSTANCE = oSInfo = new OSInfo();
        archMapping = new HashMap();
        ((Map)archMapping).put(X86, X86);
        ((Map)archMapping).put("i386", X86);
        ((Map)archMapping).put("i486", X86);
        ((Map)archMapping).put("i586", X86);
        ((Map)archMapping).put("i686", X86);
        ((Map)archMapping).put("pentium", X86);
        ((Map)archMapping).put(X86_64, X86_64);
        ((Map)archMapping).put("amd64", X86_64);
        ((Map)archMapping).put("em64t", X86_64);
        ((Map)archMapping).put("universal", X86_64);
        ((Map)archMapping).put(IA64, IA64);
        ((Map)archMapping).put("ia64w", IA64);
        ((Map)archMapping).put(IA64_32, IA64_32);
        ((Map)archMapping).put("ia64n", IA64_32);
        ((Map)archMapping).put(PPC, PPC);
        ((Map)archMapping).put("power", PPC);
        ((Map)archMapping).put("powerpc", PPC);
        ((Map)archMapping).put("power_pc", PPC);
        ((Map)archMapping).put("power_rs", PPC);
        ((Map)archMapping).put(PPC64, PPC64);
        ((Map)archMapping).put("power64", PPC64);
        ((Map)archMapping).put("powerpc64", PPC64);
        ((Map)archMapping).put("power_pc64", PPC64);
        ((Map)archMapping).put("power_rs64", PPC64);
    }
}

