/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.encoding;

import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.PolyLength;
import org.checkerframework.checker.index.qual.PolySameLen;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.PolyValue;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Base64 {
    private static final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown char @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown [] CHARSET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};

    private Base64() {
    }

    @Pure
    public static @IntRange(from=0L, to=63L) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int ord(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        switch (c) {
            case '-': {
                return 62;
            }
            case '_': {
                return 63;
            }
        }
        throw new IllegalArgumentException("Invalid char value");
    }

    @Pure
    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown char chr(@IntRange(from=0L, to=63L) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int value) {
        return CHARSET[value];
    }

    @Pure
    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown char chrMod(@NonNegative @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown int value) {
        return CHARSET[value % CHARSET.length];
    }

    @SideEffectFree
    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encode(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int value, @IntRange(from=1L, to=6L) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int length) {
        if (length < 1 || length > 6) {
            throw new IllegalArgumentException("Invalid length parameter : it must be in range [1-6]");
        }
        char[] encoded = new char[length];
        for (int i = length - 1; i >= 0; --i) {
            encoded[i] = CHARSET[value & 0x3F];
            value >>= 6;
        }
        return new String(encoded);
    }

    @SideEffectFree
    public static @PolyLength @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @PolyValue @SearchIndexUnknown @PolySameLen @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encode(@IntRange(from=0L, to=63L) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown byte @PolyLength @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @PolyValue @SearchIndexUnknown @PolySameLen @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown [] data) {
        char[] encoded = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            encoded[i] = Base64.chr(data[i]);
        }
        return new String(encoded);
    }

    @Pure
    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int decode(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encoded) {
        if (encoded.length() > 6) {
            throw new IllegalArgumentException("Invalid encoded string : too long");
        }
        int value = 0;
        for (int i = 0; i < encoded.length(); ++i) {
            value <<= 6;
            value += Base64.ord(encoded.charAt(i));
        }
        return value;
    }

    @SideEffectFree
    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown byte @PolyLength @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @PolyValue @SearchIndexUnknown @PolySameLen @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown [] toBytes(@PolyLength @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @PolyValue @SearchIndexUnknown @PolySameLen @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encoded) {
        byte[] decoded = new byte[encoded.length()];
        for (int i = 0; i < encoded.length(); ++i) {
            decoded[i] = (byte)Base64.ord(encoded.charAt(i));
        }
        return decoded;
    }
}

