/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.encoding;

import fr.arakne.utils.encoding.XorCipher;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Key {
    private static @MonotonicNonNull @UnknownKeyFor @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown SecureRandom random;
    private final @MinLen(value=1) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key;
    private @MonotonicNonNull @UnknownKeyFor @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown XorCipher cipher;

    public Key(@MinLen(value=1) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key) {
        this.key = key;
    }

    @Pure
    @SideEffectFree
    public @MinLen(value=1) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String toString() {
        return this.key;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown XorCipher cipher() {
        if (this.cipher == null) {
            this.cipher = new XorCipher(this.key);
        }
        return this.cipher;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encode() {
        String raw;
        try {
            raw = URLEncoder.encode(this.key, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Invalid UTF-8 key", e);
        }
        StringBuilder encrypted = new StringBuilder(raw.length() * 2);
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (c < '\u0010') {
                encrypted.append('0');
            }
            encrypted.append(Integer.toHexString(c));
        }
        return encrypted.toString();
    }

    @Pure
    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Key parse(@MinLen(value=2) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @ArrayLenRange(from=2, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String input) {
        if (input.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        char[] keyArr = new char[input.length() / 2];
        for (int i = 0; i < input.length() - 1; i += 2) {
            keyArr[i / 2] = (char)Integer.parseInt(input.substring(i, i + 2), 16);
        }
        try {
            return new Key(URLDecoder.decode(new String(keyArr), StandardCharsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid UTF-8 character");
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Key generate() {
        return Key.generate(128);
    }

    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Key generate(@Positive @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown int size) {
        if (random == null) {
            random = new SecureRandom();
        }
        return Key.generate(size, random);
    }

    public static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Key generate(@Positive @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown int size, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown SecureRandom random) {
        char[] keyArr = new char[size];
        for (int i = 0; i < size; ++i) {
            keyArr[i] = (char)(random.nextInt(94) + 33);
        }
        return new Key(new String(keyArr));
    }
}

