/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.encoding;

import fr.arakne.utils.encoding.Base64;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class PasswordEncoder {
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key;

    public PasswordEncoder(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key) {
        this.key = key;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key() {
        return this.key;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String decode(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encoded) {
        if (encoded.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid encoded string");
        }
        if (this.key.length() * 2 < encoded.length()) {
            throw new IllegalArgumentException("Encoded string is too long for the key");
        }
        char[] decoded = new char[encoded.length() / 2];
        for (int i = 0; i < encoded.length() - 1; i += 2) {
            int p = i / 2;
            int k = this.key.charAt(p) % 64;
            int d = Base64.ord(encoded.charAt(i));
            int r = Base64.ord(encoded.charAt(i + 1));
            d -= k;
            r -= k;
            while (d < 0) {
                d += 64;
            }
            while (r < 0) {
                r += 64;
            }
            int v = d * 16 + r;
            decoded[p] = (char)v;
        }
        return new String(decoded);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encode(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String password) {
        if (this.key.length() < password.length()) {
            throw new IllegalArgumentException("The password is too long for the key");
        }
        char[] encoded = new char[password.length() * 2];
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            char k = this.key.charAt(i);
            int d = c / 16;
            int r = c % 16;
            encoded[i * 2] = Base64.chrMod(d + k);
            encoded[i * 2 + 1] = Base64.chrMod(r + k);
        }
        return new String(encoded);
    }
}

