/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class XorCipher {
    private final @MinLen(value=1) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key;

    public XorCipher(@MinLen(value=1) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key) {
        this.key = key;
    }

    @Pure
    public @MinLen(value=1) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key() {
        return this.key;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encrypt(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String value, @NonNegative @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown int keyOffset) {
        String plain = XorCipher.escape(value);
        StringBuilder encrypted = new StringBuilder(plain.length() * 2);
        for (int i = 0; i < plain.length(); ++i) {
            char k;
            char c = plain.charAt(i);
            char e = (char)(c ^ (k = this.key.charAt((i + keyOffset) % this.key.length())));
            if (e < '\u0010') {
                encrypted.append('0');
            }
            encrypted.append(Integer.toHexString(e));
        }
        return encrypted.toString().toUpperCase();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String decrypt(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String value, @NonNegative @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown int keyOffset) {
        if (value.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid encrypted value");
        }
        char[] decrypted = new char[value.length() / 2];
        for (int i = 0; i < value.length() - 1; i += 2) {
            char k = this.key.charAt((i / 2 + keyOffset) % this.key.length());
            char c = (char)Integer.parseInt(value.substring(i, i + 2), 16);
            decrypted[i / 2] = (char)(c ^ k);
        }
        try {
            return URLDecoder.decode(new String(decrypted), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid UTF-8 character", e);
        }
    }

    @SideEffectFree
    private static @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String escape(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String value) {
        StringBuilder escaped = new StringBuilder(value.length());
        try {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c < ' ' || c > '\u007f' || c == '%' || c == '+') {
                    escaped.append(URLEncoder.encode(String.valueOf(c), StandardCharsets.UTF_8.toString()));
                    continue;
                }
                escaped.append(c);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid UTF-8 character", e);
        }
        return escaped.toString();
    }
}

