/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.maps;

import fr.arakne.utils.maps.MapCell;
import fr.arakne.utils.maps.constant.Direction;
import java.util.Objects;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;

public final class CoordinateCell<@UnknownKeyFor C extends @NonNull @UnknownKeyFor @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown MapCell> {
    private final C cell;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int x;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int y;

    public CoordinateCell(C cell) {
        this.cell = cell;
        int width = cell.map().dimensions().width();
        int line = cell.id() / (width * 2 - 1);
        int column = cell.id() - line * (width * 2 - 1);
        int offset = column % width;
        this.y = line - offset;
        this.x = (cell.id() - (width - 1) * this.y) / width;
    }

    @Pure
    public C cell() {
        return this.cell;
    }

    @Pure
    public @NonNegative @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown int id() {
        return this.cell.id();
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int x() {
        return this.x;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int y() {
        return this.y;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean is(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int x, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int y) {
        return this.x == x && this.y == y;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Direction directionTo(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> target) {
        if (this.x == target.x) {
            if (target.y > this.y) {
                return Direction.SOUTH_WEST;
            }
            return Direction.NORTH_EAST;
        }
        if (target.x > this.x) {
            return Direction.SOUTH_EAST;
        }
        return Direction.NORTH_WEST;
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Direction directionTo(C target) {
        return this.directionTo((C)target.coordinate());
    }

    @Pure
    public @NonNegative @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown int distance(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> target) {
        return Math.abs(this.x - target.x) + Math.abs(this.y - target.y);
    }

    public @NonNegative @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown int distance(C target) {
        return this.distance((C)target.coordinate());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean equals(@Nullable @UnknownKeyFor @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateCell that = (CoordinateCell)o;
        return this.x == that.x && this.y == that.y;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

