/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.maps.path;

import fr.arakne.utils.encoding.Base64;
import fr.arakne.utils.maps.DofusMap;
import fr.arakne.utils.maps.MapCell;
import fr.arakne.utils.maps.constant.Direction;
import fr.arakne.utils.maps.path.Path;
import fr.arakne.utils.maps.path.PathException;
import fr.arakne.utils.maps.path.PathStep;
import fr.arakne.utils.maps.path.Pathfinder;
import java.util.Optional;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Decoder<@UnknownKeyFor C extends @NonNull @UnknownKeyFor @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown MapCell> {
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown DofusMap<C> map;

    public Decoder(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown DofusMap<C> map) {
        this.map = map;
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Optional<C> nextCellByDirection(C start, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Direction direction) {
        int nextId = start.id() + direction.nextCellIncrement(this.map.dimensions().width());
        if (nextId >= this.map.size() || nextId < 0) {
            return Optional.empty();
        }
        return Optional.of(this.map.get(nextId));
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Path<C> decode(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encoded, @Nullable C start) throws @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown PathException {
        if (encoded.length() % 3 != 0) {
            throw new PathException("Invalid path : bad length");
        }
        Path<C> path = new Path<C>(this);
        if (start != null) {
            path.add(new PathStep<C>(start, Direction.EAST));
        }
        for (int i = 0; i < encoded.length() - 2; i += 3) {
            char directionChar = encoded.charAt(i);
            if (directionChar < 'a' || directionChar > 'h') {
                throw new PathException("Invalid direction");
            }
            Direction direction = Direction.byChar(directionChar);
            int cell = ((Base64.ord((char)encoded.charAt(i + 1)) & 0xF) << 6) + Base64.ord((char)encoded.charAt(i + 2));
            if (cell >= this.map.size()) {
                throw new PathException("Invalid cell number");
            }
            if (path.isEmpty()) {
                path.add(new PathStep<C>(this.map.get(cell), Direction.EAST));
                continue;
            }
            this.expandRectilinearMove(path, path.target(), this.map.get(cell), direction);
        }
        return path;
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Path<C> decode(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encoded) throws @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown PathException {
        return this.decode(encoded, null);
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encodeWithStartCell(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Path<C> path) {
        return this.encode(path, true);
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encode(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Path<C> path) {
        return this.encode(path, false);
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Pathfinder<C> pathfinder() {
        return new Pathfinder(this);
    }

    private void expandRectilinearMove(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Path<C> path, C start, C target, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Direction direction) throws @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown PathException {
        int stepsLimit = 2 * this.map.dimensions().width() + 1;
        while (!start.equals(target)) {
            start = (MapCell)this.nextCellByDirection(start, direction).orElseThrow(() -> new PathException("Invalid cell number"));
            path.add(new PathStep<C>(start, direction));
            if (--stepsLimit >= 0) continue;
            throw new PathException("Invalid path : bad direction");
        }
    }

    @SideEffectFree
    private @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String encode(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Path<C> path, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean includeStartCell) {
        int i;
        StringBuilder encoded = new StringBuilder(path.size() * 3);
        if (includeStartCell) {
            encoded.append(Direction.EAST.toChar()).append(Base64.encode((int)path.get(0).cell().id(), (int)2));
        }
        int n = i = includeStartCell ? 1 : 0;
        while (i < path.size()) {
            PathStep<C> step = path.get(i);
            encoded.append(step.direction().toChar());
            while (i + 1 < path.size() && path.get(i + 1).direction() == step.direction()) {
                ++i;
            }
            encoded.append(Base64.encode((int)path.get(i).cell().id(), (int)2));
            ++i;
        }
        return encoded.toString();
    }
}

