/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.maps.serializer;

import fr.arakne.utils.encoding.Base64;
import fr.arakne.utils.encoding.Key;
import fr.arakne.utils.maps.constant.CellMovement;
import fr.arakne.utils.maps.serializer.CellData;
import fr.arakne.utils.maps.serializer.CellLayerData;
import fr.arakne.utils.maps.serializer.EncryptedMapDataSerializer;
import fr.arakne.utils.maps.serializer.GroundCellData;
import fr.arakne.utils.maps.serializer.InteractiveObjectData;
import fr.arakne.utils.maps.serializer.MapDataSerializer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;

public final class DefaultMapDataSerializer
implements MapDataSerializer {
    private static final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int CELL_DATA_LENGTH = 10;
    private @Nullable @UnknownKeyFor @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Map<@ArrayLen(value={10}) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown ByteArrayCell> cache;

    @Override
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CellData @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown [] deserialize(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String mapData) {
        if (mapData.length() % 10 != 0) {
            throw new IllegalArgumentException("Invalid map data");
        }
        int size = mapData.length() / 10;
        CellData[] cells = new CellData[size];
        for (int i = 0; i < size; ++i) {
            int startIndex = i * 10;
            cells[i] = this.deserializeCell(mapData.substring(startIndex, startIndex + 10));
        }
        return cells;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String serialize(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CellData @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown [] cells) {
        StringBuilder sb = new StringBuilder(cells.length * 10);
        for (CellData cell : cells) {
            sb.append(this.serializeCell(cell));
        }
        return sb.toString();
    }

    public void enableCache() {
        this.cache = new ConcurrentHashMap<String, ByteArrayCell>();
    }

    public void disableCache() {
        this.cache = null;
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown MapDataSerializer withKey(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Key key) {
        return new EncryptedMapDataSerializer(key, this);
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown MapDataSerializer withKey(@MinLen(value=2) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @ArrayLenRange(from=2, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String key) {
        return this.withKey(Key.parse((String)key));
    }

    private @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CellData deserializeCell(@ArrayLen(value={10}) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String cellData) {
        if (this.cache == null) {
            return new ByteArrayCell(Base64.toBytes((String)cellData));
        }
        return this.cache.computeIfAbsent(cellData, data -> new ByteArrayCell(Base64.toBytes((String)data)));
    }

    private @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String serializeCell(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CellData cell) {
        @IntRange(from=0L, to=63L) byte[] data = new byte[10];
        data[0] = (byte)((cell.active() ? 1 : 0) << 5);
        data[0] = (byte)(data[0] | (cell.lineOfSight() ? (byte)1 : 0));
        data[0] = (byte)(data[0] | (cell.ground().number() & 0x600) >> 6);
        data[0] = (byte)(data[0] | (cell.layer1().number() & 0x2000) >> 11);
        data[0] = (byte)(data[0] | (cell.layer2().number() & 0x2000) >> 12);
        data[1] = (byte)((cell.ground().rotation() & 3) << 4);
        data[1] = (byte)(data[1] | cell.ground().level() & 0xF);
        data[2] = (byte)((cell.movement().ordinal() & 7) << 3);
        data[2] = (byte)(data[2] | cell.ground().number() >> 6 & 7);
        data[3] = (byte)(cell.ground().number() & 0x3F);
        data[4] = (byte)((cell.ground().slope() & 0xF) << 2);
        data[4] = (byte)(data[4] | (cell.ground().flip() ? 1 : 0) << 1);
        data[4] = (byte)(data[4] | cell.layer1().number() >> 12 & 1);
        data[5] = (byte)(cell.layer1().number() >> 6 & 0x3F);
        data[6] = (byte)(cell.layer1().number() & 0x3F);
        data[7] = (byte)((cell.layer1().rotation() & 3) << 4);
        data[7] = (byte)(data[7] | (cell.layer1().flip() ? 1 : 0) << 3);
        data[7] = (byte)(data[7] | (cell.layer2().flip() ? 1 : 0) << 2);
        data[7] = (byte)(data[7] | (cell.layer2().interactive() ? 1 : 0) << 1);
        data[7] = (byte)(data[7] | cell.layer2().number() >> 12 & 1);
        data[8] = (byte)(cell.layer2().number() >> 6 & 0x3F);
        data[9] = (byte)(cell.layer2().number() & 0x3F);
        return Base64.encode((byte[])data);
    }

    private static class ByteArrayCell
    implements CellData {
        private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown byte @ArrayLen(value={10}) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown [] data;

        public ByteArrayCell(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown byte @ArrayLen(value={10}) @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown [] data) {
            this.data = data;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean lineOfSight() {
            return (this.data[0] & 1) == 1;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CellMovement movement() {
            return CellMovement.byValue((this.data[2] & 0x38) >> 3);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean active() {
            return (this.data[0] & 0x20) >> 5 == 1;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown GroundCellData ground() {
            return new GroundCellData(){

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int level() {
                    return data[1] & 0xF;
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int slope() {
                    return (data[4] & 0x3C) >> 2;
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int number() {
                    return ((data[0] & 0x18) << 6) + ((data[2] & 7) << 6) + data[3];
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int rotation() {
                    return (data[1] & 0x30) >> 4;
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean flip() {
                    return (data[4] & 2) >> 1 == 1;
                }
            };
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CellLayerData layer1() {
            return new CellLayerData(){

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int number() {
                    return ((data[0] & 4) << 11) + ((data[4] & 1) << 12) + (data[5] << 6) + data[6];
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int rotation() {
                    return (data[7] & 0x30) >> 4;
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean flip() {
                    return (data[7] & 8) >> 3 == 1;
                }
            };
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown InteractiveObjectData layer2() {
            return new InteractiveObjectData(){

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean interactive() {
                    return (data[7] & 2) >> 1 == 1;
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int number() {
                    return ((data[0] & 2) << 12) + ((data[7] & 1) << 12) + (data[8] << 6) + data[9];
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean flip() {
                    return (data[7] & 4) >> 2 == 1;
                }
            };
        }
    }
}

