/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.maps.sight;

import fr.arakne.utils.maps.BattlefieldCell;
import fr.arakne.utils.maps.CoordinateCell;
import fr.arakne.utils.maps.DofusMap;
import fr.arakne.utils.maps.sight.BattlefieldSight;
import fr.arakne.utils.maps.sight.NotAlignedLineOfSightIterator;
import fr.arakne.utils.maps.sight.SameXLineOfSightIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.UnknownVal;

public final class CellSight<@UnknownKeyFor C extends @NonNull @UnknownKeyFor @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown BattlefieldCell> {
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown BattlefieldSight<C> battlefield;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> source;

    public CellSight(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown BattlefieldSight<C> battlefield, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> source) {
        this.battlefield = battlefield;
        this.source = source;
    }

    public CellSight(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> source) {
        this(new BattlefieldSight(((BattlefieldCell)source.cell()).map()), source);
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean isFree(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> target) {
        if (this.source.equals(target)) {
            return true;
        }
        Iterator<C> sight = this.to(target);
        while (sight.hasNext()) {
            BattlefieldCell cell = (BattlefieldCell)sight.next();
            if (!cell.sightBlocking() || cell.equals(target.cell())) continue;
            return false;
        }
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean isFree(C target) {
        return this.isFree((C)target.coordinate());
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Iterator<C> to(C target) {
        return this.to(target.coordinate());
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Iterator<C> to(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> target) {
        if (this.source.equals(target)) {
            return Collections.emptyIterator();
        }
        return this.source.x() == target.x() ? new SameXLineOfSightIterator<C>(this.battlefield, this.source, target) : new NotAlignedLineOfSightIterator<C>(this.battlefield, this.source, target);
    }

    public void forEach(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown BiConsumer<C, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Boolean> cellViewConsumer) {
        DofusMap map = ((BattlefieldCell)this.source.cell()).map();
        int size = map.size();
        for (int id = 0; id < size; ++id) {
            BattlefieldCell target = (BattlefieldCell)map.get(id);
            cellViewConsumer.accept(target, this.isFree(target));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Collection<C> accessible() {
        ArrayList cells = new ArrayList();
        this.forEach((cell, free) -> {
            if (free.booleanValue()) {
                cells.add(cell);
            }
        });
        return cells;
    }

    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Collection<C> blocked() {
        ArrayList cells = new ArrayList();
        this.forEach((cell, free) -> {
            if (!free.booleanValue()) {
                cells.add(cell);
            }
        });
        return cells;
    }
}

