/*
 * Decompiled with CFR 0.152.
 */
package fr.arakne.utils.maps.sight;

import fr.arakne.utils.maps.BattlefieldCell;
import fr.arakne.utils.maps.CoordinateCell;
import fr.arakne.utils.maps.sight.BattlefieldSight;
import java.util.Iterator;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;

final class NotAlignedLineOfSightIterator<@UnknownKeyFor C extends @NonNull @UnknownKeyFor @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown BattlefieldCell>
implements Iterator<C> {
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown BattlefieldSight<C> battlefield;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> source;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> target;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int xDirection;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int yDirection;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown double ySlope;
    private final @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown double yAtZero;
    private @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int currentX;
    private @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int currentY;
    private @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int lastY;
    private @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int nextY;

    public NotAlignedLineOfSightIterator(@UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown BattlefieldSight<C> battlefield, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> source, @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown CoordinateCell<C> target) {
        this.battlefield = battlefield;
        this.source = source;
        this.target = target;
        this.xDirection = source.x() > target.x() ? -1 : 1;
        this.yDirection = source.y() > target.y() ? -1 : 1;
        this.ySlope = (double)(target.y() - source.y()) / (double)(target.x() - source.x());
        this.yAtZero = (double)source.y() - this.ySlope * (double)source.x();
        this.init();
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean hasNext() {
        return !this.target.is(this.currentX, this.currentY);
    }

    @Override
    public C next() {
        this.currentY += this.yDirection;
        if (this.currentY * this.yDirection > this.lastY * this.yDirection) {
            this.currentX += this.xDirection;
            this.currentY = this.nextY;
            this.computeNextY();
        }
        return this.getCurrentCell();
    }

    private void init() {
        this.currentX = this.source.x();
        this.currentY = this.source.y();
        this.computeNextY();
    }

    private void computeNextY() {
        double yAtCurrentX = ((double)this.currentX + (double)this.xDirection * 0.5) * this.ySlope + this.yAtZero;
        if (this.yDirection > 0) {
            this.nextY = (int)Math.round(yAtCurrentX);
            this.lastY = (int)Math.ceil(yAtCurrentX - 0.5);
        } else {
            this.nextY = (int)Math.ceil(yAtCurrentX - 0.5);
            this.lastY = (int)Math.round(yAtCurrentX);
        }
    }

    private C getCurrentCell() {
        return this.battlefield.getCellByCoordinates(this.currentX, this.currentY);
    }
}

