/*
 * Decompiled with CFR 0.152.
 */
package fr.avianey.androidsvgdrawable.gradle;

import fr.avianey.androidsvgdrawable.gradle.SvgDrawableTask;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class SvgDrawableGradlePlugin
implements Plugin<Project> {
    private static final String ANDROID_PLUGIN_CLASS_REGEXP = "com\\.android\\.build\\.gradle\\.(?:AtomPlugin|FeaturePlugin|InstantAppPlugin|AppPlugin|LibraryPlugin)";

    public void apply(Project project) {
        Plugin androidPlugin = null;
        for (Plugin p : project.getPlugins()) {
            if (!p.getClass().getCanonicalName().matches(ANDROID_PLUGIN_CLASS_REGEXP)) continue;
            androidPlugin = p;
            break;
        }
        if (androidPlugin == null) {
            throw new GradleException("AndroidSvgDrawable MUST be used with the Android plugin.");
        }
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Set preBuildTasks = project.getTasksByName("preBuild", false);
                if (preBuildTasks.isEmpty()) {
                    project.getLogger().error("The Android plugin 'preBuild' task could not be found. Skipping SVG generation...");
                } else {
                    ((Task)preBuildTasks.iterator().next()).dependsOn(new Object[]{project.getTasks().withType(SvgDrawableTask.class)});
                }
            }
        });
    }
}

