/*
 * Decompiled with CFR 0.152.
 */
package fr.avianey.androidsvgdrawable.gradle;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import fr.avianey.androidsvgdrawable.BoundsType;
import fr.avianey.androidsvgdrawable.Density;
import fr.avianey.androidsvgdrawable.OutputFormat;
import fr.avianey.androidsvgdrawable.OutputType;
import fr.avianey.androidsvgdrawable.OverwriteMode;
import fr.avianey.androidsvgdrawable.SvgDrawablePlugin;
import fr.avianey.androidsvgdrawable.gradle.GradleLogger;
import fr.avianey.androidsvgdrawable.util.Log;
import groovy.lang.Closure;
import java.io.File;
import java.util.Arrays;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;

public class SvgDrawableTask
extends DefaultTask
implements SvgDrawablePlugin.Parameters {
    public static final Predicate<Object> notNull = new Predicate<Object>(){

        public boolean apply(Object o) {
            return o != null;
        }
    };
    public FileCollection from;
    @OutputDirectory
    public File to;
    public boolean createMissingDirectories = DEFAULT_CREATE_MISSING_DIRECTORIES;
    public OverwriteMode overwriteMode = OverwriteMode.always;
    public Density.Value[] targetedDensities;
    public File ninePatchConfig;
    public FileCollection svgMaskFiles;
    public FileCollection svgMaskResourceFiles;
    @OutputDirectory
    public File svgMaskedSvgOutputDirectory;
    public boolean useSameSvgOnlyOnceInMask;
    public OutputType outputType = DEFAULT_OUTPUT_TYPE;
    public OutputFormat outputFormat = DEFAULT_OUTPUT_FORMAT;
    public int jpgQuality = DEFAULT_JPG_QUALITY;
    public int jpgBackgroundColor = DEFAULT_JPG_BACKGROUND_COLOR;
    public BoundsType svgBoundsType = DEFAULT_BOUNDS_TYPE;

    public Task configure(Closure closure) {
        Task task = super.configure(closure);
        if (this.svgMaskedSvgOutputDirectory == null) {
            this.svgMaskedSvgOutputDirectory = new File(this.getProject().getBuildDir(), "generated-svg");
        }
        if (!task.getInputs().getHasInputs()) {
            task.getInputs().files(FluentIterable.from(Arrays.asList(this.from, this.ninePatchConfig, this.svgMaskFiles, this.svgMaskResourceFiles)).filter(notNull).toArray(Object.class));
        }
        if (!task.getOutputs().getHasOutput()) {
            task.getOutputs().files(FluentIterable.from(Arrays.asList(this.to, this.svgMaskedSvgOutputDirectory)).filter(notNull).toArray(File.class));
        }
        return task;
    }

    @TaskAction
    public void transcode() {
        SvgDrawablePlugin plugin = new SvgDrawablePlugin((SvgDrawablePlugin.Parameters)this, (Log)new GradleLogger((Logger)this.getProject().getLogger()));
        plugin.execute();
    }

    public Iterable<File> getFiles() {
        return this.from;
    }

    public File getTo() {
        return this.to;
    }

    public boolean isCreateMissingDirectories() {
        return this.createMissingDirectories;
    }

    public OverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public Density.Value[] getTargetedDensities() {
        return this.targetedDensities;
    }

    public File getNinePatchConfig() {
        return this.ninePatchConfig;
    }

    public Iterable<File> getSvgMaskFiles() {
        return this.svgMaskFiles;
    }

    public Iterable<File> getSvgMaskResourceFiles() {
        return this.svgMaskResourceFiles;
    }

    public File getSvgMaskedSvgOutputDirectory() {
        return this.svgMaskedSvgOutputDirectory;
    }

    public boolean isUseSameSvgOnlyOnceInMask() {
        return this.useSameSvgOnlyOnceInMask;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public int getJpgQuality() {
        return this.jpgQuality;
    }

    public int getJpgBackgroundColor() {
        return this.jpgBackgroundColor;
    }

    public BoundsType getSvgBoundsType() {
        return this.svgBoundsType;
    }

    public void setFrom(FileCollection from) {
        this.from = from;
    }

    public void setTo(File to) {
        this.to = to;
    }

    public void setCreateMissingDirectories(boolean createMissingDirectories) {
        this.createMissingDirectories = createMissingDirectories;
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public void setTargetedDensities(Density.Value[] targetedDensities) {
        this.targetedDensities = targetedDensities;
    }

    public void setNinePatchConfig(File ninePatchConfig) {
        this.ninePatchConfig = ninePatchConfig;
    }

    public void setSvgMaskFiles(FileCollection svgMaskFiles) {
        this.svgMaskFiles = svgMaskFiles;
    }

    public void setSvgMaskResourceFiles(FileCollection svgMaskResourceFiles) {
        this.svgMaskResourceFiles = svgMaskResourceFiles;
    }

    public void setSvgMaskedSvgOutputDirectory(File svgMaskedSvgOutputDirectory) {
        this.svgMaskedSvgOutputDirectory = svgMaskedSvgOutputDirectory;
    }

    public void setUseSameSvgOnlyOnceInMask(boolean useSameSvgOnlyOnceInMask) {
        this.useSameSvgOnlyOnceInMask = useSameSvgOnlyOnceInMask;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setJpgQuality(int jpgQuality) {
        this.jpgQuality = jpgQuality;
    }

    public void setJpgBackgroundColor(int jpgBackgroundColor) {
        this.jpgBackgroundColor = jpgBackgroundColor;
    }

    public void setSvgBoundsType(BoundsType svgBoundsType) {
        this.svgBoundsType = svgBoundsType;
    }
}

