/*
 * Decompiled with CFR 0.152.
 */
package fr.avianey.appratedialog;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import fr.avianey.appratedialog.R;
import java.lang.ref.WeakReference;
import java.util.Date;

public class AppRateDialog {
    private static final String TAG;
    public static final String PREF_NAME;
    private static final String KEY_INSTALL_DATE = "ard_install_date";
    private static final String KEY_LAUNCH_TIMES = "ard_launch_times";
    private static final String KEY_OPT_OUT = "ard_opt_out";
    private static final String KEY_ASK_LATER_DATE = "ard_ask_later_date";
    private static Date installDate;
    private static int launchTimes;
    private static boolean optOut;
    private static Date askLaterDate;
    private static Config config;
    private static Callback callback;
    private static WeakReference<AlertDialog> dialogRef;

    public static void init(Config config) {
        AppRateDialog.config = config;
    }

    public static void setCallback(Callback callback) {
        AppRateDialog.callback = callback;
    }

    public static void onStart(Context context) {
        SharedPreferences pref = context.getSharedPreferences(PREF_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        if (pref.getLong(KEY_INSTALL_DATE, 0L) == 0L) {
            AppRateDialog.storeInstallDate(context, editor);
        }
        int launchTimes = pref.getInt(KEY_LAUNCH_TIMES, 0);
        editor.putInt(KEY_LAUNCH_TIMES, launchTimes + 1);
        editor.commit();
        installDate = new Date(pref.getLong(KEY_INSTALL_DATE, 0L));
        AppRateDialog.launchTimes = launchTimes;
        optOut = pref.getBoolean(KEY_OPT_OUT, false);
        askLaterDate = new Date(pref.getLong(KEY_ASK_LATER_DATE, 0L));
    }

    public static boolean showRateDialogIfNeeded(Context context) {
        if (AppRateDialog.shouldShowRateDialog()) {
            AppRateDialog.showRateDialog(context);
            return true;
        }
        return false;
    }

    public static boolean showRateDialogIfNeeded(Context context, int themeId) {
        if (AppRateDialog.shouldShowRateDialog()) {
            AppRateDialog.showRateDialog(context, themeId);
            return true;
        }
        return false;
    }

    public static boolean shouldShowRateDialog() {
        if (optOut) {
            return false;
        }
        if (config.mShowAtFirstLaunch && launchTimes == 0) {
            return true;
        }
        if (launchTimes >= config.mCriteriaLaunchTimes) {
            return true;
        }
        long threshold = (long)(config.mCriteriaInstallDays * 24 * 60 * 60) * 1000L;
        return new Date().getTime() - installDate.getTime() >= threshold && new Date().getTime() - askLaterDate.getTime() >= threshold;
    }

    public static void showRateDialog(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        AppRateDialog.showRateDialog(context, builder);
    }

    public static void showRateDialog(Context context, int themeId) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context, themeId);
        AppRateDialog.showRateDialog(context, builder);
    }

    public static void stopRateDialog(Context context) {
        AppRateDialog.setOptOut(context, true);
    }

    private static void showRateDialog(final Context context, AlertDialog.Builder builder) {
        if (dialogRef != null && dialogRef.get() != null) {
            return;
        }
        int titleId = config.mTitleId != 0 ? config.mTitleId : R.string.ard_dialog_title;
        int messageId = config.mMessageId != 0 ? config.mMessageId : R.string.ard_dialog_message;
        int cancelButtonID = config.mCancelButton != 0 ? config.mCancelButton : R.string.ard_dialog_cancel;
        int thanksButtonID = config.mNoButtonId != 0 ? config.mNoButtonId : R.string.ard_dialog_no;
        int rateButtonID = config.mYesButtonId != 0 ? config.mYesButtonId : R.string.ard_dialog_ok;
        builder.setTitle(titleId);
        builder.setMessage(messageId);
        builder.setCancelable(config.mCancelable);
        builder.setPositiveButton(rateButtonID, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (callback != null) {
                    callback.onYesClicked();
                }
                String appPackage = context.getPackageName();
                String url = "https://play.google.com/store/apps/details?id=" + appPackage;
                if (!TextUtils.isEmpty((CharSequence)config.mUrl)) {
                    url = config.mUrl;
                }
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                context.startActivity(intent);
                AppRateDialog.setOptOut(context, true);
            }
        });
        builder.setNeutralButton(cancelButtonID, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (callback != null) {
                    callback.onCancelClicked();
                }
                AppRateDialog.clearSharedPreferences(context);
                AppRateDialog.storeAskLaterDate(context);
            }
        });
        builder.setNegativeButton(thanksButtonID, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (callback != null) {
                    callback.onNoClicked();
                }
                AppRateDialog.setOptOut(context, true);
            }
        });
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (callback != null) {
                    callback.onCancelClicked();
                }
                AppRateDialog.clearSharedPreferences(context);
                AppRateDialog.storeAskLaterDate(context);
            }
        });
        builder.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                dialogRef.clear();
            }
        });
        dialogRef = new WeakReference<AlertDialog>(builder.show());
    }

    private static void clearSharedPreferences(Context context) {
        SharedPreferences pref = context.getSharedPreferences(PREF_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.remove(KEY_INSTALL_DATE);
        editor.remove(KEY_LAUNCH_TIMES);
        editor.commit();
    }

    private static void setOptOut(Context context, boolean optOut) {
        SharedPreferences pref = context.getSharedPreferences(PREF_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putBoolean(KEY_OPT_OUT, optOut);
        editor.commit();
        AppRateDialog.optOut = optOut;
    }

    private static void storeInstallDate(Context context, SharedPreferences.Editor editor) {
        Date installDate = new Date();
        if (Build.VERSION.SDK_INT >= 9) {
            PackageManager packMan = context.getPackageManager();
            try {
                PackageInfo pkgInfo = packMan.getPackageInfo(context.getPackageName(), 0);
                installDate = new Date(pkgInfo.firstInstallTime);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        editor.putLong(KEY_INSTALL_DATE, installDate.getTime());
    }

    private static void storeAskLaterDate(Context context) {
        SharedPreferences pref = context.getSharedPreferences(PREF_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putLong(KEY_ASK_LATER_DATE, System.currentTimeMillis());
        editor.commit();
    }

    static {
        PREF_NAME = TAG = AppRateDialog.class.getSimpleName();
        installDate = new Date();
        launchTimes = 0;
        optOut = false;
        askLaterDate = new Date();
        config = new Config();
        callback = null;
        dialogRef = null;
    }

    public static interface Callback {
        public void onYesClicked();

        public void onNoClicked();

        public void onCancelClicked();
    }

    public static class Config {
        private String mUrl = null;
        private int mCriteriaInstallDays;
        private int mCriteriaLaunchTimes;
        private int mTitleId = 0;
        private int mMessageId = 0;
        private int mYesButtonId = 0;
        private int mNoButtonId = 0;
        private int mCancelButton = 0;
        private boolean mCancelable = true;
        private boolean mShowAtFirstLaunch = false;

        public Config() {
            this(7, 10);
        }

        public Config(int criteriaInstallDays, int criteriaLaunchTimes) {
            this.mCriteriaInstallDays = criteriaInstallDays;
            this.mCriteriaLaunchTimes = criteriaLaunchTimes;
        }

        public void setTitle(@StringRes int stringId) {
            this.mTitleId = stringId;
        }

        public void setMessage(@StringRes int stringId) {
            this.mMessageId = stringId;
        }

        public void setYesButtonText(@StringRes int stringId) {
            this.mYesButtonId = stringId;
        }

        public void setNoButtonText(@StringRes int stringId) {
            this.mNoButtonId = stringId;
        }

        public void setCancelButtonText(@StringRes int stringId) {
            this.mCancelButton = stringId;
        }

        public void setUrl(String url) {
            this.mUrl = url;
        }

        public void setShowAtFirstLaunch(boolean showAtFirstLaunch) {
            this.mShowAtFirstLaunch = showAtFirstLaunch;
        }

        public void setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
        }
    }
}

