package fr.avianey.appratedialog;

import android.support.annotation.StringRes;

/**
 * AppRateDialog configuration.
 */
public class AppRateDialogConfig {
    String url = null;
    int criteriaInstallDays;
    int criteriaLaunchTimes;
    int titleId = 0;
    int messageId = 0;
    int yesButtonId = 0;
    int noButtonId = 0;
    int cancelButton = 0;
    int feedbackTitleId = 0;
    int feedbackMessageId = 0;
    int feedbackSendButtonId = 0;
    int starThreshold = 5;
    boolean cancelable = true;
    boolean showAtFirstLaunch = false;
    boolean useStarRating = false;

    /**
     * Constructor with default criteria.
     */
    public AppRateDialogConfig() {
        this(7, 10);
    }

    /**
     * Constructor.
     * @param criteriaInstallDays
     * @param criteriaLaunchTimes
     */
    public AppRateDialogConfig(int criteriaInstallDays, int criteriaLaunchTimes) {
        this.criteriaInstallDays = criteriaInstallDays;
        this.criteriaLaunchTimes = criteriaLaunchTimes;
    }

    /**
     * Set title string ID.
     * @param stringId
     */
    public void setTitle(@StringRes int stringId) {
        this.titleId = stringId;
    }

    /**
     * Set message string ID.
     * @param stringId
     */
    public void setMessage(@StringRes int stringId) {
        this.messageId = stringId;
    }

    /**
     * Set rate now string ID.
     * @param stringId
     */
    public void setYesButtonText(@StringRes int stringId) {
        this.yesButtonId = stringId;
    }

    /**
     * Set no thanks string ID.
     * @param stringId
     */
    public void setNoButtonText(@StringRes int stringId) {
        this.noButtonId = stringId;
    }

    /**
     * Set cancel string ID.
     * @param stringId
     */
    public void setCancelButtonText(@StringRes int stringId) {
        this.cancelButton = stringId;
    }

    /**
     * Set navigation url when user clicks rate button.
     * Typically, url will be https://play.google.com/store/apps/details?id=PACKAGE_NAME for Google Play.
     * @param url
     */
    public void setUrl(String url) {
        this.url = url;
    }

    public void setShowAtFirstLaunch(boolean showAtFirstLaunch) {
        this.showAtFirstLaunch = showAtFirstLaunch;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    /**
     * Use a star rating bar instead of the rate button.
     * @param useStarRating
     */
    public void setUseStarRating(boolean useStarRating) {
        this.useStarRating = useStarRating;
    }

    /**
     * Set the minimum amount of star required to redirect for rating
     * @param threshold the threshold <= 5
     */
    public void setStarThreshold(int threshold) {
        if (threshold > 5) {
            threshold = 5;
        }
        this.starThreshold = threshold;
    }

    public void setFeedbackTitleId(int feedbackTitleId) {
        this.feedbackTitleId = feedbackTitleId;
    }

    public void setFeedbackMessageId(int feedbackMessageId) {
        this.feedbackMessageId = feedbackMessageId;
    }

    public void setFeedbackSendButtonId(int feedbackSendButtonId) {
        this.feedbackSendButtonId = feedbackSendButtonId;
    }
}
