/*
 * Decompiled with CFR 0.152.
 */
package fr.avianey.appratedialog;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.RatingBar;
import android.widget.TextView;
import fr.avianey.appratedialog.AppRateDialogConfig;
import fr.avianey.appratedialog.R;
import java.lang.ref.WeakReference;
import java.util.Date;

public final class AppRateDialog {
    private static final String TAG;
    public static final String PREF_NAME;
    private static final String KEY_INSTALL_DATE = "ard_install_date";
    private static final String KEY_LAUNCH_TIMES = "ard_launch_times";
    private static final String KEY_SHOWN_COUNT = "ard_shown_count";
    private static final String KEY_OPT_OUT = "ard_opt_out";
    private static final String KEY_ASK_LATER_DATE = "ard_ask_later_date";
    private static Date installDate;
    private static Date askLaterDate;
    private static int launchTimes;
    private static int shownCount;
    private static boolean optOut;
    private static AppRateDialogConfig config;
    private static Callback callback;
    private static WeakReference<AlertDialog> dialogRef;

    private AppRateDialog() {
    }

    public static void init(AppRateDialogConfig config) {
        AppRateDialog.config = config;
    }

    public static void setCallback(Callback callback) {
        AppRateDialog.callback = callback;
    }

    public static void onStart(Context context) {
        SharedPreferences pref = context.getSharedPreferences(PREF_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        if (pref.getLong(KEY_INSTALL_DATE, 0L) == 0L) {
            AppRateDialog.storeInstallDate(context, editor);
        }
        shownCount = pref.getInt(KEY_SHOWN_COUNT, 0);
        int launchTimes = pref.getInt(KEY_LAUNCH_TIMES, 0);
        editor.putInt(KEY_LAUNCH_TIMES, launchTimes + 1);
        editor.apply();
        installDate = new Date(pref.getLong(KEY_INSTALL_DATE, 0L));
        AppRateDialog.launchTimes = launchTimes;
        optOut = pref.getBoolean(KEY_OPT_OUT, false);
        askLaterDate = new Date(pref.getLong(KEY_ASK_LATER_DATE, 0L));
    }

    public static boolean showRateDialogIfNeeded(Context context) {
        if (AppRateDialog.shouldShowRateDialog()) {
            AppRateDialog.showRateDialog(context);
            return true;
        }
        return false;
    }

    public static boolean showRateDialogIfNeeded(Context context, int themeId) {
        if (AppRateDialog.shouldShowRateDialog()) {
            AppRateDialog.showRateDialog(context, themeId);
            return true;
        }
        return false;
    }

    public static boolean shouldShowRateDialog() {
        if (optOut) {
            return false;
        }
        if (AppRateDialog.config.showAtFirstLaunch && shownCount == 0) {
            return true;
        }
        if (launchTimes >= AppRateDialog.config.criteriaLaunchTimes) {
            return true;
        }
        long threshold = (long)(AppRateDialog.config.criteriaInstallDays * 24 * 60 * 60) * 1000L;
        return new Date().getTime() - installDate.getTime() >= threshold && new Date().getTime() - askLaterDate.getTime() >= threshold;
    }

    public static AppRateDialogConfig getConfig() {
        return config;
    }

    public static void showRateDialog(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        AppRateDialog.showRateDialog(context, builder);
    }

    public static void showRateDialog(Context context, int themeId) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context, themeId);
        AppRateDialog.showRateDialog(context, builder);
    }

    public static void stopRateDialog(Context context) {
        AppRateDialog.setOptOut(context, true);
    }

    private static void showRateDialog(Context context, AlertDialog.Builder builder) {
        if (dialogRef != null && dialogRef.get() != null) {
            return;
        }
        int titleId = AppRateDialog.config.titleId != 0 ? AppRateDialog.config.titleId : R.string.ard_dialog_title;
        int messageId = AppRateDialog.config.messageId != 0 ? AppRateDialog.config.messageId : R.string.ard_dialog_message;
        int cancelButtonID = AppRateDialog.config.cancelButton != 0 ? AppRateDialog.config.cancelButton : R.string.ard_dialog_cancel;
        int thanksButtonID = AppRateDialog.config.noButtonId != 0 ? AppRateDialog.config.noButtonId : R.string.ard_dialog_no;
        int rateButtonID = AppRateDialog.config.yesButtonId != 0 ? AppRateDialog.config.yesButtonId : R.string.ard_dialog_ok;
        builder.setTitle(titleId);
        if (AppRateDialog.config.useStarRating) {
            View ratingContent = LayoutInflater.from((Context)builder.getContext()).inflate(R.layout.dialog_star_rating, null);
            ((TextView)ratingContent.findViewById(16908308)).setText(messageId);
            builder.setView(ratingContent);
            RatingBar ratingBar = (RatingBar)ratingContent.findViewById(16908297);
            ratingBar.setOnRatingBarChangeListener((rb, r, b) -> {
                if (AppRateDialog.config.starAutoRateThreshold != null && rb.getRating() >= (float)AppRateDialog.config.starAutoRateThreshold.intValue()) {
                    AppRateDialog.rate(context);
                } else if (dialogRef != null && dialogRef.get() != null) {
                    ((AlertDialog)dialogRef.get()).getButton(-1).setEnabled(true);
                }
            });
            builder.setPositiveButton(rateButtonID, (dialog, which) -> {
                if (ratingBar.getRating() >= (float)AppRateDialog.config.starThreshold) {
                    AppRateDialog.rate(context);
                } else {
                    int feedbackTitleId = AppRateDialog.config.feedbackTitleId != 0 ? AppRateDialog.config.feedbackTitleId : R.string.ard_dialog_feedback_title;
                    int feedbackMessageId = AppRateDialog.config.feedbackMessageId != 0 ? AppRateDialog.config.feedbackMessageId : R.string.ard_dialog_feedback_message;
                    int feedbackSendButtonId = AppRateDialog.config.feedbackSendButtonId != 0 ? AppRateDialog.config.feedbackSendButtonId : R.string.ard_dialog_feedback_send;
                    View feedbackContent = LayoutInflater.from((Context)builder.getContext()).inflate(R.layout.dialog_feedback, null);
                    ((TextView)feedbackContent.findViewById(16908308)).setText(feedbackMessageId);
                    new AlertDialog.Builder(builder.getContext()).setTitle(feedbackTitleId).setView(feedbackContent).setPositiveButton(feedbackSendButtonId, (dialogInterface, i) -> {
                        if (callback != null) {
                            EditText input = (EditText)feedbackContent.findViewById(16908297);
                            callback.onFeedback(input.getText().toString());
                        }
                        AppRateDialog.revoke(context);
                    }).setNeutralButton(cancelButtonID, (dialogInterface, i) -> AppRateDialog.dismiss(context)).setNegativeButton(thanksButtonID, (dialogInterface, i) -> AppRateDialog.revoke(context)).setCancelable(AppRateDialog.config.cancelable).setOnCancelListener(dialogInterface -> AppRateDialog.dismiss(context)).show();
                }
            });
        } else {
            builder.setMessage(messageId);
            builder.setPositiveButton(rateButtonID, (dialog, which) -> AppRateDialog.rate(context));
        }
        builder.setCancelable(AppRateDialog.config.cancelable);
        builder.setNeutralButton(cancelButtonID, (dialog, which) -> AppRateDialog.dismiss(context));
        builder.setNegativeButton(thanksButtonID, (dialog, which) -> AppRateDialog.revoke(context));
        builder.setOnCancelListener(dialog -> AppRateDialog.dismiss(context));
        builder.setOnDismissListener(dialog -> dialogRef.clear());
        dialogRef = new WeakReference<AlertDialog>(builder.show());
        ++shownCount;
        if (AppRateDialog.config.useStarRating && dialogRef != null && dialogRef.get() != null) {
            ((AlertDialog)dialogRef.get()).getButton(-1).setEnabled(false);
        }
        context.getSharedPreferences(PREF_NAME, 0).edit().putInt(KEY_SHOWN_COUNT, shownCount + 1).apply();
    }

    private static void clearSharedPreferences(Context context) {
        context.getSharedPreferences(PREF_NAME, 0).edit().remove(KEY_INSTALL_DATE).remove(KEY_LAUNCH_TIMES).apply();
    }

    private static void setOptOut(Context context, boolean optOut) {
        context.getSharedPreferences(PREF_NAME, 0).edit().putBoolean(KEY_OPT_OUT, optOut).apply();
        AppRateDialog.optOut = optOut;
    }

    private static void storeInstallDate(Context context, SharedPreferences.Editor editor) {
        Date installDate = new Date();
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo pkgInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            installDate = new Date(pkgInfo.firstInstallTime);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        editor.putLong(KEY_INSTALL_DATE, installDate.getTime());
    }

    private static void storeAskLaterDate(Context context) {
        context.getSharedPreferences(PREF_NAME, 0).edit().putLong(KEY_ASK_LATER_DATE, System.currentTimeMillis()).apply();
    }

    private static void rate(Context context) {
        if (callback != null) {
            callback.onYesClicked();
        }
        String appPackage = context.getPackageName();
        String url = "https://play.google.com/store/apps/details?id=" + appPackage;
        if (!TextUtils.isEmpty((CharSequence)AppRateDialog.config.url)) {
            url = AppRateDialog.config.url;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        context.startActivity(intent);
        AppRateDialog.setOptOut(context, true);
    }

    private static void dismiss(Context context) {
        if (callback != null) {
            callback.onCancelClicked();
        }
        AppRateDialog.clearSharedPreferences(context);
        AppRateDialog.storeAskLaterDate(context);
    }

    private static void revoke(Context context) {
        if (callback != null) {
            callback.onNoClicked();
        }
        AppRateDialog.setOptOut(context, true);
    }

    static {
        PREF_NAME = TAG = AppRateDialog.class.getSimpleName();
        installDate = new Date();
        askLaterDate = new Date();
        launchTimes = 0;
        shownCount = 0;
        optOut = false;
        config = new AppRateDialogConfig();
        callback = null;
        dialogRef = null;
    }

    public static interface Callback {
        public void onYesClicked();

        public void onNoClicked();

        public void onCancelClicked();

        public void onFeedback(String var1);
    }
}

