package fr.avianey.appratedialog;

import androidx.annotation.StringRes;

/**
 * AppRateDialog configuration.
 */
public class AppRateDialogConfig {

    public interface Configurator {
        void configure(AppRateDialogConfig config);
    }

    String url = null;
    String feedbackUrl = null;
    int criteriaInstallDays = 7;
    int criteriaLaunchTimes = 10;
    int titleId = 0;
    int messageId = 0;
    int yesButtonId = 0;
    int noButtonId = 0;
    int cancelButton = 0;
    int feedbackTitleId = 0;
    int feedbackMessageId = 0;
    int feedbackSendButtonId = 0;
    int starThreshold = 5;
    Integer starAutoRateThreshold = null;
    boolean cancelable = true;
    boolean showOnFirstQuit = true;
    boolean showAtFirstLaunch = false;
    boolean showOnQuit = true;
    boolean showAtLaunch = true;
    boolean useStarRating = false;
    boolean autoFinishActivity = true;
    boolean sendFeedback = true;

    /**
     * Constructor with default criteria.
     */
    AppRateDialogConfig() {}

    /**
     * Set title string ID.
     * @param stringId
     */
    public void setTitle(@StringRes int stringId) {
        this.titleId = stringId;
    }

    /**
     * Set message string ID.
     * @param stringId
     */
    public void setMessage(@StringRes int stringId) {
        this.messageId = stringId;
    }

    /**
     * Set rate now string ID.
     * @param stringId
     */
    public void setYesButtonText(@StringRes int stringId) {
        this.yesButtonId = stringId;
    }

    /**
     * Set no thanks string ID.
     * @param stringId
     */
    public void setNoButtonText(@StringRes int stringId) {
        this.noButtonId = stringId;
    }

    /**
     * Set cancel string ID.
     * @param stringId
     */
    public void setCancelButtonText(@StringRes int stringId) {
        this.cancelButton = stringId;
    }

    /**
     * Set navigation url when user clicks rate button.
     * Typically, url will be https://play.google.com/store/apps/details?id=PACKAGE_NAME for Google Play.
     * @param url
     */
    public void setUrl(String url) {
        this.url = url;
    }

    public void setShowAtFirstLaunch(boolean showAtFirstLaunch) {
        this.showAtFirstLaunch = showAtFirstLaunch;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    /**
     * Use a star rating bar instead of the rate button.
     * @param useStarRating
     */
    public void setUseStarRating(boolean useStarRating) {
        this.useStarRating = useStarRating;
    }

    /**
     * Set the minimum amount of star required to redirect for rating
     * @param threshold the threshold <= 5
     */
    public void setStarThreshold(int threshold) {
        if (threshold > 5) {
            threshold = 5;
        }
        this.starThreshold = threshold;
    }

    /**
     * Set the minimum amount of star required to redirect for rating
     * @param threshold the threshold <= 5
     */
    public void setStarAutoRateThreshold(int threshold) {
        if (threshold > 5) {
            threshold = 5;
        }
        this.starAutoRateThreshold = threshold;
    }

    public void setFeedbackTitleId(int feedbackTitleId) {
        this.feedbackTitleId = feedbackTitleId;
    }

    public void setFeedbackMessageId(int feedbackMessageId) {
        this.feedbackMessageId = feedbackMessageId;
    }

    public void setFeedbackSendButtonId(int feedbackSendButtonId) {
        this.feedbackSendButtonId = feedbackSendButtonId;
    }

    public void setShowAtLaunch(boolean showAtLaunch) {
        this.showAtLaunch = showAtLaunch;
    }

    public void setShowOnFirstQuit(boolean showOnFirstQuit) {
        this.showOnFirstQuit = showOnFirstQuit;
    }

    public void setShowOnQuit(boolean showOnQuit) {
        this.showOnQuit = showOnQuit;
    }

    public void setCriteriaInstallDays(int criteriaInstallDays) {
        this.criteriaInstallDays = criteriaInstallDays;
    }

    public void setCriteriaLaunchTimes(int criteriaLaunchTimes) {
        this.criteriaLaunchTimes = criteriaLaunchTimes;
    }

    public void setAutoFinishActivity(boolean autoFinishActivity) {
        this.autoFinishActivity = autoFinishActivity;
    }

    public void setSendFeedback(boolean sendFeedback) {
        this.sendFeedback = sendFeedback;
    }

    public void setFeedbackUrl(String feedbackUrl) {
        this.feedbackUrl = feedbackUrl;
    }
}
