/*
 * Decompiled with CFR 0.152.
 */
package fr.avianey.appratedialog;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.RatingBar;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.android.volley.Request;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.google.gson.JsonObject;
import fr.avianey.appratedialog.AppRateDialogCallback;
import fr.avianey.appratedialog.AppRateDialogConfig;
import fr.avianey.appratedialog.R;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONObject;

public final class AppRateDialog {
    private static boolean rateDialogShown = false;
    private static final String TAG;
    public static final String PREF_NAME;
    private static final String KEY_INSTALL_DATE = "ard_install_date";
    private static final String KEY_LAUNCH_TIMES = "ard_launch_times";
    private static final String KEY_SHOWN_COUNT = "ard_shown_count";
    private static final String KEY_OPT_OUT = "ard_opt_out";
    private static final String KEY_ASK_LATER_DATE = "ard_ask_later_date";
    private static Date installDate;
    private static Date askLaterDate;
    private static int launchTimes;
    private static int shownCount;
    private static boolean optOut;
    private static AppRateDialogConfig config;
    private static AppRateDialogCallback callback;
    private static WeakReference<AlertDialog> dialogRef;

    private AppRateDialog() {
    }

    public static void init(AppRateDialogConfig config) {
        AppRateDialog.config = config;
    }

    public static void setCallback(AppRateDialogCallback callback) {
        AppRateDialog.callback = callback;
    }

    public static void onCreate(AppRateDialogConfig.Configurator configurator, AppRateDialogCallback callback) {
        configurator.configure(config);
        AppRateDialog.setCallback(callback);
    }

    public static void onStart(Activity context) {
        SharedPreferences pref = context.getSharedPreferences(PREF_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        if (pref.getLong(KEY_INSTALL_DATE, 0L) == 0L) {
            AppRateDialog.storeInstallDate((Context)context, editor);
        }
        shownCount = pref.getInt(KEY_SHOWN_COUNT, 0);
        int launchTimes = pref.getInt(KEY_LAUNCH_TIMES, 0);
        editor.putInt(KEY_LAUNCH_TIMES, launchTimes + 1);
        editor.apply();
        installDate = new Date(pref.getLong(KEY_INSTALL_DATE, 0L));
        AppRateDialog.launchTimes = launchTimes;
        optOut = pref.getBoolean(KEY_OPT_OUT, false);
        askLaterDate = new Date(pref.getLong(KEY_ASK_LATER_DATE, 0L));
        if (!rateDialogShown && AppRateDialog.config.showAtLaunch) {
            AppRateDialog.showRateDialogIfNeeded(context, AppRateDialog.config.showAtFirstLaunch, false);
        }
    }

    public static boolean onQuit(Activity context) {
        return !rateDialogShown && AppRateDialog.config.showOnQuit && AppRateDialog.showRateDialogIfNeeded(context, AppRateDialog.config.showOnFirstQuit, AppRateDialog.config.autoFinishActivity);
    }

    private static boolean showRateDialogIfNeeded(Activity context, boolean first, boolean finishActivity) {
        if (AppRateDialog.shouldShowRateDialog(first)) {
            AppRateDialog.showRateDialog(context, finishActivity);
            rateDialogShown = true;
            return true;
        }
        return false;
    }

    private static boolean shouldShowRateDialog(boolean first) {
        if (optOut) {
            return false;
        }
        if (first && shownCount == 0) {
            return true;
        }
        if (launchTimes >= AppRateDialog.config.criteriaLaunchTimes) {
            return true;
        }
        long threshold = (long)(AppRateDialog.config.criteriaInstallDays * 24 * 60 * 60) * 1000L;
        return new Date().getTime() - installDate.getTime() >= threshold && new Date().getTime() - askLaterDate.getTime() >= threshold;
    }

    public static AppRateDialogConfig getConfig() {
        return config;
    }

    public static void stopRateDialog(Context context) {
        AppRateDialog.setOptOut(context, true);
    }

    private static void showRateDialog(Activity context, boolean finishActivity) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        if (dialogRef != null && dialogRef.get() != null) {
            return;
        }
        int titleId = AppRateDialog.config.titleId != 0 ? AppRateDialog.config.titleId : R.string.ard_dialog_title;
        int messageId = AppRateDialog.config.messageId != 0 ? AppRateDialog.config.messageId : R.string.ard_dialog_message;
        int cancelButtonID = AppRateDialog.config.cancelButton != 0 ? AppRateDialog.config.cancelButton : R.string.ard_dialog_cancel;
        int thanksButtonID = AppRateDialog.config.noButtonId != 0 ? AppRateDialog.config.noButtonId : R.string.ard_dialog_no;
        int rateButtonID = AppRateDialog.config.yesButtonId != 0 ? AppRateDialog.config.yesButtonId : R.string.ard_dialog_ok;
        builder.setTitle(titleId);
        if (AppRateDialog.config.useStarRating) {
            View ratingContent = LayoutInflater.from((Context)builder.getContext()).inflate(R.layout.dialog_star_rating, null);
            ((TextView)ratingContent.findViewById(16908308)).setText(messageId);
            builder.setView(ratingContent);
            RatingBar ratingBar = (RatingBar)ratingContent.findViewById(16908297);
            ratingBar.setOnRatingBarChangeListener((rb, r, b) -> {
                if (AppRateDialog.config.starAutoRateThreshold != null && rb.getRating() >= (float)AppRateDialog.config.starAutoRateThreshold.intValue()) {
                    AppRateDialog.rate(context, (int)rb.getRating(), finishActivity);
                    ((AlertDialog)dialogRef.get()).dismiss();
                } else if (dialogRef != null && dialogRef.get() != null) {
                    ((AlertDialog)dialogRef.get()).getButton(-1).setEnabled(true);
                }
            });
            builder.setPositiveButton(rateButtonID, (dialog, which) -> {
                if (ratingBar.getRating() >= (float)AppRateDialog.config.starThreshold) {
                    AppRateDialog.rate(context, (int)ratingBar.getRating(), finishActivity);
                } else {
                    AppRateDialog.showFeedbackDialog(context, AppRateDialog.config.cancelable, finishActivity, AppRateDialog.config.sendFeedback, true);
                }
            });
        } else {
            builder.setMessage(messageId);
            builder.setPositiveButton(rateButtonID, (dialog, which) -> AppRateDialog.rate(context, null, finishActivity));
        }
        builder.setCancelable(AppRateDialog.config.cancelable);
        builder.setNeutralButton(cancelButtonID, (dialog, which) -> AppRateDialog.dismiss(context, finishActivity));
        builder.setNegativeButton(thanksButtonID, (dialog, which) -> AppRateDialog.revoke(context, finishActivity));
        builder.setOnCancelListener(dialog -> AppRateDialog.dismiss(context, finishActivity));
        builder.setOnDismissListener(dialog -> dialogRef.clear());
        dialogRef = new WeakReference<AlertDialog>(builder.show());
        ++shownCount;
        if (AppRateDialog.config.useStarRating && dialogRef != null && dialogRef.get() != null) {
            ((AlertDialog)dialogRef.get()).getButton(-1).setEnabled(false);
        }
        context.getSharedPreferences(PREF_NAME, 0).edit().putInt(KEY_SHOWN_COUNT, shownCount + 1).apply();
    }

    public static void showFeedbackDialog(Activity context) {
        AppRateDialog.showFeedbackDialog(context, true, false, true, false);
    }

    private static void showFeedbackDialog(Activity context, boolean cancelable, boolean finishActivity, boolean sendFeedback, boolean saveStatus) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        int cancelButtonID = AppRateDialog.config.cancelButton != 0 ? AppRateDialog.config.cancelButton : R.string.ard_dialog_cancel;
        int thanksButtonID = AppRateDialog.config.noButtonId != 0 ? AppRateDialog.config.noButtonId : R.string.ard_dialog_no;
        int feedbackTitleId = AppRateDialog.config.feedbackTitleId != 0 ? AppRateDialog.config.feedbackTitleId : R.string.ard_dialog_feedback_title;
        int feedbackMessageId = AppRateDialog.config.feedbackMessageId != 0 ? AppRateDialog.config.feedbackMessageId : R.string.ard_dialog_feedback_message;
        int feedbackSendButtonId = AppRateDialog.config.feedbackSendButtonId != 0 ? AppRateDialog.config.feedbackSendButtonId : R.string.ard_dialog_feedback_send;
        View feedbackContent = LayoutInflater.from((Context)builder.getContext()).inflate(R.layout.dialog_feedback, null);
        ((TextView)feedbackContent.findViewById(16908308)).setText(feedbackMessageId);
        EditText editText = (EditText)feedbackContent.findViewById(16908297);
        builder.setTitle(feedbackTitleId).setView(feedbackContent).setPositiveButton(feedbackSendButtonId, (dialogInterface, i) -> {
            JsonObject meta = null;
            String feedback = editText.getText().toString();
            if (callback != null) {
                meta = callback.onFeedback(feedback);
            }
            if (sendFeedback) {
                AppRateDialog.sendFeedback(context, feedback, meta);
            }
            if (saveStatus) {
                AppRateDialog.revoke(context, finishActivity);
            }
        }).setNegativeButton(thanksButtonID, (dialogInterface, i) -> {
            if (saveStatus) {
                AppRateDialog.revoke(context, finishActivity);
            }
        }).setCancelable(cancelable).setOnCancelListener(dialogInterface -> {
            if (saveStatus) {
                AppRateDialog.dismiss(context, finishActivity);
            }
        });
        if (saveStatus) {
            builder.setNeutralButton(cancelButtonID, (dialogInterface, i) -> {
                if (saveStatus) {
                    AppRateDialog.dismiss(context, finishActivity);
                }
            });
        }
        AlertDialog d = builder.show();
        d.setOnDismissListener(dialog -> {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.toggleSoftInput(1, 0);
        });
        editText.requestFocus();
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.toggleSoftInput(2, 0);
    }

    public static int getLaunchCount(Context context) {
        return context.getSharedPreferences(PREF_NAME, 0).getInt(KEY_LAUNCH_TIMES, 0);
    }

    public static boolean isOptedOut(Context context) {
        return context.getSharedPreferences(PREF_NAME, 0).getBoolean(KEY_OPT_OUT, false);
    }

    private static void sendFeedback(Activity context, String feedback, JsonObject meta) {
        if (AppRateDialog.config.feedbackUrl == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("feedback", feedback);
        params.put("app", context.getPackageName());
        params.put("phoneManufacturer", Build.MANUFACTURER);
        params.put("phoneModel", Build.MODEL);
        params.put("osVersion", Build.VERSION.SDK_INT);
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (packageInfo != null) {
                params.put("appVersion", packageInfo.versionName);
            }
        }
        catch (PackageManager.NameNotFoundException packageInfo) {
            // empty catch block
        }
        if (meta != null) {
            params.put("meta", meta.toString());
        }
        JsonObjectRequest req = new JsonObjectRequest(AppRateDialog.config.feedbackUrl, new JSONObject(params), response -> {}, error -> {});
        Volley.newRequestQueue((Context)context).add((Request)req);
    }

    private static void clearSharedPreferences(Context context) {
        context.getSharedPreferences(PREF_NAME, 0).edit().remove(KEY_INSTALL_DATE).remove(KEY_LAUNCH_TIMES).apply();
    }

    private static void setOptOut(Context context, boolean optOut) {
        context.getSharedPreferences(PREF_NAME, 0).edit().putBoolean(KEY_OPT_OUT, optOut).apply();
        AppRateDialog.optOut = optOut;
    }

    private static void storeInstallDate(Context context, SharedPreferences.Editor editor) {
        Date installDate = new Date();
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo pkgInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            installDate = new Date(pkgInfo.firstInstallTime);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        editor.putLong(KEY_INSTALL_DATE, installDate.getTime());
    }

    private static void storeAskLaterDate(Context context) {
        context.getSharedPreferences(PREF_NAME, 0).edit().putLong(KEY_ASK_LATER_DATE, System.currentTimeMillis()).apply();
    }

    private static void rate(Activity context, Integer selectedRating, boolean finishActivity) {
        if (callback != null) {
            callback.onYesClicked(selectedRating);
        }
        String appPackage = context.getPackageName();
        String url = "https://play.google.com/store/apps/details?id=" + appPackage;
        if (!TextUtils.isEmpty((CharSequence)AppRateDialog.config.url)) {
            url = AppRateDialog.config.url;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        context.startActivity(intent);
        AppRateDialog.setOptOut((Context)context, true);
        if (finishActivity) {
            context.finish();
        }
    }

    private static void dismiss(Activity context, boolean finishActivity) {
        if (callback != null) {
            callback.onCancelClicked();
        }
        AppRateDialog.clearSharedPreferences((Context)context);
        AppRateDialog.storeAskLaterDate((Context)context);
        if (finishActivity) {
            context.finish();
        }
    }

    private static void revoke(Activity context, boolean finishActivity) {
        if (callback != null) {
            callback.onNoClicked();
        }
        AppRateDialog.setOptOut((Context)context, true);
        if (finishActivity) {
            context.finish();
        }
    }

    static {
        PREF_NAME = TAG = AppRateDialog.class.getSimpleName();
        installDate = new Date();
        askLaterDate = new Date();
        launchTimes = 0;
        shownCount = 0;
        optOut = false;
        config = new AppRateDialogConfig();
        callback = null;
        dialogRef = null;
    }
}

