/*
 * Decompiled with CFR 0.152.
 */
package fr.pixelprose.minimax4j;

import fr.pixelprose.minimax4j.Difficulty;
import fr.pixelprose.minimax4j.Move;
import java.util.List;

public abstract class IA<M extends Move> {
    private final Algorithm algo;

    public IA() {
        this(Algorithm.NEGAMAX);
    }

    public IA(Algorithm algo) {
        this.algo = algo;
    }

    public M getBestMove() {
        IAMoveWrapper wrapper = new IAMoveWrapper();
        switch (this.algo) {
            case MINIMAX: {
                this.minimax(wrapper, 0, this.getDifficulty().getDepth());
                break;
            }
            case ALPHA_BETA: {
                this.alphabeta(wrapper, 0, this.getDifficulty().getDepth(), -this.maxEvaluateValue(), this.maxEvaluateValue());
                break;
            }
            case NEGAMAX: {
                this.negamax(wrapper, this.getDifficulty().getDepth(), -this.maxEvaluateValue(), this.maxEvaluateValue());
                break;
            }
            default: {
                this.negascout(wrapper, this.getDifficulty().getDepth(), -this.maxEvaluateValue(), this.maxEvaluateValue());
            }
        }
        return wrapper.move;
    }

    private final double minimax(IAMoveWrapper wrapper, int depth, int DEPTH) {
        if (depth == DEPTH) {
            return this.evaluate();
        }
        if (this.isOver()) {
            return (double)((DEPTH - depth) % 2 == 1 ? -1 : 1) * this.evaluate();
        }
        Move bestMove = null;
        List<M> moves = this.getPossibleMoves();
        if (moves.isEmpty()) {
            return this.minimax(null, depth + 1, DEPTH);
        }
        if (depth % 2 == DEPTH % 2) {
            double score = -this.maxEvaluateValue();
            double bestScore = -this.maxEvaluateValue();
            for (Move move : moves) {
                this.makeMove(move);
                score = this.minimax(null, depth + 1, DEPTH);
                this.unmakeMove(move);
                if (!(score > bestScore)) continue;
                bestScore = score;
                bestMove = move;
            }
            if (wrapper != null) {
                wrapper.move = bestMove;
            }
            return bestScore;
        }
        double score = this.maxEvaluateValue();
        double bestScore = this.maxEvaluateValue();
        for (Move move : moves) {
            this.makeMove(move);
            score = this.minimax(null, depth + 1, DEPTH);
            this.unmakeMove(move);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestMove = move;
        }
        if (wrapper != null) {
            wrapper.move = bestMove;
        }
        return bestScore;
    }

    private final double alphabeta(IAMoveWrapper wrapper, int depth, int DEPTH, double alpha, double beta) {
        if (depth == DEPTH) {
            return this.evaluate();
        }
        if (this.isOver()) {
            return (double)((DEPTH - depth) % 2 == 1 ? -1 : 1) * this.evaluate();
        }
        Move bestMove = null;
        List<M> moves = this.getPossibleMoves();
        if (moves.isEmpty()) {
            return this.alphabeta(null, depth + 1, DEPTH, alpha, beta);
        }
        if (depth % 2 == DEPTH % 2) {
            for (Move move : moves) {
                this.makeMove(move);
                double score = this.alphabeta(null, depth + 1, DEPTH, alpha, beta);
                this.unmakeMove(move);
                if (!(score > alpha)) continue;
                alpha = score;
                bestMove = move;
                if (!(alpha >= beta)) continue;
                break;
            }
            if (wrapper != null) {
                wrapper.move = bestMove;
            }
            return alpha;
        }
        for (Move move : moves) {
            this.makeMove(move);
            double score = this.alphabeta(null, depth + 1, DEPTH, alpha, beta);
            this.unmakeMove(move);
            if (!(score < beta)) continue;
            beta = score;
            bestMove = move;
            if (!(alpha >= beta)) continue;
            break;
        }
        if (wrapper != null) {
            wrapper.move = bestMove;
        }
        return beta;
    }

    private final double negamax(IAMoveWrapper wrapper, int depth, double alpha, double beta) {
        if (depth == 0 || this.isOver()) {
            return this.evaluate();
        }
        Move bestMove = null;
        List<M> moves = this.getPossibleMoves();
        if (moves.isEmpty()) {
            return -this.negamax(null, depth - 1, -beta, -alpha);
        }
        double score = -this.maxEvaluateValue();
        for (Move move : moves) {
            this.makeMove(move);
            score = -this.negamax(null, depth - 1, -beta, -alpha);
            this.unmakeMove(move);
            if (!(score > alpha)) continue;
            alpha = score;
            bestMove = move;
            if (!(alpha >= beta)) continue;
            break;
        }
        if (wrapper != null) {
            wrapper.move = bestMove;
        }
        return alpha;
    }

    private final double negascout(IAMoveWrapper wrapper, int depth, double alpha, double beta) {
        if (depth == 0 || this.isOver()) {
            return this.evaluate();
        }
        List<M> moves = this.getPossibleMoves();
        double b = beta;
        Move bestMove = null;
        if (moves.isEmpty()) {
            return -this.negascout(null, depth - 1, -beta, -alpha);
        }
        boolean first = true;
        for (Move move : moves) {
            this.makeMove(move);
            double score = -this.negascout(null, depth - 1, -b, -alpha);
            if (!first && alpha < score && score < beta) {
                score = -this.negascout(null, depth - 1, -beta, -alpha);
            }
            this.unmakeMove(move);
            if (score > alpha) {
                alpha = score;
                bestMove = move;
                if (alpha >= beta) break;
            }
            b = alpha + 1.0;
            first = false;
        }
        if (wrapper != null) {
            wrapper.move = bestMove;
        }
        return alpha;
    }

    public abstract Difficulty getDifficulty();

    public abstract boolean isOver();

    public abstract void makeMove(M var1);

    public abstract void unmakeMove(M var1);

    public abstract List<M> getPossibleMoves();

    public abstract double evaluate();

    public abstract double maxEvaluateValue();

    public abstract void next();

    public abstract void previous();

    public static enum Algorithm {
        MINIMAX,
        ALPHA_BETA,
        NEGAMAX,
        NEGASCOUT;

    }

    private final class IAMoveWrapper {
        M move;

        private IAMoveWrapper() {
        }
    }
}

