/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo;

import android.content.Context;
import com.android.volley.VolleyError;
import fr.baloomba.feeligo.helper.FeeligoLog;
import fr.baloomba.feeligo.helper.FeeligoSettings;
import fr.baloomba.feeligo.model.Sticker;
import fr.baloomba.feeligo.model.StickerPack;
import fr.baloomba.feeligo.model.UserStickerPack;
import fr.baloomba.feeligo.network.RequestBuilder;
import fr.baloomba.wsvolley.WSManager;
import fr.baloomba.wsvolley.WSResponseListener;
import fr.baloomba.wsvolley.WSStringResponseListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Feeligo {
    private static final String TAG = Feeligo.class.getSimpleName();
    private static final String REG_EXP = "\\[s:([a-zA-Z0-9\\/\\.\\?\\=]+[a-zA-Z0-9]*)\\]";
    private static Feeligo sInstance;
    private String mUserId;
    private StickerPack mRecent;
    private StickerPack mPopular;
    private ArrayList<UserStickerPack> mUserStickerPacks = new ArrayList();

    public static Feeligo getInstance() {
        return sInstance;
    }

    public void init(Context context) {
        if (sInstance == null) {
            sInstance = this;
            FeeligoSettings.getInstance(context).init();
            if (WSManager.getInstance() == null) {
                new WSManager().init(context);
            }
        }
    }

    public void connect(String userId) {
        this.mUserId = userId;
        this.updateStickerPack();
        this.updateFeeligoFont();
    }

    public void updateStickerPack() {
        this.getRecentStickers((WSResponseListener)new WSStringResponseListener(){

            public void onResponse(String response) {
                try {
                    JSONObject object = new JSONObject(response);
                    JSONArray array = object.getJSONArray("stickers");
                    ArrayList<Sticker> stickers = new ArrayList<Sticker>();
                    for (int i = 0; i < array.length(); ++i) {
                        stickers.add(Sticker.Factory.getInstance().stickerFromJSON(array.getJSONObject(i)));
                    }
                    Feeligo.this.mRecent = StickerPack.Factory.getInstance().stickerPack(35, stickers);
                }
                catch (JSONException e) {
                    fr.baloomba.feeligo.FeeligoLog.e(TAG, "getRecentStickers.onResponse:" + e.getMessage());
                }
            }

            public void onErrorResponse(VolleyError error) {
                FeeligoLog.log(6, TAG, "getRecentStickers.onErrorResponse:" + error.getMessage());
            }
        });
        this.getPopularStickers((WSResponseListener)new WSStringResponseListener(){

            public void onResponse(String response) {
                try {
                    JSONObject object = new JSONObject(response);
                    JSONArray array = object.getJSONArray("stickers");
                    ArrayList<Sticker> stickers = new ArrayList<Sticker>();
                    for (int i = 0; i < array.length(); ++i) {
                        stickers.add(Sticker.Factory.getInstance().stickerFromJSON(array.getJSONObject(i)));
                    }
                    Feeligo.this.mPopular = StickerPack.Factory.getInstance().stickerPack(36, stickers);
                }
                catch (JSONException e) {
                    fr.baloomba.feeligo.FeeligoLog.e(TAG, "getPopularStickers.onResponse:" + e.getMessage());
                }
            }

            public void onErrorResponse(VolleyError error) {
                FeeligoLog.log(6, TAG, "getPopularStickers.onErrorResponse:" + error.getMessage());
            }
        });
        this.getUserStickerPack((WSResponseListener)new WSStringResponseListener(){

            public void onResponse(String response) {
                try {
                    JSONObject object = new JSONObject(response);
                    JSONArray array = object.getJSONArray("user_sticker_packs");
                    for (int i = 0; i < array.length(); ++i) {
                        Feeligo.this.mUserStickerPacks.add(UserStickerPack.Factory.getInstance().userStickerPackFromJSON(array.getJSONObject(i)));
                    }
                }
                catch (JSONException e) {
                    fr.baloomba.feeligo.FeeligoLog.e(TAG, "getUserStickerPack.onResponse:" + e.getMessage());
                }
            }

            public void onErrorResponse(VolleyError error) {
                FeeligoLog.log(6, TAG, "getUserStickerPack.onErrorResponse:" + error.getMessage());
            }
        });
    }

    private void updateFeeligoFont() {
    }

    public ArrayList<UserStickerPack> getUserStickerPack() {
        return this.mUserStickerPacks;
    }

    public boolean getRecentAvailable() {
        return FeeligoSettings.getRecentAvailable() != false && this.mRecent != null;
    }

    public StickerPack getRecentStickers() {
        return this.mRecent;
    }

    public boolean getPopularAvailable() {
        return FeeligoSettings.getPopularAvailable() != false && this.mPopular != null;
    }

    public StickerPack getPopularStickers() {
        return this.mPopular;
    }

    public boolean isStickerPackPresent(Long id) {
        for (UserStickerPack stickerPack : this.mUserStickerPacks) {
            if (!stickerPack.getStickerPack().getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public void getRecentStickers(WSResponseListener callbacks) {
        RequestBuilder.getRecentStickers(this.mUserId, callbacks);
    }

    public void getUserStickerPack(WSResponseListener callbacks) {
        RequestBuilder.getUserStickerPack(this.mUserId, callbacks);
    }

    public void getPopularStickers(WSResponseListener callbacks) {
        RequestBuilder.getPopularStickers(callbacks);
    }

    public void setRecentSticker(Long stickerId) {
        RequestBuilder.setRecentSticker(this.mUserId, stickerId, (WSResponseListener)new WSStringResponseListener(){

            public void onResponse(String response) {
            }

            public void onErrorResponse(VolleyError error) {
            }
        });
    }

    public void addStickerPack(StickerPack stickerPack, final WSResponseListener listener) {
        RequestBuilder.addUserStickerPack(this.mUserId, stickerPack.getId(), (WSResponseListener)new WSStringResponseListener(){

            public void onResponse(String response) {
                try {
                    JSONObject object = new JSONObject(response);
                    Feeligo.this.mUserStickerPacks.add(0, UserStickerPack.Factory.getInstance().userStickerPackFromJSON(object.getJSONObject("user_sticker_pack")));
                    listener.onResponse((Object)"");
                }
                catch (JSONException e) {
                    fr.baloomba.feeligo.FeeligoLog.e(TAG, e.getMessage());
                    listener.onErrorResponse(new VolleyError(e.getMessage()));
                }
            }

            public void onErrorResponse(VolleyError error) {
                fr.baloomba.feeligo.FeeligoLog.e(TAG, "addUserStickerPack:onErrorResponse" + error.getMessage());
                listener.onErrorResponse(error);
            }
        });
    }

    public void removeStickerPack(StickerPack stickerPack, final WSResponseListener listener) {
        UserStickerPack userStickerPack = null;
        for (UserStickerPack userSP : this.mUserStickerPacks) {
            if (!userSP.getStickerPack().getId().equals(stickerPack.getId())) continue;
            userStickerPack = userSP;
            break;
        }
        if (userStickerPack != null) {
            final UserStickerPack userSP = userStickerPack;
            RequestBuilder.removeUserStickerPack(this.mUserId, userSP.getId(), (WSResponseListener)new WSStringResponseListener(){

                public void onResponse(String response) {
                    Feeligo.this.mUserStickerPacks.remove(userSP);
                    listener.onResponse((Object)"");
                }

                public void onErrorResponse(VolleyError error) {
                    fr.baloomba.feeligo.FeeligoLog.e(TAG, "removeStickerPack:onErrorResponse" + error.getMessage());
                    listener.onErrorResponse(error);
                }
            });
        }
    }

    public static boolean containsSticker(String text) {
        return Pattern.compile(REG_EXP).matcher(text).find();
    }
}

