/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.viewpagerindicator.UnderlinePageIndicator;
import fr.baloomba.feeligo.Feeligo;
import fr.baloomba.feeligo.R;
import fr.baloomba.feeligo.helper.DisplayHelper;
import fr.baloomba.feeligo.helper.FeeligoSettings;
import fr.baloomba.feeligo.keyboard.FeeligoKeyboardListener;
import fr.baloomba.feeligo.keyboard.FeeligoKeyboardPageAdapter;
import fr.baloomba.feeligo.model.StickerPack;
import fr.baloomba.feeligo.model.UserStickerPack;
import fr.baloomba.feeligo.store.FeeligoStickerStoreActivity;
import java.util.ArrayList;

public class FeeligoKeyboard
extends Fragment {
    private static final String TAG = FeeligoKeyboard.class.getSimpleName();
    private static final String PREFERENCES_NAME = "Feeligo";
    private static final String LAST_POSITION = "lastPosition";
    private static final int LEFT = -1;
    private static final int UNKNOWN = 0;
    private static final int RIGHT = 1;
    private static LayoutInflater sInflater;
    private View mView;
    private ArrayList<StickerPack> mStickerPacks = new ArrayList();
    private FeeligoKeyboardPageAdapter mAdapter;
    private ViewPager mPager;
    private int mParentViewWidth = 0;
    private int mCellWidth = 0;
    private int mLastPosition = -1;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        sInflater = (LayoutInflater)this.getActivity().getSystemService("layout_inflater");
        this.mAdapter = new FeeligoKeyboardPageAdapter((Context)this.getActivity(), this.getChildFragmentManager());
        this.mAdapter.setData(this.mStickerPacks);
        this.mAdapter.setListener(new OnStickerClickListener(){

            @Override
            public void onStickerClick(String stickerCode) {
                if (FeeligoKeyboard.this.getActivity() instanceof FeeligoKeyboardListener) {
                    ((FeeligoKeyboardListener)FeeligoKeyboard.this.getActivity()).onStickerClick(stickerCode);
                }
            }
        });
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        sInflater = inflater;
        this.mView = sInflater.inflate(R.layout.fragment_keyboard, container, false);
        if (this.mView != null) {
            this.mParentViewWidth = DisplayHelper.getWidth((Activity)this.getActivity());
            this.mCellWidth = this.getActivity().getResources().getDimensionPixelSize(R.dimen.feeligo_sticker_keyboard_pack_item_size);
            if (FeeligoSettings.getStoreAvailable().booleanValue()) {
                this.mView.findViewById(R.id.frame_sticker_keyboard_store).setVisibility(0);
                this.mView.findViewById(R.id.frame_sticker_keyboard_store).setBackgroundColor(FeeligoSettings.getActiveColor());
                this.mView.findViewById(R.id.frame_sticker_keyboard_store).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeeligoKeyboard.this.goToStoreActivity();
                    }
                });
            } else {
                this.mView.findViewById(R.id.frame_sticker_keyboard_store).setVisibility(8);
            }
            this.mView.findViewById(R.id.feeligo_keyboard_search_layout).setVisibility(8);
            if (FeeligoSettings.getSearchAvailable().booleanValue()) {
                this.mView.findViewById(R.id.feeligo_keyboard_search).setVisibility(0);
            } else {
                this.mView.findViewById(R.id.feeligo_keyboard_search).setVisibility(8);
            }
            this.mPager = (ViewPager)this.mView.findViewById(R.id.fragment_keyboard_pager);
            this.mPager.setAdapter((PagerAdapter)this.mAdapter);
            UnderlinePageIndicator indicator = (UnderlinePageIndicator)this.mView.findViewById(R.id.keyboard_indicator);
            indicator.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                }

                public void onPageSelected(int position) {
                    FeeligoKeyboard.this.pageSelected(position);
                }

                public void onPageScrollStateChanged(int state) {
                }
            });
            indicator.setViewPager(this.mPager);
            indicator.setSelectedColor(FeeligoSettings.getActiveColor());
            indicator.setFades(false);
            this.getStickers();
        }
        return this.mView;
    }

    public void onStart() {
        super.onStart();
        this.getStickers();
    }

    public void show() {
        this.mView.findViewById(R.id.fragment_keyboard_main_layout).setVisibility(0);
        this.pageSelected(this.mLastPosition);
    }

    public void hide() {
        this.mView.findViewById(R.id.fragment_keyboard_main_layout).setVisibility(8);
    }

    public void toggle() {
        if (this.mView.findViewById(R.id.fragment_keyboard_main_layout).getVisibility() == 0) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void getStickers() {
        this.mStickerPacks.clear();
        if (Feeligo.getInstance().getRecentAvailable()) {
            this.mStickerPacks.add(Feeligo.getInstance().getRecentStickers());
        }
        if (Feeligo.getInstance().getPopularAvailable()) {
            this.mStickerPacks.add(Feeligo.getInstance().getPopularStickers());
        }
        ArrayList<UserStickerPack> stickerPacks = Feeligo.getInstance().getUserStickerPack();
        for (UserStickerPack stickerPack : stickerPacks) {
            this.mStickerPacks.add(stickerPack.getStickerPack());
        }
        this.updateStickerView();
    }

    private void updateStickerView() {
        LinearLayout stickerPacksLayout = (LinearLayout)this.mView.findViewById(R.id.frame_sticker_keyboard_pack_layout);
        stickerPacksLayout.removeAllViews();
        for (final StickerPack stickerPack : this.mStickerPacks) {
            View view = sInflater.inflate(R.layout.cell_sticker_pack_icon, (ViewGroup)stickerPacksLayout, false);
            if (view == null) continue;
            ((TextView)view.findViewById(R.id.cell_sticker_pack_icon_text_view)).setText((CharSequence)String.valueOf((char)stickerPack.getIconId()));
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FeeligoKeyboard.this.mView.findViewById(R.id.feeligo_keyboard_search_layout).setVisibility(8);
                    ((ViewPager)FeeligoKeyboard.this.mView.findViewById(R.id.fragment_keyboard_pager)).setCurrentItem(FeeligoKeyboard.this.mStickerPacks.indexOf(stickerPack));
                }
            });
            stickerPacksLayout.addView(view);
        }
        int pos = this.getActivity().getSharedPreferences(PREFERENCES_NAME, 0).getInt(LAST_POSITION, 0);
        if (pos == 0) {
            pos = Feeligo.getInstance().getRecentAvailable() ? pos + 1 : pos;
            pos = Feeligo.getInstance().getPopularAvailable() ? pos + 1 : pos;
        } else if (pos >= this.mStickerPacks.size()) {
            pos = this.mStickerPacks.size() - 1;
        }
        this.mAdapter.setData(this.mStickerPacks);
        this.mAdapter.notifyDataSetChanged();
        this.mPager.invalidate();
        this.mPager.setCurrentItem(pos);
        this.pageSelected(pos);
    }

    private void goToStoreActivity() {
        Intent intent = new Intent((Context)this.getActivity(), FeeligoStickerStoreActivity.class);
        this.getActivity().startActivity(intent);
    }

    private void pageSelected(int position) {
        this.getActivity().getSharedPreferences(PREFERENCES_NAME, 0).edit().putInt(LAST_POSITION, position).commit();
        if (this.mCellWidth != 0 && this.mParentViewWidth != 0) {
            int offset = 0;
            offset = FeeligoSettings.getStoreAvailable() != false ? offset + 1 : offset;
            offset = FeeligoSettings.getSearchAvailable() != false ? offset + 1 : offset;
            int scrollViewWidth = this.mParentViewWidth - offset * this.mCellWidth;
            int x = (int)Math.ceil((double)scrollViewWidth / (double)this.mCellWidth) - 2;
            int direction = 0;
            if (this.mLastPosition > position) {
                direction = -1;
            } else if (this.mLastPosition < position) {
                direction = 1;
            }
            int initialScrollX = this.mView.findViewById(R.id.frame_sticker_keyboard_horizontal_scroll_view).getScrollX();
            if (direction == -1) {
                int scrollX = (position - 1) * this.mCellWidth;
                if (initialScrollX > scrollX) {
                    ((HorizontalScrollView)this.mView.findViewById(R.id.frame_sticker_keyboard_horizontal_scroll_view)).smoothScrollTo(scrollX, 0);
                }
            } else {
                int scrollX = (position - x) * this.mCellWidth;
                if (initialScrollX < scrollX) {
                    ((HorizontalScrollView)this.mView.findViewById(R.id.frame_sticker_keyboard_horizontal_scroll_view)).smoothScrollTo(scrollX, 0);
                }
            }
        }
        this.mLastPosition = position;
    }

    public static interface OnStickerClickListener {
        public void onStickerClick(String var1);
    }
}

