/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.helper;

import android.content.Context;
import fr.baloomba.feeligo.R;
import fr.baloomba.feeligo.helper.FeeligoHelper;

public class FeeligoSettings {
    private static final String TAG = FeeligoSettings.class.getSimpleName();
    private static final String FEELIGO_DOMAIN_KEY = "com.feeligo.Domain";
    private static final String FEELIGO_ACTIVE_COLOR = "com.feeligo.Color";
    private static final String FEELIGO_STORE_AVAILABLE = "com.feeligo.StoreAvailable";
    private static final String FEELIGO_RECENT_STICKER_AVAILABLE = "com.feeligo.RecentStickerAvailable";
    private static final String FEELIGO_POPULAR_STICKER_AVAILABLE = "com.feeligo.PopularStickerAvailable";
    private static final String FEELIGO_SEARCH_STICKER_AVAILABLE = "com.feeligo.SearchStickerAvailable";
    private static FeeligoSettings sInstance;
    private Context mContext;
    private static String sDomain;
    private static int sActiveColor;
    private static Boolean sStoreAvailable;
    private static Boolean sRecentAvailable;
    private static Boolean sPopularAvailable;
    private static Boolean sSearchAvailable;

    public static FeeligoSettings getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new FeeligoSettings(context);
        }
        return sInstance;
    }

    public FeeligoSettings(Context context) {
        this.mContext = context;
    }

    public static String getDomain() {
        return sDomain;
    }

    public static int getActiveColor() {
        return sActiveColor;
    }

    public static Boolean getStoreAvailable() {
        return sStoreAvailable;
    }

    public static Boolean getRecentAvailable() {
        return sRecentAvailable;
    }

    public static Boolean getPopularAvailable() {
        return sPopularAvailable;
    }

    public static Boolean getSearchAvailable() {
        return sSearchAvailable;
    }

    public void init() {
        sDomain = (String)FeeligoHelper.retrieveData(this.mContext, FEELIGO_DOMAIN_KEY);
        try {
            sActiveColor = (Integer)FeeligoHelper.retrieveData(this.mContext, FEELIGO_ACTIVE_COLOR);
        }
        catch (Exception e) {
            sActiveColor = this.mContext.getResources().getColor(R.color.default_active_color);
        }
        sStoreAvailable = (Boolean)FeeligoHelper.retrieveData(this.mContext, FEELIGO_STORE_AVAILABLE, true);
        sRecentAvailable = (Boolean)FeeligoHelper.retrieveData(this.mContext, FEELIGO_RECENT_STICKER_AVAILABLE, true);
        sPopularAvailable = (Boolean)FeeligoHelper.retrieveData(this.mContext, FEELIGO_POPULAR_STICKER_AVAILABLE, false);
        sSearchAvailable = (Boolean)FeeligoHelper.retrieveData(this.mContext, FEELIGO_SEARCH_STICKER_AVAILABLE, false);
    }
}

