/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.helper;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;

public class ViewHelper {
    public static void setEnabledViewWithAlpha(View view, Boolean isEnabled) {
        float alpha = isEnabled != false ? 1.0f : 0.5f;
        view.setEnabled(isEnabled.booleanValue());
        ViewHelper.setAlpha(view, alpha);
    }

    public static void setAlpha(View view, float alpha) {
        if (alpha != 0.0f) {
            view.setVisibility(0);
            if (Build.VERSION.SDK_INT < 11) {
                AlphaAnimation animation = new AlphaAnimation(alpha, alpha);
                animation.setDuration(0L);
                animation.setFillAfter(true);
                view.startAnimation((Animation)animation);
            } else {
                view.setAlpha(alpha);
            }
        } else {
            view.setVisibility(8);
        }
    }

    public static void setBackground(View view, Drawable background) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(background);
        } else {
            view.setBackground(background);
        }
    }
}

