/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.keyboard;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import fr.baloomba.feeligo.Feeligo;
import fr.baloomba.feeligo.FeeligoKeyboard;
import fr.baloomba.feeligo.R;
import fr.baloomba.feeligo.model.Sticker;
import fr.baloomba.wsvolley.widget.NetworkImageView;
import java.util.ArrayList;

public class FeeligoKeyboardGridAdapter
extends BaseAdapter {
    private static final String TAG = FeeligoKeyboardGridAdapter.class.getSimpleName();
    private static LayoutInflater sInflater;
    private Context mContext;
    private ArrayList<Sticker> mData;
    private ViewHolder mHolder;
    private FeeligoKeyboard.OnStickerClickListener mListener;

    public int getCount() {
        return this.mData != null ? this.mData.size() : 0;
    }

    public Object getItem(int position) {
        return this.mData != null ? this.mData.get(position) : null;
    }

    public long getItemId(int position) {
        return this.mData.get(position).getId();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = sInflater.inflate(R.layout.cell_keyboard_grid_view, parent, false);
            if (convertView != null) {
                this.mHolder = new ViewHolder();
                this.mHolder.image = (NetworkImageView)convertView.findViewById(R.id.cell_keyboard_grid_view_image_view);
                convertView.setTag((Object)this.mHolder);
            }
        } else {
            this.mHolder = (ViewHolder)convertView.getTag();
        }
        this.setContent(this.mData.get(position));
        return convertView;
    }

    public void init(Context context) {
        sInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mContext = context;
    }

    public void setData(ArrayList<Sticker> data) {
        this.mData = data;
    }

    public void setListener(FeeligoKeyboard.OnStickerClickListener listener) {
        this.mListener = listener;
    }

    private void setContent(final Sticker sticker) {
        String url = sticker.getImage().getUrl(this.mContext);
        this.mHolder.image.setImageUrl(url);
        this.mHolder.image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Feeligo.getInstance().setRecentSticker(sticker.getId());
                if (FeeligoKeyboardGridAdapter.this.mListener != null) {
                    FeeligoKeyboardGridAdapter.this.mListener.onStickerClick(sticker.getSendableCode());
                }
            }
        });
    }

    private static class ViewHolder {
        NetworkImageView image;

        private ViewHolder() {
        }
    }
}

