/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.model;

import android.os.Parcel;
import android.os.Parcelable;
import fr.baloomba.feeligo.helper.JSONHelper;
import fr.baloomba.feeligo.model.StickerImage;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Sticker
implements Parcelable {
    private static final String TAG = Sticker.class.getSimpleName();
    private Long mId;
    private String mSendableCode;
    private ArrayList<String> mTags;
    private String mImageURL;
    private StickerImage mImage;
    public static final Parcelable.Creator<Sticker> CREATOR = new Parcelable.Creator<Sticker>(){

        public Sticker createFromParcel(Parcel in) {
            return new Sticker(in);
        }

        public Sticker[] newArray(int size) {
            return new Sticker[size];
        }
    };

    public Sticker(Init<?> builder) {
        this.mId = ((Init)builder).mId;
        this.mSendableCode = ((Init)builder).mSendableCode;
        this.mTags = ((Init)builder).mTags;
        this.mImageURL = ((Init)builder).mImageURL;
        this.mImage = ((Init)builder).mImage;
    }

    public Sticker(Parcel in) {
        this.mId = in.readLong();
        this.mSendableCode = in.readString();
        this.mTags = null;
        int size = in.readInt();
        if (size != 0) {
            this.mTags = new ArrayList();
            for (int i = 0; i < size; ++i) {
                this.mTags.add(in.readString());
            }
        }
        this.mImageURL = in.readString();
        this.mImage = (StickerImage)in.readParcelable(StickerImage.class.getClassLoader());
    }

    public void setId(Long id2) {
        this.mId = id2;
    }

    public void setSendableCode(String code) {
        this.mSendableCode = code;
    }

    public void setTags(ArrayList<String> tags) {
        this.mTags = tags;
    }

    public void setImageURL(String url) {
        this.mImageURL = url;
    }

    public void setImages(StickerImage image) {
        this.mImage = image;
    }

    public Long getId() {
        return this.mId;
    }

    public String getSendableCode() {
        return this.mSendableCode;
    }

    public ArrayList<String> getTags() {
        return this.mTags;
    }

    public String getImageURL() {
        return this.mImageURL;
    }

    public StickerImage getImage() {
        return this.mImage;
    }

    public String getMessage() {
        return this.mImage.getMessage();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mId.longValue());
        dest.writeString(this.mSendableCode);
        dest.writeInt(this.mTags != null ? this.mTags.size() : 0);
        if (this.mTags != null) {
            for (String tag : this.mTags) {
                dest.writeString(tag);
            }
        }
        dest.writeString(this.mImageURL);
        dest.writeParcelable((Parcelable)this.mImage, flags);
    }

    public static class Builder
    extends Init<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }

    protected static abstract class Init<T extends Init<T>> {
        private Long mId = -1L;
        private String mSendableCode = "";
        private ArrayList<String> mTags = null;
        private String mImageURL = "";
        private StickerImage mImage = null;

        public T setId(Long id2) {
            this.mId = id2;
            return this.self();
        }

        public T setSendableCode(String code) {
            this.mSendableCode = "[s:p/" + code.split("/")[1] + "]";
            return this.self();
        }

        public T setTags(ArrayList<String> tags) {
            this.mTags = tags;
            return this.self();
        }

        public T setImageURL(String url) {
            this.mImageURL = url;
            this.setSendableCode(url.split("http://stkr.es/")[1]);
            return this.self();
        }

        public T setImages(StickerImage image) {
            this.mImage = image;
            return this.self();
        }

        protected abstract T self();

        public Sticker build() {
            return new Sticker(this);
        }
    }

    public static class Factory {
        private static Factory sInstance = new Factory();

        public static Factory getInstance() {
            return sInstance;
        }

        public Sticker stickerFromJSON(JSONObject object) throws JSONException {
            if (object == null) {
                return null;
            }
            ArrayList<String> tags = null;
            if (object.has("tags")) {
                tags = new ArrayList<String>();
                JSONArray array = object.getJSONArray("tags");
                for (int i = 0; i < array.length(); ++i) {
                    tags.add(array.getString(i));
                }
            }
            return ((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setId(object.getLong("id"))).setSendableCode(object.getString("image_url"))).setTags(tags)).setImageURL(object.getString("image_url"))).setImages(StickerImage.Factory.getInstance().stickerImageFromJSON(JSONHelper.getJSONObject(object, "image")))).build();
        }

        public Sticker sticker(String text) {
            Sticker sticker = null;
            Pattern pattern = Pattern.compile("\\[s:([a-zA-Z0-9\\/\\.\\?\\=]+[a-zA-Z0-9]*)\\]");
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                String code = matcher.group(1).split("/")[1];
                sticker = ((Builder)((Builder)new Builder().setSendableCode(code)).setImages(StickerImage.Factory.getInstance().stickerImage(code))).build();
            }
            return sticker;
        }
    }
}

