/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import fr.baloomba.feeligo.R;
import fr.baloomba.feeligo.helper.JSONHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class StickerImage
implements Parcelable {
    public static final int SMALL = 0;
    public static final int MEDIUM = 1;
    public static final int LARGE = 2;
    private static final String BASE_URL = "http://stkr.es/";
    private static final String SMALL_PREFIX = "p/";
    private static final String MEDIUM_PREFIX = "p3w/";
    private static final String LARGE_PREFIX = "p7s/";
    private String mCode;
    private String mSmallURL;
    private Boolean mSmallImageAvailable;
    private String mMediumURL;
    private Boolean mMediumImageAvailable;
    private String mLargeURL;
    private Boolean mLargeImageAvailable;
    public static final Parcelable.Creator<StickerImage> CREATOR = new Parcelable.Creator<StickerImage>(){

        public StickerImage createFromParcel(Parcel source) {
            return new StickerImage(source);
        }

        public StickerImage[] newArray(int size) {
            return new StickerImage[size];
        }
    };

    protected StickerImage(Init<?> builder) {
        this.mSmallURL = ((Init)builder).mSmallURL;
        this.mSmallImageAvailable = ((Init)builder).mSmallImageAvailable;
        this.mMediumURL = ((Init)builder).mMediumURL;
        this.mMediumImageAvailable = ((Init)builder).mMediumImageAvailable;
        this.mLargeURL = ((Init)builder).mLargeURL;
        this.mLargeImageAvailable = ((Init)builder).mLargeImageAvailable;
    }

    protected StickerImage(Parcel in) {
        this.mSmallURL = in.readString();
        this.mSmallImageAvailable = in.readInt() == 1;
        this.mMediumURL = in.readString();
        this.mMediumImageAvailable = in.readInt() == 1;
        this.mLargeURL = in.readString();
        this.mLargeImageAvailable = in.readInt() == 1;
    }

    public String getSmallURL() {
        return this.mSmallURL;
    }

    public String getMediumURL() {
        return this.mMediumImageAvailable != false ? this.mMediumURL : this.getSmallURL();
    }

    public String getLargeURL() {
        return this.mLargeImageAvailable != false ? this.mLargeURL : this.getMediumURL();
    }

    public String getURL(int size) {
        switch (size) {
            case 1: {
                return this.getMediumURL();
            }
            case 2: {
                return this.getLargeURL();
            }
        }
        return this.getSmallURL();
    }

    public String getUrl(Context context) {
        int density = context.getResources().getInteger(R.integer.density);
        switch (density) {
            case 1: {
                return this.getMediumURL();
            }
            case 2: {
                return this.getLargeURL();
            }
        }
        return this.getSmallURL();
    }

    public String getMessage() {
        return "[s:p/" + this.mCode + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mSmallURL);
        parcel.writeInt(this.mSmallImageAvailable != false ? 1 : 0);
        parcel.writeString(this.mMediumURL);
        parcel.writeInt(this.mMediumImageAvailable != false ? 1 : 0);
        parcel.writeString(this.mLargeURL);
        parcel.writeInt(this.mLargeImageAvailable != false ? 1 : 0);
    }

    public static class Builder
    extends Init<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }

    protected static abstract class Init<T extends Init<T>> {
        private String mCode = null;
        private String mSmallURL = null;
        private String mMediumURL = null;
        private String mLargeURL = null;
        private Boolean mSmallImageAvailable = false;
        private Boolean mMediumImageAvailable = false;
        private Boolean mLargeImageAvailable = false;

        public T setSmallURL(String smallURL) {
            if (smallURL == null) {
                return this.self();
            }
            this.mSmallImageAvailable = true;
            this.mSmallURL = smallURL;
            return this.self();
        }

        public T setMediumURL(String mediumURL) {
            if (mediumURL == null) {
                return this.self();
            }
            this.mMediumImageAvailable = true;
            this.mMediumURL = mediumURL;
            return this.self();
        }

        public T setLargeURL(String largeURL) {
            if (largeURL == null) {
                return this.self();
            }
            this.mLargeImageAvailable = true;
            this.mLargeURL = largeURL;
            return this.self();
        }

        protected abstract T self();

        public StickerImage build() {
            return new StickerImage(this);
        }
    }

    public static class Factory {
        private static Factory sInstance = new Factory();
        private static final String JSON_KEY_SIZES = "sizes";
        private static final String SMALL_JSON_KEY = "70x70";
        private static final String MEDIUM_JSON_KEY = "140x140";
        private static final String LARGE_JSON_KEY = "280x280";

        public static Factory getInstance() {
            return sInstance;
        }

        public StickerImage stickerImageFromJSON(JSONObject object) throws JSONException {
            if (object == null) {
                return null;
            }
            if ((object = JSONHelper.getJSONObject(object, JSON_KEY_SIZES)) == null) {
                return null;
            }
            Builder builder = new Builder();
            if (object.has(SMALL_JSON_KEY)) {
                builder.setSmallURL(JSONHelper.getString(object, SMALL_JSON_KEY));
            }
            if (object.has(MEDIUM_JSON_KEY)) {
                builder.setMediumURL(JSONHelper.getString(object, MEDIUM_JSON_KEY));
            }
            if (object.has(LARGE_JSON_KEY)) {
                builder.setLargeURL(JSONHelper.getString(object, LARGE_JSON_KEY));
            }
            return builder.build();
        }

        public StickerImage stickerImage(String code) {
            return ((Builder)((Builder)((Builder)new Builder().setSmallURL("http://stkr.es/p/" + code)).setMediumURL("http://stkr.es/p3w/" + code)).setLargeURL("http://stkr.es/p7s/" + code)).build();
        }
    }
}

